<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;



class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */

    // protected $redirectTo = RouteServiceProvider::HOME;
    // protected $redirectTo = '/admin/dashboard';

    public function authenticated(Request $request, $user)  {

         $userRole = auth::user()->getRoleNames()->first();
         


        // if($user->hasRole('Admin')){
        //     return redirect('/admin/dashboard');}
  
        // else if($user->hasRole('buyer')){
        //     return redirect('/relocate_apartments');
        // } else {
        //     return redirect('/');
        // }

        if($userRole == 'Admin'){
            return redirect('/admin/dashboard');
        } else if($userRole == 'buyer'){
            return redirect('/relocate_apartments');
        } else if($userRole == 'manager'){
            return redirect('/admin/dashboard');
        } else {
            return redirect('/');
        }
    }


    


   


    

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
}
