<?php

namespace App\Http\Controllers\BackEnd\Ammenities;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Amenity;
use App\Http\Requests\Ammenities\StoreAmmenityRequest;
use App\Http\Requests\Ammenities\UpdateAmmenityRequest;

class AmmentityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $amenities = Amenity::all();
        $count_amenities = Amenity::all()->count();
        // dd($count_ammenities);
        return view('backend.pages_backend.ammenities.index',compact('amenities','count_amenities'));
    }

     // trashed amenities
     public function trashed_amenities(){
        $trashedAmenities = Amenity::onlyTrashed()->get();
        $countTrashedAmenities = Amenity::onlyTrashed()->count();
        // dd($countTrashedAmenities);

        return view('backend.pages_backend.ammenities.trashed_amenities',compact('trashedAmenities','countTrashedAmenities'));

    }

    // restore trashed amenities
    public function restore_trashed_amenities($id){
        $restore_trashed_amenity = Amenity::where('id', $id)->withTrashed()->restore();
        return redirect('/admin/amenities')->with('messagerestore','Amenity Restored successfuly');


    }
   
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        return view('backend.pages_backend.ammenities.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAmmenityRequest $request)
    {
       
        $amenity = new Amenity();
        $amenity->name = $request->name;
        $amenity->description = $request->description;

        // dd($amenity);
        $amenity->save();

        return redirect('/admin/amenities')->with('messagesave','Amenity added successfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAmmenityRequest $request, $id)
    {
        $amenity = Amenity::find($id);
        $amenity->name = $request->name;
        $amenity->description = $request->description;

        // dd($amenity);
        $amenity->save();

        return redirect('/admin/amenities')->with('messageupdate','Amenity Update successfuly');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ammenity = Amenity::find($id);
        $ammenity->delete();
        return redirect('/admin/amenities')->with('messagedelete','Amenity Deleted successfuly');


    }
}
