<?php

namespace App\Http\Controllers\BackEnd\TourCategories;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TourCategory;

class TourCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tour_categories = TourCategory::all();
        $count_tour_categories = TourCategory::all()->count();
        return view('backend.pages_backend.tour_categories.index',compact('tour_categories','count_tour_categories'));
    
    }

    public function trashed_tour_categories(){
        $trashed_tour_categories = tourCategory::onlyTrashed()->get();
        $count_trashed_tour_categories = TourCategory::onlyTrashed()->count();
        // dd($trashed_tour_categories);
        return view('backend.pages_backend.tour_categories.trashed_tour_categories',compact('count_trashed_tour_categories','trashed_tour_categories'));

    }

    // restore trashed 
    public function restore_trashed_tour_categories($id){
        $restore_trashed_category = TourCategory::where('id', $id)->withTrashed()->restore();
        return redirect('/admin/tour_categories')->with('messagerestore','tour Category Restored successfuly');

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages_backend.tour_categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $tour_category = new TourCategory();
        $tour_category->name = $request->name;
        $tour_category->description = $request->description;
        $tour_category->created_by = auth()->user()->id;

        // dd($tour_category->toArray());
        $tour_category->save();

        return redirect('/admin/tour_categories')->with('messagesave', 'Tour category added successfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $tour_category =  TourCategory::find($id);
        $tour_category->name = $request->name;
        $tour_category->description = $request->description;
        $tour_category->created_by = auth()->user()->id;

        // dd($tour_category->toArray());
        $tour_category->save();

        return redirect('/admin/tour_categories')->with('messageupdate', 'Tour category added successfuly');
    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tour_category = TourCategory::find($id);
        $tour_category->delete();
        return redirect('/admin/tour_categories')->with('messagedelete','Tour category Deleted successfuly');
    }
}
