<?php

namespace App\Http\Requests\ApartmentCategories;

use Illuminate\Foundation\Http\FormRequest;

class UpdateApartmentCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required|unique:category,name',
        ];
    }

     // custom messages
     public function messages(): array
     {
         return [
             'name.required' => 'Please enter the category name',
            //  'description' => 'nullable'
             
         ];
     }
}
