<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AdminTourBookingNotification extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

     public $admin_tour_booking_data;

    public function __construct($admin_tour_booking_data)
    {
        $this->admin_tour_booking_data = $admin_tour_booking_data;
    }

    // send email data to view
    public function build()
    {
        return $this->subject('Admin : New Tour Booking from Relocacate Portal')
            ->view('frontend.pages_frontend.emails.tours.admin_tour_booking_notification')
            ->with('admin_tour_booking_data', $this->admin_tour_booking_data);
    }
    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    // public function envelope()
    // {
    //     return new Envelope(
    //         subject: 'Admin Tour Booking Notification',
    //     );
    // }

    // /**
    //  * Get the message content definition.
    //  *
    //  * @return \Illuminate\Mail\Mailables\Content
    //  */
    // public function content()
    // {
    //     return new Content(
    //         markdown: 'AdminTourBookingNotification',
    //     );
    // }

    // /**
    //  * Get the attachments for the message.
    //  *
    //  * @return array
    //  */
    // public function attachments()
    // {
    //     return [];
    // }
}
