<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class UserApartmentBookingNotification extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $user_apartment_booking_feedback;

    public function __construct($user_apartment_booking_feedback)
    {
        $this->user_apartment_booking_feedback = $user_apartment_booking_feedback;
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    //  user_apartment_booking_notification.blade
    public function build()
    {
        return $this->subject('Success : Booking An Apartment')
            ->view('frontend.pages_frontend.emails.user_apartment_booking_notification')
            ->with('user_apartment_booking_feedback', $this->user_apartment_booking_feedback);
    }

    // public function envelope()
    // {
    //     return new Envelope(
    //         subject: 'User Apartment Booking Notification',
    //     );
    // }

    // /**
    //  * Get the message content definition.
    //  *
    //  * @return \Illuminate\Mail\Mailables\Content
    //  */
    // public function content()
    // {
    //     return new Content(
    //         view: 'view.name',
    //     );
    // }

    // /**
    //  * Get the attachments for the message.
    //  *
    //  * @return array
    //  */
    // public function attachments()
    // {
    //     return [];
    // }
}
