<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
// login activity
use Haruncpi\LaravelUserActivity\Traits\Loggable;


class Apartment extends Model
{
    use HasFactory,SoftDeletes, Loggable;
    protected $dates = ['deleted_at'];

    protected $fillables = [
        'photo_library_photo_caption',
    ];

    
    public function user(){
        return $this->belongsTo(User::class,'created_by');
    }

    // apartment belongs to category
    public function apartment_category(){

        return $this->belongsTo(ApartmentCategory::class,'apartment_category_id');

    }

    // many to many relationship with amenities
    public function amenities()
    {
        return $this->belongsToMany(Amenity::class);
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }

    public function apartment_proximity(){
        // foreign key // local key
        return $this->hasMany(ApartmentProximity::class,'id','id');
    }
}
