<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Haruncpi\LaravelUserActivity\Traits\Loggable;

class Tour extends Model
{
    use HasFactory,SoftDeletes, Loggable;
    protected $dates = ['deleted_at'];

    
    public function user(){
        return $this->belongsTo(User::class,'created_by');
    }

    // tour belongs to tour category
    public function tour_category(){

        return $this->belongsTo(TourCategory::class);

    }

    public function tour_bookings()
    {
        return $this->hasMany(TourBooking::class);
    }
}
