<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
// login activity
use Haruncpi\LaravelUserActivity\Traits\Loggable;
class TourBooking extends Model
{
    use HasFactory,SoftDeletes, Loggable;
      // booking belongs to an apartment
      public function tour()
      {
          return $this->belongsTo(Tour::class);
      }
  
      // booking belongs to a user
      public function user()
      {
          return $this->belongsTo(User::class, 'created_by');
      }
  
}
