<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
// login activity
use Haruncpi\LaravelUserActivity\Traits\Loggable;

class TourCategory extends Model
{
    use HasFactory, SoftDeletes, Loggable;
    protected $dates = ['deleted_at'];

    // tour category belongs to a user
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // tour category has many tours
    public function tours()
    {
        return $this->hasMany(Tour::class);
    }
}
