<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use App\Models\EmergencyCase;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Spatie\Permission\Models\Role;
use App\Http\Requests\Users\StoreUserRequest;
// use App\Http\Requests\Users\UpdateUserRequest;
use Illuminate\Http\Request;

use Hash;


// login activity
use Haruncpi\LaravelUserActivity\Traits\Loggable;


class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles, Loggable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'religion',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];



    // relationship
  

   /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier() {
        return $this->getKey();
    }

   /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    
    public function getJWTCustomClaims() {
        return [];
    }  

    // getAllUsers
    public static function get_all_users(){
        // pick all users
        $users = self::orderBy('id','DESC')->paginate(100);
        return $users;
    }

    // create users
    public static function store_user(StoreUserRequest $request){
        // pick all fields from request
        $input = $request->all();
        $input['password'] = Hash::make($input['password']);

        // capture user
        $user = self::create($input);
        

        return $user;

    }

    //get single user by id
    public static function get_user_by_id($id){
        $user = User::findOrFail($id);
        return $user;
    }

    // update user
    public static function update_user(Request $request, $id){

        // $input = $request()->validate()->all();
        // if(!empty($input['password'])){
        //     $input['password'] = Hash::make($input['password']);
        // }else{
        //     $input = Arr::except($input,array('password'));
        // }

        // $user = self::find($id);
        // $user->update($input);
        // DB::table('model_has_roles')->where('model_id',$id)->delete();

        // $user->assignRole($request->input('roles'));
        // return $user;

    }
    


    // relationships
    public function amenities(){
        return $this->hasMany(Amenity::class);
    }

}
