<?php

namespace App\Observers;

use App\Models\ApartmentCategory;

class ApartmentCategoryObserver
{
    /**
     * Handle the ApartmentCategory "created" event.
     *
     * @param  \App\Models\ApartmentCategory  $apartmentCategory
     * @return void
     */

    
     public function creating(ApartmentCategory $apartmentCategory)
     {
        $apartmentCategory->created_by = auth()->user()->id;
     }

    public function created(ApartmentCategory $apartmentCategory)
    {
        //
    }

    /**
     * Handle the ApartmentCategory "updated" event.
     *
     * @param  \App\Models\ApartmentCategory  $apartmentCategory
     * @return void
     */
    public function updated(ApartmentCategory $apartmentCategory)
    {
        //
    }

    /**
     * Handle the ApartmentCategory "deleted" event.
     *
     * @param  \App\Models\ApartmentCategory  $apartmentCategory
     * @return void
     */
    public function deleted(ApartmentCategory $apartmentCategory)
    {
        //
    }

    /**
     * Handle the ApartmentCategory "restored" event.
     *
     * @param  \App\Models\ApartmentCategory  $apartmentCategory
     * @return void
     */
    public function restored(ApartmentCategory $apartmentCategory)
    {
        //
    }

    /**
     * Handle the ApartmentCategory "force deleted" event.
     *
     * @param  \App\Models\ApartmentCategory  $apartmentCategory
     * @return void
     */
    public function forceDeleted(ApartmentCategory $apartmentCategory)
    {
        //
    }
}
