<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tours', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tour_category_id')->constrained('tour_categories');
            $table->text('name')->nullable();
            $table->text('description')->nullable();
            $table->text('destination')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('tour_single_cost')->nullable();
            $table->integer('tour_couple_cost')->nullable();
            $table->json('tour_includes')->nullable();
            $table->json('tour_excludes')->nullable();
            // $table->integer('tour_availability')->nullable();
            $table->integer('tour_status')->nullable();
            $table->integer('booking_status')->nullable();
            $table->integer('slots_available')->nullable();
            $table->text('featured_photo')->nullable();
            $table->text('photo_library')->nullable();
            $table->text('video_url')->nullable();
            // $table->text('comment')->nullable();
            $table->foreignId('created_by')->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tours');
    }
};
