@extends('backend.layouts_backend.master')

@section('title')
    All Activity Logs
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">All Activity Logs <span
                                class="text-muted fw-normal ms-2"></span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>

                            <a href="last_logged_activity" class="btn bg-primary text-light"><i
                                class="bx bx-plus me-1"></i>
                            Last Logged activity</a>

                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->








            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>


                            <th scope="col">#Id</th>
                            <th scope="col">Logged On</th>
                            <th scope="col">Database Table</th>
                            <th scope="col">Properties</th>


                            <th style="width: 150px; min-width: 80px;">Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($all_activity_logs as $activity_log)

                        {{-- Fetch activity logs --}}
                            <tr>
                                <td>
                                    <a href="#" class="text-body">{{ $activity_log->id }}</a>
                                </td>

                                <td>
                                    <a href="#" class="text-body">{{ $activity_log->created_at }}</a>
                                </td>
                                <td>
                                    <a href="#" class="text-body">{{ $activity_log->subject_type }}</a>
                                </td>
                                <td>
                                    <a href="#" class="text-body">{{ $activity_log->properties }}</a>
                                </td>







                                {{-- actions --}}
                                <td colspan="6">
                                    <div class="row">

                                        @can('activity_log-list')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#viewLogDetails{{ $activity_log->id }}"
                                                data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                        </div>
                                        @endcan




                                        <!-- delete  -->


                                            {{-- <div class="col-md-4">
                                                <form action="" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div> --}}



                                    </div>
                                </td>



                            </tr>

                        {{-- View activity log details --}}
                         <!-- VIEW DETAILS MODEL -->
                         <div class="modal fade" id="viewLogDetails{{ $activity_log->id }}" tabindex="-1"
                            aria-labelledby="viewLogDetailsLabel" style="display: none;" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-scrollable">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="viewLogDetailsLabel"> District
                                            Details</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>



                                    <div class="modal-body">



                                        <p>Log ID : {{ $activity_log->id }}</p>
                                        <hr>
                                        <p>Properties : {{ $activity_log->properties }}</p>
                                        <hr>
                                        <p>Description : {{ $activity_log->description }}</p>
                                        <hr>



                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                        </button>


                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- END OF VIEW DETAILS MODEL -->




                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No Log available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
