@extends('backend.layouts_backend.master')

@section('title')
    All Apartments
@endsection


@section('extra_styles')
    <style>
        /* multiple photo upload - environmental activities css */
        .imagePreview {
            width: 100%;
            height: 300px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            1 display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            width: 80px;
            height: 40px;
            padding-top: 3px;
            padding-left: 8px;
            padding-right: 8px;
            background-color: #f60909;
            color: #ffffff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .imgAdd {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .dell {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #ca078c;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        /* end of multiple photo upload - environmental activities css */
    </style>
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Apartments <span
                                class="text-muted fw-normal ms-2">({{ $count_apartments }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('apartment-create')
                                <a href="/admin/apartments/create" class="btn bg-primary text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Add Apartment</a>
                            @endcan
                        </div>

                        <div>
                            @can('apartment-restore')
                                <a href="{{ route('apartments.trashed') }}" class="btn bg-danger text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Trashed Apartments</a>
                            @endcan
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH apartments -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert restore item --}}
            @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            {{-- <th scope="col">#ID</th> --}}
                            <th scope="col"> Unique ID</th>
                            <th scope="col">Apartment Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Units Available</th>
                            <th scope="col">Price</th>
                            <th scope="col">Price Range</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($apartments as $apartment)
                            <tr>

                                {{-- <td>{{ $apartment->id }}</td> --}}
                                <td>{{ $apartment->unique_id }}</td>

                                <td>
                                    @if (!empty($apartment->name))
                                        {{ $apartment->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($apartment->apartment_category->category_name))
                                        {{ $apartment->apartment_category->category_name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($apartment->units_available))
                                        {{ $apartment->units_available }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>


                                <td>
                                    @if (!empty($apartment->price))
                                        {{ $apartment->price }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>

                                <td>


                                    @if (!empty($apartment->price_range))
                                        @if ($apartment->price_range == '1000_2000')
                                            {{ '1000 - 2000 ' }}
                                        @endif

                                        @if ($apartment->price_range == '2000_3000')
                                            {{ '2000 - 3000' }}
                                        @endif

                                        @if ($apartment->price_range == '3000_4000')
                                            {{ '3000 - 4000' }}
                                        @endif

                                        @if ($apartment->price_range == '4000_5000')
                                            {{ '4000 - 5000' }}
                                        @endif

                                        @if ($apartment->price_range == 'null')
                                            {{ 'N/A' }}
                                        @endif
                                    @else
                                        <span> N/A </span>
                                    @endif

                                </td>
                                <td>
                                    @if (!empty($apartment->user->name))
                                        {{ $apartment->user->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        @can('apartment-show')
                                            <div class="col-md-4">
                                                <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                    data-bs-target="#viewapartmentDetails{{ $apartment->id }}"
                                                    data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                            </div>
                                        @endcan

                                        {{-- edit --}}
                                        @can('apartment-edit')
                                            <div class="col-md-4">
                                                <a href="{{ route('apartments.edit', $apartment->id) }}"><button type="button"
                                                    class="btn btn-info"><i class="fas fa-pencil-alt "></i>
                                                </button></a>
                                                {{-- <button type="button" class="btn btn-info" data-bs-toggle="modal"
                                                    data-bs-target="#editapartment{{ $apartment->id }}"
                                                    data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button> --}}

                                            </div>
                                        @endcan

                                        <!-- delete  -->

                                        @can('apartment-delete')
                                            <div class="col-md-4">
                                                <form action="{{ route('apartments.destroy', $apartment->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        @endcan


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewapartmentDetails{{ $apartment->id }}" tabindex="-1"
                                aria-labelledby="viewapartmentDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel"> Apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            {{-- featured photo --}}
                                            <p>Featured Photo </p>
                                            <hr>

                                            <a href="{!! asset($apartment->featured_photo) !!}">
                                                <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                    src="{{ asset($apartment->featured_photo) }}" alt="preview"
                                                    style=" width:100% !important; object-fit:cover;">
                                            </a>
                                            <hr>

                                            <p> Property Name :
                                                @if (!empty($apartment->name))
                                                    {{ $apartment->name }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>


                                            <p> Unique ID :
                                                @if (!empty($apartment->unique_id))
                                                    {{ $apartment->unique_id }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Created By :
                                                @if (!empty($apartment->user->name))
                                                    {{ $apartment->user->name }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> Address :
                                                @if (!empty($apartment->address))
                                                    {{ $apartment->address }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> City :
                                                @if (!empty($apartment->city))
                                                    {{ $apartment->city }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> Beds :
                                                @if (!empty($apartment->beds))
                                                    {{ $apartment->beds }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> Size :
                                                @if (!empty($apartment->size))
                                                    {{ $apartment->size }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Rooms :
                                                @if (!empty($apartment->rooms))
                                                    {{ $apartment->rooms }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Bathrooms :
                                                @if (!empty($apartment->bathrooms))
                                                    {{ $apartment->bathrooms }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Balcony :
                                                @if ($apartment->property_booked_status == 1)
                                                    Available
                                                @elseif($apartment->property_booked_status == 0)
                                                    Booked
                                                @else
                                                    N/A
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Property Booked Status :
                                                @if ($apartment->property_booked_status == 1)
                                                    Available
                                                @elseif($apartment->property_booked_status == 0)
                                                    Booked
                                                @else
                                                    N/A
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Property Status :
                                                @if ($apartment->property_status == 1)
                                                    Active
                                                @elseif($apartment->property_status == 0)
                                                    De-activated
                                                @else
                                                    N/A
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Price :
                                                @if (!empty($apartment->price))
                                                    {{ $apartment->price }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Price Range :
                                                @if (!empty($apartment->price_range))
                                                    @if ($apartment->price_range == '1000_2000')
                                                        {{ '1000 - 2000 ' }}
                                                    @endif

                                                    @if ($apartment->price_range == '2000_3000')
                                                        {{ '2000 - 3000' }}
                                                    @endif

                                                    @if ($apartment->price_range == '3000_4000')
                                                        {{ '3000 - 4000' }}
                                                    @endif

                                                    @if ($apartment->price_range == '4000_5000')
                                                        {{ '4000 - 5000' }}
                                                    @endif

                                                    @if ($apartment->price_range == '5000_6000')
                                                        {{ '5000 - 6000' }}
                                                    @endif

                                                    @if ($apartment->price_range == '6000_7000')
                                                        {{ '6000 - 7000' }}
                                                    @endif

                                                    @if ($apartment->price_range == '7000_8000')
                                                        {{ '7000 -8000' }}
                                                    @endif

                                                    @if ($apartment->price_range == '')
                                                        {{ 'N/A' }}
                                                    @endif
                                                @else
                                                    <span> N/A </span>
                                                @endif
                                            </p>
                                            <hr>



                                            {{-- apartment proximities --}}
                                            <div class="card" style="margin-top:20px;">
                                                <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                                    <center>Apartment Proximities</center>
                                                </div>
                                                @php
                                        // pick proximities in each category
                                        $apartment_proximities_data = !empty($apartment->apartment_proximities) ? json_decode($apartment->apartment_proximities, true): [];
                                        // pick data
                                        $restaurants_nearyby = collect($apartment_proximities_data)->where('place_category','restaurant');
                                        $shopping_malls_nearby = collect($apartment_proximities_data)->where('place_category','shopping_mall');
                                        $police_station_nearby = collect($apartment_proximities_data)->where('place_category','police_station');
                                        $schools_nearby = collect($apartment_proximities_data)->where('place_category','school');
                                        $hospitals_nearby = collect($apartment_proximities_data)->where('place_category','hospital');
                                        $sports_grounds_nearby = collect($apartment_proximities_data)->where('place_category','sports_ground');
                                        $christian_worship_places_nearby = collect($apartment_proximities_data)->where('place_category','christian_worship_place');
                                        $moslem_worship_places_nearby = collect($apartment_proximities_data)->where('place_category','moslem_worship_place');

                                        

                                    @endphp

                                                <div class="card-body">

                                                    {{-- restaurant proximity --}}
                                                    <div class="row">
                                                        {{-- @php
                                                            // pick proximities in each category
                                                            $restaurants_nearyby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'restaurant',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();
                                                            $shopping_malls_nearby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'shopping_mall',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();
                                                            $police_station_nearby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'police_station',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();
                                                            $schools_nearby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'school',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();
                                                            $hospitals_nearby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'hospital',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();
                                                            $sports_grounds_nearby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'sports_ground',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();
                                                            $christian_worship_places_nearby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'christian_worship_place',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();
                                                            $moslem_worship_places_nearby = \App\Models\ApartmentProximity::where(
                                                                'place_category',
                                                                'moslem_worship_place',
                                                            )
                                                                ->where('apartment_id', $apartment->id)
                                                                ->get();

                                                        @endphp --}}

                                                        {{-- restaurants nearby --}}
                                                        @if (count($restaurants_nearyby) > 0)
                                                            <p><b>RESTAURANTS NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($restaurants_nearyby as $key => $restaurant)
                                                                <li>
                                                                    Name : {{ $restaurant['place_name'] }}
                                                                    | Distance : | {{ $restaurant['place_distance'] }}
                                                                    Time
                                                                    : {{ $restaurant['place_time'] }}
                                                                    | Address : {{ $restaurant['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Restaurants Nearby </span>
                                                            </center>
                                                        @endif
                                                        {{-- end of restaurants nearyby --}}

                                                        {{-- shopping_malls_nearby nearby --}}
                                                        @if (count($shopping_malls_nearby) > 0)
                                                            <p><b>SHOPPING MALLS NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($shopping_malls_nearby as $key => $shopping_mall)
                                                                <li>
                                                                    Name : {{ $shopping_mall['place_name'] }}
                                                                    | Distance : | {{ $shopping_mall['place_distance'] }}
                                                                    Time
                                                                    : {{ $shopping_mall['place_time'] }}
                                                                    | Address : {{ $shopping_mall['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Shopping Malls Nearby
                                                                </span></center>
                                                        @endif
                                                        {{-- end of shopping_malls_nearby nearyby --}}


                                                        {{-- police_station_nearby nearby --}}
                                                        @if (count($police_station_nearby) > 0)
                                                            <p><b>POLICE STATIONS NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($police_station_nearby as $key => $police_station)
                                                                <li>
                                                                    Name : {{ $police_station['place_name'] }}
                                                                    | Distance : | {{ $police_station['place_distance'] }}
                                                                    Time
                                                                    : {{ $police_station['place_time'] }}
                                                                    | Address : {{ $police_station['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Police Stations Malls
                                                                    Nearby
                                                                </span></center>
                                                        @endif
                                                        {{-- end of police_station_nearby nearyby --}}


                                                        {{-- schools_nearby nearby --}}
                                                        @if (count($schools_nearby) > 0)
                                                            <p><b>SCHOOLS NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($schools_nearby as $key => $school)
                                                                <li>
                                                                    Name : {{ $school['place_name'] }}
                                                                    | Distance : | {{ $school['place_distance'] }}
                                                                    Time
                                                                    : {{ $school['place_time'] }}
                                                                    | Address : {{ $school['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Schools Malls Nearby
                                                                </span></center>
                                                        @endif
                                                        {{-- end of schools_nearby nearyby --}}


                                                        {{-- hospitals_nearby nearby --}}
                                                        @if (count($hospitals_nearby) > 0)
                                                            <p><b>HOSPITALS NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($hospitals_nearby as $key => $hospital)
                                                                <li>
                                                                    Name : {{ $hospital['place_name'] }}
                                                                    | Distance : | {{ $hospital['place_distance'] }}
                                                                    Time
                                                                    : {{ $hospital['place_time'] }}
                                                                    | Address : {{ $hospital['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Christian Worship place
                                                                    Nearby
                                                                </span></center>
                                                        @endif
                                                        {{-- end of hospitals_nearby nearyby --}}



                                                        {{-- sports_grounds_nearby nearby --}}
                                                        @if (count($sports_grounds_nearby) > 0)
                                                            <p><b>SPORTS GROUNDS NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($sports_grounds_nearby as $key => $sports_ground)
                                                                <li>
                                                                    Name : {{ $sports_ground['place_name'] }}
                                                                    | Distance : | {{ $sports_ground['place_distance'] }}
                                                                    Time
                                                                    : {{ $sports_ground['place_time'] }}
                                                                    | Address : {{ $sports_ground['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Sports Ground Malls Nearby
                                                                </span></center>
                                                        @endif
                                                        {{-- end of sports_grounds_nearby nearyby --}}



                                                        {{-- hospitals_nearby nearby --}}
                                                        @if (count($christian_worship_places_nearby) > 0)
                                                            <p><b>CHRISTIAN WORSHIP PLACES NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($christian_worship_places_nearby as $key => $christian_worship_place)
                                                                <li>
                                                                    Name : {{ $christian_worship_place['place_name'] }}
                                                                    | Distance : | {{ $christian_worship_place['place_distance'] }}
                                                                    Time
                                                                    : {{ $christian_worship_place['place_time'] }}
                                                                    | Address : {{ $christian_worship_place['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Christian Worship place
                                                                    Nearby
                                                                </span></center>
                                                        @endif
                                                        {{-- end of christian_worship_places_nearby nearyby --}}

                                                        {{-- moslem_worship_places_nearby nearby --}}
                                                        @if (count($moslem_worship_places_nearby) > 0)
                                                            <p><b>MOSLEM WORSHIP NEARBY</b> </p>
                                                            <ul>
                                                                @foreach ($moslem_worship_places_nearby as $key => $moslem_worship_place)
                                                                <li>
                                                                    Name : {{ $moslem_worship_place['place_name'] }}
                                                                    | Distance : | {{ $moslem_worship_place['place_distance'] }}
                                                                    Time
                                                                    : {{ $moslem_worship_place['place_time'] }}
                                                                    | Address : {{ $moslem_worship_place['place_address'] }}
                                                                </li>
                                                                    <hr>
                                                                @endforeach

                                                            </ul>
                                                        @else
                                                            <center> <span style="color:red;">No Moslem Worship Places
                                                                    Nearby </span></center>
                                                        @endif
                                                        {{-- end of moslem_worship_places_nearby nearyby --}}



                                                    </div>


                                                </div>
                                            </div>


                                            <hr>
                                            <p> Amenities </p>
                                            <hr>
                                            <div class="row">
                                                @forelse ($apartment->amenities as $amenity)
                                                    <div class="col-lg-6">
                                                        <div class="card bg-primary border-primary text-white-50">
                                                            <div class="card-body">
                                                                <h5 class="mb-3 text-white text-center">
                                                                    {{ $amenity->name }}</h5>
                                                                {{-- <p class="card-text">Some quick example text to build on the card title and make up the bulk of the card's content.</p> --}}
                                                            </div>
                                                        </div>
                                                    </div>

                                                @empty

                                                    <span style="color:red;">No Amenities Available </span>
                                                @endforelse

                                            </div>

                                            <hr>
                                            <p>Property 3D Video </p>
                                            <div class="card-body">
                                                <!-- 16:9 aspect ratio -->
                                                <div class="ratio ratio-16x9">
                                                    {{-- <iframe src="{{ $apartment->property_video_url }}" title="YouTube video" allowfullscreen=""></iframe> --}}
                                                    <iframe width="130" height="175"
                                                        src=" {{ $apartment->property_video_url }}"
                                                        allowfullscreen="allowfullscreen"
                                                        mozallowfullscreen="mozallowfullscreen"
                                                        msallowfullscreen="msallowfullscreen"
                                                        oallowfullscreen="oallowfullscreen"
                                                        webkitallowfullscreen="webkitallowfullscreen">
                                                    </iframe>
                                                </div>
                                            </div>


                                            <hr>
                                            {{-- photo library upload --}}
                                            <div class="card" style="margin-top:20px;">
                                                <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                                    <center>Apartment Photos Collection</center>
                                                </div>
                                                <div class="card-body">

                                                    <div class="row">

                                                        {{-- pick multiple images from array --}}
                                                        @if (!empty($apartment->photo_library))
                                                            @foreach (is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library) as $image)
                                                                {{-- START COL --}}
                                                                <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                    <a href="{!! asset($image) !!}">
                                                                        <img style="
                                                                            height: 200px; 
                                                                            background-color:#ffffff; 
                                                                            object-fit:cover;
                                                                            max-width:100% !important;
                                                                            border:#ffffff 2px solid;
                                                                            background-repeat: no-repeat;
                                                                            object-position: center center;
                                                                            background-size:cover;
                                                                            padding:7px; 
                                                                            margin:0px;"
                                                                            src="{{ asset($image) }}" alt="">
                                                                    </a>


                                                                </div>
                                                                {{-- END COL --}}
                                                            @endforeach
                                                        @else
                                                            <center><span>No Photos Available <span></center>
                                                        @endif
                                                        {{-- end pick multiple images  from array --}}


                                                    </div>


                                                </div>
                                            </div>

                                            {{-- end of photo library upload --}}

                                            {{-- map --}}
                                            <p>Google Map </p>
                                            @if (!empty($apartment->google_map_iframe_url))
                                                <div class="overview-area map-box">
                                                    {{-- <h3 class="item-title">Map Location</h3> --}}
                                                    <div class="item-map">
                                                        <iframe src="{{ $apartment->google_map_iframe_url }}"
                                                            width="100%" height="349" style="border: 0"
                                                            allowfullscreen="" loading="lazy"></iframe>
                                                    </div>
                                                </div>
                                            @else
                                                <center><span>No Property Map Added </span></center>
                                            @endif

                                            <hr>



                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('apartment-edit')
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editapartment{{ $apartment->id }}"
                                                    data-bs-whatever="@getbootstrap">Edit apartment
                                                </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE  apartment --}}
                            <div class="modal fade" id="editapartment{{ $apartment->id }}" tabindex="-1"
                                aria-labelledby="editapartmentLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel">Edit apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE  CATEGORIES -->

                                            <form action="{{ route('apartments.update', $apartment->id) }}">
                                                 <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">Apartment/Property
                                                                Name</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="name"
                                                                placeholder="Enter apartment name"
                                                                value="{{ $apartment->name }}">
                                                            <div>
                                                                @error('name')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Address</label>
                                                                    <input type="text" class="form-control"
                                                                        id="validationCustom01" name="address"
                                                                        placeholder="Enter  addresss"
                                                                        value="{{ $apartment->address }}">
                                                                    <div>
                                                                        @error('address')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Apartment
                                                                        Category</label>

                                                                    <select name="apartment_category_id"
                                                                        class="form-select">
                                                                        @foreach ($apartment_categories as $apartment_category)
                                                                            <option value="{{ $apartment_category->id }}"
                                                                                @selected($apartment_category->id == $apartment->apartment_category_id)>
                                                                                {{ $apartment_category->category_name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>

                                                                    <div>
                                                                        @error('apartment_category_id')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>



                                                        </div>


                                                    </div>

                                                    {{-- start  multiple column --}}
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            {{-- col-1 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Number Of
                                                                        Beds</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="beds"
                                                                        placeholder="Enter  number of beds"
                                                                        value="{{ $apartment->beds }}">
                                                                    <div>
                                                                        @error('beds')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {{-- col-2 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Area (sqft)</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="size"
                                                                        placeholder="Enter area in square ft"
                                                                        value="{{ $apartment->size }}">
                                                                    <div>
                                                                        @error('size')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    {{-- end multiple column --}}

                                                    {{-- start  multiple column --}}
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            {{-- col-1 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Number Of
                                                                        Rooms</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="rooms"
                                                                        placeholder="Enter number of rooms"
                                                                        value="{{ $apartment->rooms }}">
                                                                    <div>
                                                                        @error('rooms')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {{-- col-2 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Bathrooms</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="bathrooms"
                                                                        placeholder="Enter number of bathrooms"
                                                                        value="{{ $apartment->bathrooms }}">
                                                                    <div>
                                                                        @error('bathrooms')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    {{-- end multiple column --}}

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">City</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="city"
                                                                placeholder="Enter  city"
                                                                value="{{ $apartment->city }}">
                                                            <div>
                                                                @error('city')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    {{-- units available  --}}
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Units
                                                                Available </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="units_available"
                                                                value="{{ $apartment->units_available }}">
                                                            <div>
                                                                @error('units_available')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>


                                                    {{-- amenities --}}
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <div class="card-header  bg-primary" style=" color:#ffffff;">
                                                                Select Amenities for this apartment

                                                            </div>
                                                            <hr>
                                                            <div class="row">

                                                                @foreach ($amenities as $amenity)
                                                                    <div class="col-md-4">
                                                                        <label>
                                                                            <input type="checkbox" name="amenities[]"
                                                                                value="{{ $amenity->id }}"
                                                                                {{-- {{ $amenity->isChecked ? 'checked' : '' }} --}}
                                                                                {{ in_array($amenity->id, $apartment->amenities->pluck('id')->toArray()) ? 'checked' : '' }}>
                                                                            {{ $amenity->name }}
                                                                        </label>
                                                                    </div>
                                                                @endforeach
                                                            </div>


                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">3D Video
                                                                Link
                                                                (Youtube)
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="property_video_url"
                                                                placeholder="Enter video link from youtube"
                                                                value="{{ $apartment->property_video_url }}">
                                                            <div>
                                                                @error('property_video_url')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Google Map
                                                                Iframe Link (src)</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="google_map_iframe_url"
                                                                value="{{ $apartment->google_map_iframe_url }}"
                                                                placeholder="Enter Google map iframe Link (src)">
                                                            <div>
                                                                @error('google_map_iframe_url')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    {{-- start  multiple column --}}
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            {{-- col-1 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Price / Month (USD)
                                                                    </label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="price"
                                                                        placeholder="Enter apartment price"
                                                                        value="{{ $apartment->price }}">
                                                                    <div>
                                                                        @error('price')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {{-- col-2 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Price Range ( USD
                                                                        )</label>

                                                                    <select name="price_range" class="form-select">
                                                                        {{-- <option value="null">-- Select -- </option> --}}
                                                                        <option value="1000_2000"
                                                                            {{ $apartment->price_range == '1000_2000' ? 'selected' : '' }}>
                                                                            1000 - 2000 USD
                                                                        </option>
                                                                        <option value="2000_3000"
                                                                            {{ $apartment->price_range == '2000_3000' ? 'selected' : '' }}>
                                                                            2000 - 3000 USD
                                                                        </option>
                                                                        <option value="3000_4000"
                                                                            {{ $apartment->price_range == '3000_4000' ? 'selected' : '' }}>
                                                                            3000 - 4000 USD
                                                                        </option>
                                                                        <option value="4000_5000"
                                                                            {{ $apartment->price_range == '4000_5000' ? 'selected' : '' }}>
                                                                            4000 - 5000 USD
                                                                        </option>
                                                                        <option value="5000_6000"
                                                                            {{ $apartment->price_range == '5000_6000' ? 'selected' : '' }}>
                                                                            5000 - 6000 USD
                                                                        </option>
                                                                        <option value="6000_7000"
                                                                            {{ $apartment->price_range == '6000_7000' ? 'selected' : '' }}>
                                                                            6000 - 7000 USD
                                                                        </option>
                                                                        <option value="7000_8000"
                                                                            {{ $apartment->price_range == '7000_8000' ? 'selected' : '' }}>
                                                                            7000 - 8000 USD
                                                                        </option>
                                                                        <option value="8000_9000"
                                                                            {{ $apartment->price_range == '8000_9000' ? 'selected' : '' }}>
                                                                            8000 - 9000 USD
                                                                        </option>
                                                                        <option value="9000_10000"
                                                                            {{ $apartment->price_range == '9000_10000' ? 'selected' : '' }}>
                                                                            9000 - 10000 USD
                                                                        </option>


                                                                    </select>

                                                                    <div>
                                                                        @error('price_range')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    {{-- end multiple column --}}



                                                    {{-- start  multiple column --}}
                                                    <hr>
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            {{-- col-1 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Property
                                                                        Status</label>
                                                                    <div class="form-check form-check-inline">
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_status" type="radio"
                                                                                id="property_status" {{-- {{ old('active') == '1' ? 'checked' : '' }} --}}
                                                                                {{ $apartment->property_status == '1' ? 'checked' : '' }}
                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="property_status">Active</label>
                                                                        </div>
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_status" type="radio"
                                                                                id="property_status" {{-- {{ old('unavailable') == '0' ? 'checked' : '' }} --}}
                                                                                {{ $apartment->property_status == '0' ? 'checked' : '' }}
                                                                                value="0">
                                                                            <label class="form-check-label"
                                                                                for="property_status">In
                                                                                Active</label>
                                                                        </div>
                                                                        {{-- validation --}}
                                                                        @error('property_status')
                                                                            <span
                                                                                class="text-danger">{{ $message }}</span>
                                                                        @enderror

                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {{-- col-2 --}}
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Booking
                                                                        Status</label>
                                                                    <div class="form-check form-check-inline">
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_booked_status"
                                                                                type="radio" id="property_booked_status"
                                                                                {{-- {{ old('available') == '1' ? 'checked' : '' }} --}}
                                                                                {{ $apartment->property_booked_status == '1' ? 'checked' : '' }}
                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="property_booked_status">Available</label>
                                                                        </div>
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_booked_status"
                                                                                type="radio" id="property_booked_status"
                                                                                {{-- {{ old('booked') == '0' ? 'checked' : '' }} --}}
                                                                                {{ $apartment->property_booked_status == '0' ? 'checked' : '' }}
                                                                                value="0">
                                                                            <label class="form-check-label"
                                                                                for="property_booked_status">Booked</label>
                                                                        </div>
                                                                        {{-- validation --}}
                                                                        @error('property_booked_status')
                                                                            <span
                                                                                class="text-danger">{{ $message }}</span>
                                                                        @enderror

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        {{-- end multiple column --}}


                                                    </div>
                                                    <hr>
                                                    {{-- end multiple column --}}


                                                    {{-- start  multiple column --}}
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            {{-- col-1 --}}
                                                            <div class="col-md-12">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Balcony </label>
                                                                    <div class="form-check form-check-inline">
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input" name="balcony"
                                                                                type="radio" id="balcony"
                                                                                {{-- {{ old('available') == '1' ? 'checked' : '' }} --}}
                                                                                {{ $apartment->balcony == '1' ? 'checked' : '' }}
                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="balcony">Available</label>
                                                                        </div>
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input" name="balcony"
                                                                                type="radio" id="balcony"
                                                                                {{-- {{ old('unavailable') == '0' ? 'checked' : '' }} --}}
                                                                                {{ $apartment->balcony == '0' ? 'checked' : '' }}
                                                                                value="0">
                                                                            <label class="form-check-label"
                                                                                for="balcony">Unavailable</label>
                                                                        </div>
                                                                        {{-- validation --}}
                                                                        @error('balcony')
                                                                            <span
                                                                                class="text-danger">{{ $message }}</span>
                                                                        @enderror

                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {{-- col-2 --}}
                                                            <div class="col-md-12">

                                                                {{-- exiting featured photo --}}
                                                                <a href="javascript::void(0)">
                                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                                        src="{{ asset($apartment->featured_photo) }}"
                                                                        alt="preview"
                                                                        style=" width:100% !important; object-fit:cover;">
                                                                </a>

                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Featured Photo</label>
                                                                    <input type="file" class="form-control"
                                                                        name="featured_photo" id="⁠⁠featured_photo"
                                                                        placeholder="">
                                                                    <div>
                                                                        @error('⁠⁠featured_photo')
                                                                            <small class="text-danger">
                                                                                {{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        {{-- end multiple column --}}


                                                    </div>
                                                    <hr>
                                                    {{-- end multiple column --}}


                                                    {{-- photo library upload --}}

                                                    <div class="card" style="margin-top:20px; padding-top:10px;">
                                                        
                                                        <div class="card-header bg-primary" style=" color:#ffffff;">
                                                            Apartment photos collection

                                                        </div>
                                                        {{-- existing photo libarary --}}

                                                        {{-- pick multiple images from array --}}
                                                        <div class="row">
                                                            @if (!empty($apartment->photo_library))
                                                                @foreach (is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library) as $image)
                                                                    {{-- START COL --}}
                                                                    <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                        <a href="{!! asset($image) !!}">
                                                                            <img style="
                                                                        height: 200px; 
                                                                        background-color:#ffffff; 
                                                                        object-fit:cover;
                                                                        width:100% !important;
                                                                        border:#ffffff 2px solid;
                                                                        background-repeat: no-repeat;
                                                                        object-position: center center;
                                                                        background-size:cover;
                                                                        padding:7px; 
                                                                        margin:0px;"
                                                                                src="{{ asset($image) }}"
                                                                                alt="">
                                                                        </a>

                                                                        <p>Remove</p>
                                                                        {{-- <a href="{{ url('product-image/'.$image->id.'/delete') }}" >Delete</a> --}}
                                                                        {{-- <button class="btn btn-danger delete-btn" data-index="{{ $image }}">Delete</button> --}}


                                                                    </div>

                                                                    {{-- END COL --}}
                                                                @endforeach
                                                            @else
                                                                <center><span>No Photos Available <span></center>
                                                            @endif
                                                        </div>
                                                        {{-- end pick multiple images  from array --}}

                                                        <!-- Display existing images -->
                                                        


                                                        {{-- end of existing photo library --}}
                                                        <div class="card-header bg-primary" style=" color:#ffffff;">
                                                            Add more photos to the apartment collection

                                                        </div>
                                                        {{-- @foreach ($productImages as $prodImg)
                                                            <img src="{{ asset($prodImg->image) }}" class="border p-2 m-3" style="width: 100px; height: 100px;" alt="Img" />
                                                            <a href="{{ url('product-image/'.$prodImg->id.'/delete') }}" >Delete</a>
                                                        @endforeach --}}


                                                        <div class="card-body">



                                                            {{-- validation --}}
                                                            @error('photo_library')
                                                                <span class="text-danger">{{ $message }}</span>
                                                            @enderror


                                                            {{-- 
                                                            <div class="row" style="margin-top:40px;">
                                                                <div class="col-md-6 imgUp">
                                                                    <div class="imagePreview"></div>
                                                                    <label class="btn btn-primary">
                                                                        Add Photo
                                                                        <input type="file" name="photo_library[]"
                                                                            class="uploadFile img" value="Upload Photo"
                                                                            style="width: 0px;height: 0px;overflow: hidden;">


                                                                    </label>

                                                                </div>
                                                                <i class="bi bi-plus-lg imgAdd">

                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                                        height="16" fill="currentColor"
                                                                        class="bi bi-plus-lg" viewBox="0 0 16 16">
                                                                        <path fill-rule="evenodd"
                                                                            d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2" />
                                                                    </svg>
                                                                </i>

                                                            </div> --}}

                                                            <input type="file" multiple class="form-control"
                                                                name="photo_library[]" id="upload_multiple">


                                                        </div>
                                                    </div>

                                                    {{-- end of photo library upload --}}

                                                    {{-- description --}}

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">Description</label>

                                                            <textarea class="form-control" name="description" id="exampleFormControlTextarea5"
                                                                placeholder="Describe the apartment" rows="3">{{ $apartment->description }}</textarea>
                                                            <div>
                                                                @error('description')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <button class="btn btn-primary" type="submit">Update
                                                        Apartment</button>
                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE post apartment --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No apartments available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection

@section('extra_scripts')
    {{-- multiple photo upload - environmental activities script --}}
    <script type="text/javascript">
        $(".imgAdd").click(function() {
            $(this).closest(".row").find('.imgAdd').before(
                '<div class="col-md-6 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" name="photo_library[]" class="uploadFile img" value="Upload Photo" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-timess del"><span style="color:#ffffff; ">Remove</span></i></div>'
            );
        });
        $(document).on("click", "i.del", function() {
            // 	to remove card
            $(this).parent().remove();
            // to clear image
            // $(this).parent().find('.imagePreview').css("background-image","url('')");
        });
        $(function() {
            $(document).on("change", ".uploadFile", function() {
                var uploadFile = $(this);
                var files = !!this.files ? this.files : [];
                if (!files.length || !window.FileReader)
                    return; // no file selected, or no FileReader support

                if (/^image/.test(files[0].type)) { // only image file
                    var reader = new FileReader(); // instance of the FileReader
                    reader.readAsDataURL(files[0]); // read the local file

                    reader.onloadend = function() { // set image data as background of div
                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                            "url(" + this.result + ")");
                    }
                }

            });
        });
    </script>


    {{-- end of  multiple photo upload - environmental activities script --}}
@endsection
