@extends('backend.layouts_backend.master')

@section('title')
@endsection

@section('content')

    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Permissions</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/permissions/create">Add Permission</a> > <a
                                        href="/permissions">View Permissions</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Page content starts here -->

            <div class="container">
                <div class="justify-content-center">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="card">
                       
                      <div class="row">
                        <div class="col-md-3">

                        </div>
                        <div class="col-md-6">
                            <div class="card-body">
                                {!! Form::model($permission, ['route' => ['permissions.update', $permission->id], 'method' => 'PATCH']) !!} 
                                <div class="form-group">
                                    <strong>Name:</strong>
                                    <br><br> {!! Form::text('name', null, ['placeholder' => 'Name', 'class' => 'form-control']) !!}<br>
                                </div>
                                <button type="submit" class="btn btn-primary">Edit Permission</button>
                                {!! Form::close() !!} 
                            </div>

                        </div>
                        <div class="col-md-3"></div>
                      </div>
                        
                    </div>
                </div>
            </div>









        </div>
        <!-- container-fluid -->
    </div>

@endsection
