@extends('backend.layouts_backend.master')

@section('title')
    All Permissions
@endsection

@section('content')
    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Permissions</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/admin/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/admin/permissions/create">Add Permission</a>  > 
                               <a href="/admin/permissions">View Permissions</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Page content starts here -->

            <div class="justify-content-center">
  
            {{-- alert add item --}}
            @if(session('messagesave'))
            {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
            <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
               <i class="mdi mdi-check-all label-icon"></i>
               {{ session('messagesave')}}
               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
           @endif

            {{-- alert delete item --}}
             @if(session('messagedelete'))
            <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
               <i class="mdi mdi-block-helper label-icon"></i>
               {{ session('messagedelete')}}
               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
             {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
             @if(session('messageupdate'))
            <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
               <i class="mdi mdi-check-all label-icon"></i>
               {{ session('messageupdate')}}
               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
           @endif

                <div class="card">
                    
                    <div class="card-body">
                        <table class="table table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Description</th>
                                    <th width="280px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $key => $permission)
                                    <tr>
                                        <td>{{ $permission->id }}</td>
                                        <td>{{ $permission->name }}</td>
                                        <td>{{ $permission->description }}</td>
                                        <td>
                                            <a class="btn btn-success"
                                                href="{{ route('permissions.show', $permission->id) }}">Show</a>
                                            @can('role-edit')
                                                <a class="btn btn-primary"
                                                    href="{{ route('permissions.edit', $permission->id) }}">Edit</a>
                                            @endcan
                                            @can('role-delete')
                                                {!! Form::open([
                                                    'method' => 'DELETE',
                                                    'route' => ['permissions.destroy', $permission->id],
                                                    'style' => 'display:inline',
                                                ]) !!}
                                                {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        {{-- pagination --}}
                        {{-- {{ $data->appends($_GET)->links() }} --}}

                    </div>
                </div>
            </div>






        </div>
        <!-- container-fluid -->
    </div>
@endsection
