@extends('backend.layouts_backend.master')

@section('title')
    All Shelters Reports
@endsection

@section('extra_styles')
    {{-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> --}}
@endsection


@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">

            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">All Shelters Reports <span
                                class="text-muted fw-normal ms-2">({{ $count_shelters }})</span>
                        </h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">
                        <div>

                            {{-- <a class="btn btn-primary" href="/shelters_report">Shelters Report</a> --}}
                        </div>
                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH shelterS -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif





            {{-- DATA TABLE EXPORT --}}

            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body table-responsive mb-4">
                            <table class="table align-middle datatable dt-responsive table-check nowrap"
                                style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                                <thead>
                                    <tr>
                                        <th scope="col">#ID</th>
                                        <th scope="col">Shelter Name</th>
                                        <th scope="col">Shelter Serial Number</th>
                                        <th scope="col"> Internal Assessment status</th>
                                        <th style="width: 220px; min-width: 80px; "> Action</th>
                                    </tr>
                                </thead>


                                <tbody>
                                    @forelse ($shelters as $shelter)
                                        <tr>

                                            <td>{{ $shelter->id }}</td>
                                            <td>

                                                @if (!empty($shelter->minority_shelter_organization_name))
                                                    {{ $shelter->minority_shelter_organization_name }}
                                                @else
                                                    {{-- <span class="badge badge-danger"> Danger</span> --}}
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No Name</span>
                                                    </button>
                                                @endif

                                            </td>
                                            <td>
                                                @if (!empty($shelter->shelter_serial_number))
                                                    {{ $shelter->shelter_serial_number }}
                                                @else
                                                    <p class="text-danger">No serial</p>
                                                @endif

                                            </td>

                                            <td>
                                                @if (!empty($shelter->internal_assessement_status == 'assessed'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                        {{ $shelter->internal_assessement_status }}
                                                    </span>
                                                @elseif (!empty($shelter->internal_assessement_status == 'pending'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                                        {{ $shelter->internal_assessement_status }}
                                                    </span>
                                                @elseif (!empty($shelter->internal_assessement_status == 'approved'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                        {{ $shelter->internal_assessement_status }}
                                                    </span>
                                                @elseif (!empty($shelter->internal_assessement_status == 'closed'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                                        {{ $shelter->internal_assessement_status }}
                                                    </span>
                                                @else
                                                    <p class="text-danger">No status</p>
                                                @endif

                                            </td>

                                            <td colspan="6">
                                                <div class="row">


                                                    @can('shelter-list')
                                                    <div class="col-md-3">
                                                        <button type="button" class="btn btn-success"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#viewshelterDetails{{ $shelter->id }}"
                                                            data-bs-whatever="@getbootstrap"><i
                                                                class=" far fa-eye  "></i>
                                                        </button>

                                                    </div>
                                                    @endcan

                                                     {{-- print report --}}
                                                     @can('report-download')
                                                     <div class="col-md-3">
                                                        <a href="/shelter_report/{{ $shelter->id }}"
                                                            target="_blank"><button type="button"
                                                                class="btn btn-secondary">
                                                                <i class="bx bx-download label-icon "></i>
                                                            </button>
                                                        </a>
                                                    </div>
                                                    @endcan


                                                     {{--

                                                    @can('shelter-edit')
                                                    <div class="col-md-3">

                                                        <button type="button" class="btn btn-primary"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#editshelter{{ $shelter->id }}"
                                                            data-bs-whatever="@getbootstrap"><i
                                                                class="fas fa-pencil-alt "></i>
                                                        </button>
                                                    </div>
                                                    @endcan --}}



                                                    <!-- delete  -->
                                                    {{-- @can('shelter-delete')
                                                    <div class="col-md-3">
                                                        <form action="{{ route('shelters.update', $shelter->id) }}"
                                                            method="post">
                                                            @csrf
                                                            @method('DELETE')
                                                            <a>
                                                                <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                        class="fa fa-trash">
                                                                </button>
                                                            </a>

                                                        </form>

                                                    </div>
                                                    @endcan --}}


                                                </div>
                                            </td>
                                        </tr>

                                        <!-- VIEW DETAILS MODEL -->
                                        <div class="modal fade" id="viewshelterDetails{{ $shelter->id }}" tabindex="-1"
                                            aria-labelledby="viewshelterDetailsLabel" style="display: none;"
                                            aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-scrollable">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="viewshelterDetailsLabel"
                                                            style="font-size: 30px;">
                                                            Shelter Details
                                                        </h5>
                                                        {{-- report --}}
                                                        {{-- <a style="margin-left:50px;" class="btn btn-primary"
                                                            href="/shelters_single_report/{{ $shelter->id }}">Print
                                                            Report</a> --}}

                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>



                                                    <div class="modal-body">


                                                        <b>
                                                            <p style="font-size: 20px;"> Shelter organization name:</p>
                                                        </b>
                                                        <p style="font-size: 20px;">
                                                            @if (!empty($shelter->minority_shelter_organization_name))
                                                                {{ $shelter->minority_shelter_organization_name }}
                                                            @else
                                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                                    <span class="fa fa-exclamation-circle"> No Name
                                                                        added</button>
                                                            @endif
                                                        </p>

                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Created by:</p>
                                                        </b>
                                                        <p>
                                                            @if (!empty($shelter->created_by))
                                                                {{ $shelter->created_by }}
                                                            @else
                                                                <p class="text-danger">No Creator</p>
                                                            @endif
                                                        </p>




                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Shelter Serial Number :</p>
                                                        </b>
                                                        <p>
                                                            @if (!empty($shelter->shelter_serial_number))
                                                                {{ $shelter->shelter_serial_number }}
                                                            @else
                                                                <p class="text-danger">No serial</p>
                                                            @endif
                                                        </p>

                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Shelter format :</p>
                                                        </b>
                                                        <p>
                                                            @if (!empty($shelter->shelter_format_r->shelter_format_name))
                                                                {{ $shelter->shelter_format_r->shelter_format_name }}
                                                            @else
                                                                <p class="text-danger">No format</p>
                                                            @endif
                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Target group :</p>
                                                        </b>
                                                        @if (!empty($shelter->target_group_r->target_group_name))
                                                            {{ $shelter->target_group_r->target_group_name }}
                                                        @else
                                                            <p class="text-danger">No target group</p>
                                                        @endif
                                                        </p>

                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">District :</p>
                                                        </b>
                                                        @if (!empty($shelter->shelter_district_r->district_name))
                                                            {{ $shelter->shelter_district_r->district_name }}
                                                        @else
                                                            <p class="text-danger">No District</p>
                                                        @endif
                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Region :</p>
                                                        </b>
                                                        @if (!empty($shelter->shelter_region_r->region_name))
                                                            {{ $shelter->shelter_region_r->region_name }}
                                                        @else
                                                            <p class="text-danger">No region</p>
                                                        @endif
                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Internal assessement status :</p>
                                                        </b>

                                                        @if (!empty($shelter->internal_assessement_status == 'assessed'))
                                                            <span
                                                                class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                                {{ $shelter->internal_assessement_status }}
                                                            </span>
                                                        @elseif (!empty($shelter->internal_assessement_status == 'pending'))
                                                            <span
                                                                class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                                                {{ $shelter->internal_assessement_status }}
                                                            </span>
                                                        @elseif (!empty($shelter->internal_assessement_status == 'approved'))
                                                            <span
                                                                class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                                {{ $shelter->internal_assessement_status }}
                                                            </span>
                                                        @elseif (!empty($shelter->internal_assessement_status == 'closed'))
                                                            <span
                                                                class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                                                {{ $shelter->internal_assessement_status }}
                                                            </span>
                                                        @else
                                                            <p class="text-danger">No status</p>
                                                        @endif



                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Estimated maximum capacity of
                                                                occupants :</p>
                                                        </b>


                                                        @if (!empty($shelter->estimated_maximum_capacity_of_occupants))
                                                            {{ $shelter->estimated_maximum_capacity_of_occupants }}
                                                        @else
                                                            <button class="btn btn-danger shadow btn-xs sharp">
                                                                <span class="fa fa-exclamation-circle"> No Estimate</span>
                                                            </button>
                                                        @endif

                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Occupants present today :</p>
                                                        </b>
                                                        @if (!empty($shelter->occupants_present_today))
                                                            {{ $shelter->occupants_present_today }}
                                                        @else
                                                            <button class="btn btn-danger shadow btn-xs sharp">
                                                                <span class="fa fa-exclamation-circle"> No Occupants</span>
                                                            </button>
                                                        @endif
                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Email :</p>
                                                        </b>
                                                        @if (!empty($shelter->email))
                                                            {{ $shelter->email }}
                                                        @else
                                                            <button class="btn btn-danger shadow btn-xs sharp">
                                                                <span class="fa fa-exclamation-circle"> No Email</span>
                                                            </button>
                                                        @endif

                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Primary contact name :</p>
                                                        </b>
                                                        @if (!empty($shelter->primary_contact_name))
                                                            {{ $shelter->primary_contact_name }}
                                                        @else
                                                            <button class="btn btn-danger shadow btn-xs sharp">
                                                                <span class="fa fa-exclamation-circle"> No Name</span>
                                                            </button>
                                                        @endif
                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Primary contact number :</p>
                                                        </b>
                                                        @if (!empty($shelter->primary_contact_number))
                                                            {{ $shelter->primary_contact_number }}
                                                        @else
                                                            <button class="btn btn-danger shadow btn-xs sharp">
                                                                <span class="fa fa-exclamation-circle"> No Number</span>
                                                            </button>
                                                        @endif
                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Secondary contact name :</p>
                                                        </b>
                                                        @if (!empty($shelter->secondary_contact_name))
                                                            {{ $shelter->secondary_contact_name }}
                                                        @else
                                                            <button class="btn btn-danger shadow btn-xs sharp">
                                                                <span class="fa fa-exclamation-circle"> No Name</span>
                                                            </button>
                                                        @endif
                                                        </p>
                                                        <hr>
                                                        <b>
                                                            <p style="font-size: 20px;">Secondary contact number : </p>
                                                        </b>
                                                        @if (!empty($shelter->secondary_contact_number))
                                                            {{ $shelter->secondary_contact_number }}
                                                        @else
                                                            <button class="btn btn-danger shadow btn-xs sharp">
                                                                <span class="fa fa-exclamation-circle"> No Contact</span>
                                                            </button>
                                                        @endif

                                                        </p>




                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-danger"
                                                            data-bs-dismiss="modal">Close
                                                        </button>

                                                        @can('shelter-edit')
                                                            <button type="button" class="btn btn-primary"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#editshelter{{ $shelter->id }}"
                                                                data-bs-whatever="@getbootstrap">Edit shelter
                                                            </button>
                                                        @endcan

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- END OF VIEW DETAILS MODEL -->


                                        {{-- UPDATE  shelter --}}
                                        <div class="modal fade" id="editshelter{{ $shelter->id }}" tabindex="-1"
                                            aria-labelledby="editshelterLabel" style="display: none;" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-scrollable">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="viewshelterDetailsLabel">Edit shelter
                                                            Details</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">


                                                        <!-- UPDATE post CATEGORIES -->

                                                        <form action="{{ route('shelters.update', $shelter->id) }}"
                                                            method="post" enctype="multipart/form-data">
                                                            @csrf
                                                            @method('PATCH')

                                                            {{-- UPDATE FORM --}}

                                                            {{-- row --}}
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Shelter
                                                                            format</label>

                                                                        <select name="shelter_format_id"
                                                                            class="form-select">
                                                                            @foreach ($shelter_formats as $shelter_format)
                                                                                <option value="{{ $shelter_format->id }}"
                                                                                    @selected($shelter_format->id == $shelter->shelter_format_id)>
                                                                                    {{ $shelter_format->shelter_format_name }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Target
                                                                            group</label>

                                                                        <select name="target_group_id"
                                                                            class="form-select">
                                                                            @foreach ($target_groups as $target_group)
                                                                                <option value="{{ $target_group->id }}"
                                                                                    @selected($target_group->id == $shelter->target_group_id)>
                                                                                    {{ $target_group->target_group_name }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>


                                                            </div>

                                                            {{-- row --}}
                                                            <div class="row">

                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Shelter Created
                                                                            by</label>

                                                                        <input type="text" class="form-control"
                                                                            name="created_by" id="validationCustom02"
                                                                            placeholder="Created by"
                                                                            value="{{ $created_by }}"
                                                                            style="pointer-events: none">
                                                                        <div>
                                                                            @error('created_by')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">District</label>

                                                                        <select name="shelter_district_id"
                                                                            class="form-select">
                                                                            @foreach ($shelter_districts as $shelter_district)
                                                                                <option
                                                                                    value="{{ $shelter_district->id }}"
                                                                                    @selected($shelter_district->id == $shelter->shelter_district_id)>
                                                                                    {{ $shelter_district->district_name }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>


                                                            </div>

                                                            {{-- row --}}
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Reigion</label>

                                                                        <select name="shelter_region_id"
                                                                            class="form-select">
                                                                            @foreach ($shelter_regions as $shelter_region)
                                                                                <option value="{{ $shelter_region->id }}"
                                                                                    @selected($shelter_region->id == $shelter->shelter_region_id)>
                                                                                    {{ $shelter_region->region_name }}
                                                                                </option>
                                                                            @endforeach


                                                                        </select>




                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Assesment
                                                                            status</label>


                                                                        <select name="internal_assessement_status"
                                                                            class="form-select">
                                                                            <option value="pending"
                                                                                @selected($shelter->internal_assessement_status == 'pending')>Pending
                                                                            </option>
                                                                            <option value="assessed"
                                                                                @selected($shelter->internal_assessement_status == 'assessed')>Assessed
                                                                            </option>
                                                                            <option value="approved"
                                                                                @selected($shelter->internal_assessement_status == 'approved')>Approved
                                                                            </option>
                                                                            <option value="closed"
                                                                                @selected($shelter->internal_assessement_status == 'closed')>Closed</option>
                                                                        </select>

                                                                    </div>
                                                                </div>


                                                            </div>

                                                            {{-- row --}}
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Shelter
                                                                            name</label>

                                                                        <input type="text" class="form-control"
                                                                            name="minority_shelter_organization_name"
                                                                            id="validationCustom02"
                                                                            value="{{ $shelter->minority_shelter_organization_name }}">
                                                                        <div>
                                                                            @error('minority_shelter_organization_name')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Maximum
                                                                            occupants capacity</label>

                                                                        <input type="text" class="form-control"
                                                                            name="estimated_maximum_capacity_of_occupants"
                                                                            id="validationCustom02"
                                                                            value="{{ $shelter->estimated_maximum_capacity_of_occupants }}">
                                                                        <div>
                                                                            @error('estimated_maximum_capacity_of_occupants')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>



                                                            </div>



                                                            {{-- row --}}
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Occupants
                                                                            present</label>

                                                                        <input type="text" class="form-control"
                                                                            name="occupants_present_today"
                                                                            id="validationCustom02"
                                                                            value="{{ $shelter->occupants_present_today }}">
                                                                        <div>
                                                                            @error('occupants_present_today')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Email</label>

                                                                        <input type="text" class="form-control"
                                                                            name="email" id="validationCustom02"
                                                                            value="{{ $shelter->email }}" value="">
                                                                        <div>
                                                                            @error('email')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            {{-- row --}}
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Primary
                                                                            contact Name</label>

                                                                        <input type="text" class="form-control"
                                                                            name="primary_contact_name"
                                                                            id="validationCustom02"
                                                                            value="{{ $shelter->primary_contact_name }}">
                                                                        <div>
                                                                            @error('primary_contact_name')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Primary
                                                                            contact Number</label>

                                                                        <input type="text" class="form-control"
                                                                            name="primary_contact_number"
                                                                            id="validationCustom02"
                                                                            value="{{ $shelter->primary_contact_number }}">
                                                                        <div>
                                                                            @error('primary_contact_number')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            {{-- row --}}
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Secondary
                                                                            contact name</label>

                                                                        <input type="text" class="form-control"
                                                                            name="secondary_contact_name"
                                                                            id="validationCustom02"
                                                                            value="{{ $shelter->secondary_contact_name }}">
                                                                        <div>
                                                                            @error('secondary_contact_name')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="validationCustom01">Secondary
                                                                            contact number</label>

                                                                        <input type="text" class="form-control"
                                                                            name="secondary_contact_number"
                                                                            id="validationCustom02"
                                                                            value="{{ $shelter->secondary_contact_number }}">
                                                                        <div>
                                                                            @error('secondary_contact_number')
                                                                                <small class="text-danger">
                                                                                    {{ $message }}</small>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            {{-- END UPDATE FORM --}}



                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary"
                                                                    data-bs-dismiss="modal">Close</button>
                                                                <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                                <button class="btn btn-primary" type="submit">Update
                                                                    shelter</button>
                                                            </div>


                                                        </form>
                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                        {{-- END UPDATE post shelter --}}

                                    @empty
                                        <center>
                                            <span class="badge bg-soft-danger text-danger"
                                                style="padding:10px;  font-size:20px;">Oops! No shelters available!</span>
                                        </center>
                                    @endforelse






                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- end cardaa -->
                </div> <!-- end col -->
            </div>

            {{-- END OF DATA TABLE EXPORT --}}

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>

    @section('extra_scripts')
        <script></script>
    @endsection

@endsection
