@extends('backend.layouts_backend.master')

@section('title')
    All Tenants Reports Data
@endsection

@section('extra_styles')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
    {{-- <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css"> --}}
    {{-- <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script> --}}
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">All Tenans reports data <span
                                class="text-muted fw-normal ms-2">({{ $count_tenants }})</span>
                        </h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>

                            {{-- @can('tenant-create')
                                <a href="/tenants/create" class="btn bg-primary text-light">
                                    <i class="bx bx-plus me-1"></i> Add Tenant
                                </a>
                            @endcan --}}
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH tenantS -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            <th scope="col">#ID</th>
                            <th scope="col">Organization/residence</th>
                            <th scope="col"> Tenant Serial Number</th>
                            <th scope="col"> Fullname</th>
                            <th scope="col"> Tenant Status</th>


                            <th style="width: 220px; min-width: 80px; ">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($tenants as $tenant)
                            <tr>

                                <td>{{ $tenant->id }}</td>
                                <td>

                                    @if (!empty($tenant->shelter_r->minority_shelter_organization_name))
                                        {{ $tenant->shelter_r->minority_shelter_organization_name }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No residence Name</span>
                                        </button>
                                    @endif

                                </td>

                                {{-- serial number --}}
                                <td>
                                    @if (!empty($tenant->tenant_serial_number))
                                        {{ $tenant->tenant_serial_number }}
                                    @else
                                        <p class="text-danger">No serial</p>
                                    @endif

                                </td>

                                {{-- fullname --}}
                                <td>
                                    @if (!empty($tenant->fullname))
                                        {{ $tenant->fullname }}
                                    @else
                                        <p class="text-danger">No Name</p>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($tenant->status == 'approved'))
                                        <span class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                            {{ $tenant->status }}
                                        </span>
                                    @elseif (!empty($tenant->status == 'pending'))
                                        <span class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                            {{ $tenant->status }}
                                        </span>
                                    @elseif (!empty($tenant->status == 'suspended'))
                                        <span class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                            {{ $tenant->status }}
                                        </span>
                                    @else
                                        <p class="text-danger">No Status</p>
                                    @endif

                                </td>




                                <td colspan="6">
                                    <div class="row">

                                         @can('tenant-list')
                                        <div class="col-md-3">
                                            <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#viewtenantDetails{{ $tenant->id }}"
                                                data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                        </div>
                                        @endcan

                                        {{-- print report --}}
                                        @can('report-download')
                                        <div class="col-md-3">
                                            <a href="/tenant_report/{{ $tenant->id }}" target="_blank"><button
                                                    type="button" class="btn btn-secondary">
                                                    <i class="bx bx-download label-icon "></i>
                                                </button>
                                            </a>
                                        </div>
                                        @endcan

                                        {{-- @can('tenant-list')
                                        <div class="col-md-3">
                                            <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#viewtenantDetails{{ $tenant->id }}"
                                                data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                        </div>
                                        @endcan --}}

                                        {{-- @can('tenant-edit')
                                        <div class="col-md-3">
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#edittenant{{ $tenant->id }}"
                                                data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button>

                                        </div>
                                        @endcan --}}



                                        <!-- delete  -->

                                        {{-- @can('tenant-delete')
                                            <div class="col-md-3">
                                                <form action="{{ route('tenants.update', $tenant->id) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        @endcan --}}

                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewtenantDetails{{ $tenant->id }}" tabindex="-1"
                                aria-labelledby="viewtenantDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewtenantDetailsLabel" style="font-size: 30px;">
                                                Tenant Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">


                                            <b>
                                                <p style="font-size: 20px;"> Shelter/Residence name:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($tenant->shelter_r->minority_shelter_organization_name))
                                                    {{ $tenant->shelter_r->minority_shelter_organization_name }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No Name added</button>
                                                @endif
                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Tenant Serial Number :</p>
                                            </b>
                                            <p>
                                                @if (!empty($tenant->tenant_serial_number))
                                                    {{ $tenant->tenant_serial_number }}
                                                @else
                                                    <p class="text-danger">No serial</p>
                                                @endif
                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Created by:</p>
                                            </b>
                                            <p>
                                                @if (!empty($tenant->created_by))
                                                    {{ $tenant->created_by }}
                                                @else
                                                    <p class="text-danger">No Creator</p>
                                                @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Full name :</p>
                                            </b>
                                            @if (!empty($tenant->fullname))
                                                {{ $tenant->fullname }}
                                            @else
                                                <p class="text-danger">No fullname</p>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Email :</p>
                                            </b>
                                            @if (!empty($tenant->email))
                                                {{ $tenant->email }}
                                            @else
                                                <p class="text-danger">No email</p>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Phone number :</p>
                                            </b>
                                            @if (!empty($tenant->phone_no))
                                                {{ $tenant->phone_no }}
                                            @else
                                                <p class="text-danger">No Phone</p>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Whatsap number :</p>
                                            </b>
                                            @if (!empty($tenant->whatsap_number))
                                                {{ $tenant->whatsap_number }}
                                            @else
                                                <p class="text-danger">No whatsap number</p>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">National ID availability :</p>
                                            </b>

                                            @if (!empty($tenant->national_id_availability == 'yes'))
                                                <span class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                    {{ $tenant->national_id_availability }}
                                                </span>
                                            @elseif (!empty($tenant->national_id_availability == 'no'))
                                                <span class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                                    {{ $tenant->national_id_availability }}
                                                </span>
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No ID</span>
                                                </button>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Date of birth :</p>
                                            </b>


                                            @if (!empty($tenant->date_of_birth))
                                                {{ $tenant->date_of_birth }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No date</span>
                                                </button>
                                            @endif

                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Current age :</p>
                                            </b>
                                            @if (!empty($tenant->current_age))
                                                {{ $tenant->current_age }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No age</span>
                                                </button>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Gender :</p>
                                            </b>
                                            @if (!empty($tenant->gender))
                                                {{ $tenant->gender }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No gender</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Status :</p>
                                            </b>
                                            @if (!empty($tenant->status == 'approved'))
                                                <span class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                    {{ $tenant->status }}
                                                </span>
                                            @elseif (!empty($tenant->status == 'pending'))
                                                <span class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                                    {{ $tenant->status }}
                                                </span>
                                            @elseif (!empty($tenant->status == 'suspended'))
                                                <span class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                                    {{ $tenant->status }}
                                                </span>
                                            @else
                                                <p class="text-danger">No Status</p>
                                            @endif

                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Highest level of education :</p>
                                            </b>
                                            @if (!empty($tenant->hightest_level_of_education))
                                                {{ $tenant->hightest_level_of_education }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No education</span>
                                                </button>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Skills and job experience :</p>
                                            </b>
                                            @if (!empty($tenant->skills_and_job_experience))
                                                {{ $tenant->skills_and_job_experience }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No skills</span>
                                                </button>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Pronoun :</p>
                                            </b>
                                            @if (!empty($tenant->pronoun))
                                                {{ $tenant->pronoun }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No pronoun</span>
                                                </button>
                                            @endif
                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Referee full name : </p>
                                            </b>
                                            @if (!empty($tenant->referee_full_name))
                                                {{ $tenant->referee_full_name }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No Contact</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Referee phone number : </p>
                                            </b>
                                            @if (!empty($tenant->referee_phone_number))
                                                {{ $tenant->referee_phone_number }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No Phone</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Referee email: </p>
                                            </b>
                                            @if (!empty($tenant->referee_email))
                                                {{ $tenant->referee_email }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No Contact</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Former area of residence : </p>
                                            </b>
                                            @if (!empty($tenant->former_area_of_residence))
                                                {{ $tenant->former_area_of_residence }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No residence</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Current area of residence: </p>
                                            </b>
                                            @if (!empty($tenant->current_area_of_residence))
                                                {{ $tenant->current_area_of_residence }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No residence</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Expected time of stay : </p>
                                            </b>
                                            @if (!empty($tenant->expected_time_of_stay))
                                                {{ $tenant->expected_time_of_stay }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No Time of stay</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Reason for joining : </p>
                                            </b>
                                            @if (!empty($tenant->reason_for_joining))
                                                {{ $tenant->reason_for_joining }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No reason</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Describe why homeless : </p>
                                            </b>
                                            @if (!empty($tenant->describe_why_homeless))
                                                {{ $tenant->describe_why_homeless }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No reason</span>
                                                </button>
                                            @endif

                                            </p>

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Have you been to shelter before : </p>
                                            </b>
                                            @if (!empty($tenant->have_you_been_to_shelter_before))
                                                {{ $tenant->have_you_been_to_shelter_before }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No answer</span>
                                                </button>
                                            @endif

                                            </p>
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">National ID front photo : </p>
                                            </b>
                                            @if ($tenant->national_id_front_photo)
                                                <a href="{!! asset($tenant->national_id_front_photo) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->national_id_front_photo) }}"
                                                        alt="preview" style=" width:100% !important; object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Front Photo</p>
                                            @endif

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">National ID back photo : </p>
                                            </b>
                                            @if ($tenant->national_id_back_photo)
                                                <a href="{!! asset($tenant->national_id_back_photo) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->national_id_back_photo) }}" alt="preview"
                                                        style=" width:100% !important; m object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Back Photo</p>
                                            @endif

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Passport photo : </p>
                                            </b>
                                            @if ($tenant->passport_photo)
                                                <a href="{!! asset($tenant->passport_photo) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->passport_photo) }}" alt="preview"
                                                        style=" width:100% !important; object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Passport photo</p>
                                            @endif

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Selfie photo : </p>
                                            </b>
                                            @if ($tenant->selfie_photo)
                                                <a href="{!! asset($tenant->selfie_photo) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->selfie_photo) }}" alt="preview"
                                                        style=" width:100% !important;  object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Photo</p>
                                            @endif

                                            {{-- front driving permit --}}
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Front permit : </p>
                                            </b>
                                            @if ($tenant->front_driving_permit)
                                                <a href="{!! asset($tenant->front_driving_permit) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->front_driving_permit) }}" alt="preview"
                                                        style=" width:100% !important;  object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Front permit</p>
                                            @endif

                                            {{-- back driving permit --}}
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Back driving permit : </p>
                                            </b>
                                            @if ($tenant->back_driving_permit)
                                                <a href="{!! asset($tenant->back_driving_permit) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->back_driving_permit) }}" alt="preview"
                                                        style=" width:100% !important;  object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Back permit</p>
                                            @endif

                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Back driving permit : </p>
                                            </b>
                                            @if ($tenant->back_driving_permit)
                                                <a href="{!! asset($tenant->back_driving_permit) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->back_driving_permit) }}" alt="preview"
                                                        style=" width:100% !important;  object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Back permit</p>
                                            @endif

                                            {{-- front other ID --}}
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Back driving permit : </p>
                                            </b>
                                            @if ($tenant->back_driving_permit)
                                                <a href="{!! asset($tenant->back_driving_permit) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->back_driving_permit) }}" alt="preview"
                                                        style=" width:100% !important;  object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No Back permit</p>
                                            @endif

                                            {{-- BACK other id --}}
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Front other ID : </p>
                                            </b>

                                            @if ($tenant->other_id_front)
                                                <a href="{!! asset($tenant->other_id_front) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->other_id_front) }}" alt="preview"
                                                        style=" width:100% !important;  object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No back oher ID</p>
                                            @endif


                                            {{-- back other id --}}
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Back other ID : </p>
                                            </b>

                                            @if ($tenant->other_id_back)
                                                <a href="{!! asset($tenant->other_id_back) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($tenant->other_id_back) }}" alt="preview"
                                                        style=" width:100% !important;  object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No back oher ID</p>
                                            @endif





                                            {{-- comment on tenant --}}
                                            <hr>
                                            <b>
                                                <p style="font-size: 20px;">Comment on tenant : </p>
                                            </b>
                                            @if (!empty($tenant->comment_on_tenant))
                                                {{ $tenant->comment_on_tenant }}
                                            @else
                                                <button class="btn btn-danger shadow btn-xs sharp">
                                                    <span class="fa fa-exclamation-circle"> No Comment</span>
                                                </button>
                                            @endif




                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('tenant-edit')
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#edittenant{{ $tenant->id }}"
                                                    data-bs-whatever="@getbootstrap">Edit tenant
                                                </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE  tenant --}}
                            <div class="modal fade" id="edittenant{{ $tenant->id }}" tabindex="-1"
                                aria-labelledby="edittenantLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewtenantDetailsLabel">Edit tenant
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE TENANT -->

                                            <form action="{{ route('tenants.update', $tenant->id) }}" method="post"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')

                                                {{-- UPDATE FORM --}}

                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Prefered
                                                                area of
                                                                residence</label>

                                                            <select name="shelter_id" class="form-select">

                                                                @foreach ($shelters as $shelter)
                                                                    <option value="{{ $shelter->id }}"
                                                                        @selected($shelter->id == $tenant->shelter_id)>
                                                                        {{ $shelter->minority_shelter_organization_name }}
                                                                    </option>
                                                                @endforeach


                                                            </select>

                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Updated
                                                                by</label>

                                                            <input type="text" class="form-control" name="created_by"
                                                                id="validationCustom02" placeholder="Created by"
                                                                value="{{ $tenant->created_by }}"
                                                                style="pointer-events: none">

                                                            <div>
                                                                @error('created_by')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>

                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Fullname</label>

                                                            <input type="text" class="form-control" name="fullname"
                                                                id="validationCustom02" placeholder="Enter full name"
                                                                value="{{ $tenant->fullname }}">
                                                            <div>
                                                                @error('fullname')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Email</label>

                                                            <input type="text" class="form-control" name="email"
                                                                id="validationCustom02" placeholder="Enter email"
                                                                value="{{ $tenant->email }}">
                                                            <div>
                                                                @error('email')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div>



                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Phone
                                                                number</label>

                                                            <input type="text" class="form-control" name="phone_no"
                                                                id="validationCustom02" placeholder="Enter phone number"
                                                                value="{{ $tenant->phone_no }}">
                                                            <div>
                                                                @error('phone_no')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Whatsap
                                                                number</label>

                                                            <input type="text" class="form-control"
                                                                name="whatsap_number" id="validationCustom02"
                                                                placeholder="Enter whatsapp number"
                                                                value="{{ $tenant->whatsap_number }}">
                                                            <div>
                                                                @error('whatsap_number')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Age</label>

                                                            <input type="text" class="form-control" name="current_age"
                                                                id="validationCustom02" placeholder="Enter age"
                                                                value="{{ $tenant->current_age }}">
                                                            <div>
                                                                @error('current_age')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Gender</label>
                                                            {{-- gender --}}

                                                            <select name="gender" class="form-select">
                                                                <option value="male" @selected($tenant->gender == 'male')>Male
                                                                </option>
                                                                <option value="female" @selected($tenant->gender == 'female')>Female
                                                                </option>
                                                                <option value="not_said" @selected($tenant->gender == 'not_said')>
                                                                    Prefer not to say</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Tenant
                                                                Status</label>

                                                            <select name="status" class="form-select">
                                                                <option value="pending" @selected($tenant->status == 'pending')>
                                                                    Pending</option>
                                                                <option value="approved" @selected($tenant->status == 'approved')>
                                                                    Approved</option>
                                                                <option value="suspended" @selected($tenant->status == 'suspended')>
                                                                    Suspended</option>
                                                            </select>
                                                        </div>
                                                    </div>





                                                </div>

                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Highest
                                                                level of
                                                                education</label>

                                                            <select name="hightest_level_of_education"
                                                                class="form-select">
                                                                <option value="p7" @selected($tenant->hightest_level_of_education == 'p7')>p7
                                                                </option>
                                                                <option value="s4" @selected($tenant->hightest_level_of_education == 's4')>s4
                                                                </option>
                                                                <option value="s6" @selected($tenant->hightest_level_of_education == 's6')>s6
                                                                </option>
                                                                <option value="certificate" @selected($tenant->hightest_level_of_education == 'certificate')>
                                                                    Certificate</option>
                                                                <option value="diploma" @selected($tenant->hightest_level_of_education == 'diploma')>
                                                                    Diploma</option>
                                                                <option value="barchelors" @selected($tenant->hightest_level_of_education == 'barchelors')>
                                                                    Barchelors</option>
                                                                <option value="masters" @selected($tenant->hightest_level_of_education == 'masters')>
                                                                    Masters</option>
                                                                <option value="phd" @selected($tenant->hightest_level_of_education == 'phd')>PHD
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">Pronoun</label>

                                                            <select name="pronoun" class="form-select">
                                                                <option value="he/him" @selected($tenant->pronoun == 'he/him')>He/Him
                                                                </option>
                                                                <option value="she/her" @selected($tenant->pronoun == 'she/her')>
                                                                    She/Her</option>
                                                                <option value="they/them" @selected($tenant->pronoun == 'they/them')>
                                                                    They/Them</option>
                                                                <option value="not_said" @selected($tenant->pronoun == 'not_said')>
                                                                    Prefer Not to Say</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>


                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Referee
                                                                fullname</label>

                                                            <input type="text" class="form-control"
                                                                name="referee_full_name" id="validationCustom02"
                                                                placeholder="Enter referee fullname"
                                                                value="{{ $tenant->referee_full_name }}">
                                                            <div>
                                                                @error('referee_full_name')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Referee
                                                                phone
                                                                number</label>

                                                            <input type="text" class="form-control"
                                                                name="referee_phone_number" id="validationCustom02"
                                                                placeholder="Enter referee phone number"
                                                                value="{{ $tenant->referee_phone_number }}">
                                                            <div>
                                                                @error('referee_phone_number')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Referee
                                                                email</label>

                                                            <input type="text" class="form-control"
                                                                name="referee_email" id="validationCustom02"
                                                                placeholder="Enter referee email"
                                                                value="{{ $tenant->referee_email }}">
                                                            <div>
                                                                @error('referee_email')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">former area
                                                                of
                                                                residence</label>

                                                            <input type="text" class="form-control"
                                                                name="former_area_of_residence" id="validationCustom02"
                                                                placeholder="Enter former area of residence"
                                                                value="{{ $tenant->former_area_of_residence }}">
                                                            <div>
                                                                @error('former_area_of_residence')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Current
                                                                area of
                                                                residence</label>

                                                            <input type="text" class="form-control"
                                                                name="current_area_of_residence" id="validationCustom02"
                                                                placeholder="Enter current residence"
                                                                value="{{ $tenant->current_area_of_residence }}">
                                                            <div>
                                                                @error('current_area_of_residence')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Expected
                                                                time of stay
                                                                (months)
                                                            </label>

                                                            <input type="text" class="form-control"
                                                                name="expected_time_of_stay" id="validationCustom02"
                                                                placeholder="Enter expected time of stay    "
                                                                value="{{ $tenant->expected_time_of_stay }}">
                                                            <div>
                                                                @error('expected_time_of_stay')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Reason for
                                                                joining</label>

                                                            <select name="reason_for_joining" class="form-select">
                                                                <option value="family_discrimination"
                                                                    @selected($tenant->family_discrimination == 'insecure')>Discrimination or Stigma
                                                                    in the Family</option>
                                                                <option value="outside_family_descrimination"
                                                                    @selected($tenant->reason_for_joining == 'outside_family_descrimination')>Discrimination or Stigma
                                                                    Outside the Family</option>
                                                                <option value="sexual_abuse" @selected($tenant->reason_for_joining == 'sexual_abuse')>
                                                                    Sexually Abused</option>
                                                                <option value="society_harm" @selected($tenant->reason_for_joining == 'society_harm')>
                                                                    Harmed by Society</option>
                                                                <option value="insecure" @selected($tenant->reason_for_joining == 'insecure')>Feel
                                                                    insecure in current location
                                                                    or Residence
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>


                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Have you
                                                                been to shelter
                                                                before</label>

                                                            <select name="have_you_been_to_shelter_before"
                                                                class="form-select">
                                                                <option value="yes" @selected($tenant->have_you_been_to_shelter_before == 'yes')>Yes
                                                                </option>
                                                                <option value="no" @selected($tenant->have_you_been_to_shelter_before == 'no')>No
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- row --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">National ID
                                                                availability</label>

                                                            <select name="national_id_availability" class="form-select"
                                                                id="fieldSelect">
                                                                <option value="empty">Chose field</option>
                                                                <option value="yes">Yes</option>
                                                                <option value="no">No</option>
                                                            </select>

                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Date of
                                                                birth</label>

                                                            <input type="date" class="form-control"
                                                                name="date_of_birth" id="validationCustom02"
                                                                placeholder="Enter date of birth"
                                                                value="{{ $tenant->date_of_birth }}">
                                                            <div>
                                                                @error('date_of_birth')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                {{-- row --}}
                                                {{-- NATIONAL ID SECTION --}}

                                                {{-- selfie  --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="fieldno">Selfie photo</label>
                                                            <input type="file" class="form-control"
                                                                name="selfie_photo" id="fieldno" placeholder="Zip">
                                                            <div>
                                                                @error('selfie_photo')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row yes">

                                                    {{-- national id front --}}
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="fieldyes">National ID
                                                                front</label>
                                                            <input type="file" class="form-control"
                                                                name="national_id_front_photo" id="fieldyes"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('national_id_front_photo')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    {{-- back national id --}}
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="fieldyes">National ID
                                                                back</label>
                                                            <input type="file" class="form-control"
                                                                name="national_id_back_photo" id="fieldyes"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('national_id_back_photo')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                </div>
                                                {{-- END OF NATIONAL ID SECTION --}}

                                                {{-- row --}}
                                                {{-- OTHER DOCUMENTS --}}
                                                <div class="row no">

                                                    {{-- passport photo --}}
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Passport
                                                                photo</label>
                                                            <input type="file" class="form-control"
                                                                name="passport_photo" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('passport_photo')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    {{-- front driving permit --}}
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Driving
                                                                permit
                                                                front</label>
                                                            <input type="file" class="form-control"
                                                                name="front_driving_permit" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('front_driving_permit')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    {{-- back driving permit --}}
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Driving
                                                                permit back</label>
                                                            <input type="file" class="form-control"
                                                                name="back_driving_permit" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('back_driving_permit')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    {{-- other id front --}}
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Other ID
                                                                front</label>
                                                            <input type="file" class="form-control"
                                                                name="other_id_front" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('other_id_front')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    {{-- other id back --}}
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Other ID
                                                                back</label>
                                                            <input type="file" class="form-control"
                                                                name="other_id_back" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('other_id_back')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>



                                                </div>
                                                {{-- END OTHER DOCUMENTS --}}


                                                {{-- row --}}
                                                <div class="row">

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Describe
                                                                why your
                                                                homeless</label>

                                                            <textarea class="form-control" name="describe_why_homeless" id="exampleFormControlTextarea5"
                                                                placeholder="Describe why your homeless" rows="3">{{ $tenant->describe_why_homeless }}</textarea>
                                                            <div>
                                                                @error('describe_why_homeless')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Skills and
                                                                job
                                                                experience</label>

                                                            <textarea class="form-control" name="skills_and_job_experience" id="exampleFormControlTextarea5"
                                                                placeholder="Enter skills and job experience" rows="3">{{ $tenant->skills_and_job_experience }}</textarea>
                                                            <div>
                                                                @error('skills_and_job_experience')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>



                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- row --}}
                                                <div class="row">


                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Comment on
                                                                tenant</label>

                                                            <textarea class="form-control" name="comment_on_tenant" id="exampleFormControlTextarea5"
                                                                placeholder="Enter skills and job experience" rows="3">{{ $tenant->comment_on_tenant }}</textarea>
                                                            <div>
                                                                @error('comment_on_tenant')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>



                                                        </div>
                                                    </div>
                                                </div>




                                                {{-- END UPDATE FORM --}}



                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        tenant</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE post tenant --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No tenants available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection


@section('extra_scripts')
    <script>
        $(document).ready(function() {
            // Hide all fields initially
            $('.yes, .no').hide();

            // Show/hide fields based on select option
            $('#fieldSelect').change(function() {
                var selectedField = $(this).val();
                $('.yes, .no').hide();
                $('.' + selectedField).show();
            });
        });
    </script>
@endsection
