@extends('backend.layouts_backend.master')

@section('title')
    All Tours
@endsection


@section('extra_styles')
    <style>
        /* multiple photo upload - environmental activities css */
        .imagePreview {
            width: 100%;
            height: 300px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            1 display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            width: 80px;
            height: 40px;
            padding-top: 3px;
            padding-left: 8px;
            padding-right: 8px;
            background-color: #f60909;
            color: #ffffff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .imgAdd {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .dell {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #ca078c;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        /* end of multiple photo upload - environmental activities css */
    </style>
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Tours <span class="text-muted fw-normal ms-2">({{ $count_tours }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('tour-create')
                                <a href="/admin/tours/create" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    Add Tour</a>
                            @endcan
                        </div>

                        <div>
                            @can('tour-restore')
                                <a href="{{ route('tours.trashed') }}" class="btn bg-danger text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Trashed Tours</a>
                            @endcan
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH tours -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert restore item --}}
            @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            {{-- <th scope="col">#ID</th> --}}
                            <th scope="col"> ID</th>
                            <th scope="col">Tour Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Units Available</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @php
                            $counter = 1;
                        @endphp

                        @forelse ($tours as $key => $tour)
                            <tr>

                                <td>{{ $counter + $key }}</td>

                                <td>
                                    @if (!empty($tour->name))
                                        {{ $tour->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($tour->tour_category->name))
                                        {{ $tour->tour_category->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($tour->slots_available))
                                        {{ $tour->slots_available }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>

                                <td>
                                    @if (!empty($tour->user->name))
                                        {{ $tour->user->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        @can('tour-show')
                                            <div class="col-md-4">
                                                <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                    data-bs-target="#viewtourDetails{{ $tour->id }}"
                                                    data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                            </div>
                                        @endcan

                                        {{-- edit --}}
                                        @can('tour-edit')
                                            <div class="col-md-4">

                                                <a href="{{ route('tours.edit', $tour->id) }}"><button type="button"
                                                        class="btn btn-info"><i class="fas fa-pencil-alt "></i>
                                                    </button></a>

                                                {{-- <button type="button" class="btn btn-info" data-bs-toggle="modal"
                                                    data-bs-target="#edittour{{ $tour->id }}"
                                                    data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button> --}}

                                            </div>
                                        @endcan

                                        <!-- delete  -->

                                        @can('tour-delete')
                                            <div class="col-md-4">
                                                <form action="{{ route('tours.destroy', $tour->id) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        @endcan


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewtourDetails{{ $tour->id }}" tabindex="-1"
                                aria-labelledby="viewtourDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewtourDetailsLabel"> tour
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            {{-- featured photo --}}
                                            <p>Featured Photo </p>
                                            <hr>

                                            <a href="{!! asset($tour->featured_photo) !!}">
                                                <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                    src="{{ asset($tour->featured_photo) }}" alt="preview"
                                                    style=" width:100% !important; object-fit:cover;">
                                            </a>
                                            <hr>

                                            <p> Tour Name :
                                                @if (!empty($tour->name))
                                                    {{ $tour->name }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>



                                            <p>Created By :
                                                @if (!empty($tour->user->name))
                                                    {{ $tour->user->name }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> Start Date :
                                                @if (!empty($tour->start_date))
                                                    {{ $tour->start_date }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> End Date :
                                                @if (!empty($tour->end_date))
                                                    {{ $tour->end_date }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> Slots available :
                                                @if (!empty($tour->slots_available))
                                                    {{ $tour->slots_available }} slots
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> Tour Singles Price :
                                                @if (!empty($tour->tour_single_cost))
                                                    {{ $tour->tour_single_cost }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            <p> Tour Couple Price :
                                                @if (!empty($tour->tour_couple_cost))
                                                    {{ $tour->tour_couple_cost }}
                                                @else
                                                    <span>N/A</span>
                                                @endif
                                            </p>
                                            <hr>

                                            {{-- tour includes --}}





                                            <p>Tour Status :
                                                @if ($tour->tour_status == 1)
                                                    Active
                                                @elseif($tour->tour_status == 0)
                                                    Inactive
                                                @else
                                                    N/A
                                                @endif
                                            </p>
                                            <hr>

                                            <p>Booking Status :
                                                @if ($tour->booking_status == 1)
                                                    Available for booking
                                                @elseif($tour->booking_status == 0)
                                                    Inactive
                                                @else
                                                    N/A
                                                @endif
                                            </p>
                                            <hr>

                                            {{-- itenary  --}}
                                            <div class="card" style="margin-top:2px; padding-top:10px;">
                                                <div class="card-header bg-primary" style=" color:#ffffff;">
                                                    Tour Detailed Itenary

                                                </div>


                                                @php
                
                                                $tour_itenaries_data = !empty($tour->tour_itenaries) ? json_decode($tour->tour_itenaries, true): [];
                                                 $tour_itenaries_data_grouped_by_day = collect($tour_itenaries_data)->groupBy('itenary_day_number');
                                
                                               @endphp
                                               {{-- {{ dd($tour_itenaries_data_grouped_by_day) }} --}}
                                
                                               <ul>
                                                @foreach ($tour_itenaries_data_grouped_by_day as $dayNumber => $dayItenaries) <br>
                                                    <li>
                                                        <strong>Day {{ $dayNumber }}</strong>
                                                        <ul>
                                                            @foreach ($dayItenaries as $itenary)
                                                                <li>
                                                                    Time: {{ $itenary['itenary_time'] }} - Description: {{ $itenary['itenary_description'] }}
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    </li>
                                                @endforeach
                                            </ul>
                                              
                                


                                                {{-- tour includes --}}
                                                <div class="card" style="margin-top:2px; padding-top:10px;">
                                                    <div class="card-header bg-primary" style=" color:#ffffff;">
                                                        Tour Includes
                                                    </div>
                                                    @php
                                                        $tour_includes_data = json_decode($tour->tour_includes);
                                                    @endphp
                                                    
                                                    <p>

                                                    <ul style="padding-top:20px;">
                                                        @forelse ($tour_includes_data ?? [] as $key => $tour_include)
                                                            <li>{{ $tour_include }}</li>
                                                        @empty
                                                            <span>No tour includes </span>
                                                        @endforelse
                                                    </ul>
                                                    </p>





                                                </div>
                                                <br>

                                                {{-- tour excludes --}}
                                                <div class="card" style="margin-top:2px; padding-top:10px;">
                                                    <div class="card-header bg-primary" style=" color:#ffffff;">
                                                        Tour Excludes

                                                    </div>
                                                    @php
                                                        $tour_excludes_data = json_decode($tour->tour_excludes);
                                                    @endphp
                                                    <p>

                                                    <ul style="padding-top:20px;">
                                                        @forelse ($tour_excludes_data ?? [] as $key => $tour_exclude)
                                                            <li>{{ $tour_exclude }}</li>
                                                        @empty
                                                            <span>No tour excludes </span>
                                                        @endforelse
                                                    </ul>
                                                    </p>

                                                </div>

                                                {{-- activities --}}
                                                <div class="card" style="margin-top:2px; padding-top:10px;">
                                                    <div class="card-header bg-primary" style=" color:#ffffff;">
                                                        Tour Activities

                                                    </div>
                                                    @php
                                                        $tour_activities_data = json_decode($tour->tour_activities);
                                                    @endphp
                                                    <p>

                                                    <ul style="padding-top:20px;">
                                                        @forelse ($tour_activities_data ?? [] as $key => $tour_activity)
                                                            <li>{{ $tour_activity }}</li>
                                                        @empty
                                                            <span>No tour activities </span>
                                                        @endforelse
                                                    </ul>
                                                    </p>

                                                </div>





                                                <p>Video Tour Preview </p>
                                                <div class="card-body">
                                                    <!-- 16:9 aspect ratio -->
                                                    <div class="ratio ratio-16x9">
                                                        <iframe width="130" height="175"
                                                            src=" {{ $tour->video_url }}"
                                                            allowfullscreen="allowfullscreen"
                                                            mozallowfullscreen="mozallowfullscreen"
                                                            msallowfullscreen="msallowfullscreen"
                                                            oallowfullscreen="oallowfullscreen"
                                                            webkitallowfullscreen="webkitallowfullscreen">
                                                        </iframe>
                                                    </div>
                                                </div>


                                                <hr>
                                                {{-- photo library upload --}}
                                                <div class="card" style="margin-top:20px;">
                                                    <div class="card-header"
                                                        style="background-color:#0e274c; color:#ffffff;">
                                                        <center>Tour Photos Collection</center>
                                                    </div>
                                                    <div class="card-body">

                                                        <div class="row">

                                                            {{-- pick multiple images from array --}}
                                                            @if (!empty($tour->photo_library))
                                                                @foreach (is_null($tour->photo_library) ? [] : explode(',', $tour->photo_library) as $image)
                                                                    {{-- START COL --}}
                                                                    <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                        <a href="{!! asset($image) !!}">
                                                                            <img style="
                                                                            height: 200px; 
                                                                            background-color:#ffffff; 
                                                                            object-fit:cover;
                                                                            max-width:100% !important;
                                                                            border:#ffffff 2px solid;
                                                                            background-repeat: no-repeat;
                                                                            object-position: center center;
                                                                            background-size:cover;
                                                                            padding:7px; 
                                                                            margin:0px;"
                                                                                src="{{ asset($image) }}" alt="">
                                                                        </a>


                                                                    </div>
                                                                    {{-- END COL --}}
                                                                @endforeach
                                                            @else
                                                                <center><span>No Photos Available <span></center>
                                                            @endif
                                                            {{-- end pick multiple images  from array --}}


                                                        </div>


                                                    </div>
                                                </div>
                                                <hr>

                                                {{-- end of photo library upload --}}

                                                {{-- description  --}}
                                                <p>Tour Description : <br>
                                                    @if (!empty($tour->description))
                                                        {{ $tour->description }}
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </p>




                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-danger"
                                                    data-bs-dismiss="modal">Close
                                                </button>

                                                {{-- @can('tour-edit')
                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                    data-bs-target="#edittour{{ $tour->id }}" data-bs-whatever="@getbootstrap">Edit Tour
                </button>
            @endcan --}}

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- END OF VIEW DETAILS MODEL -->



                            @empty
                                <center>
                                    <span class="badge bg-soft-danger text-danger"
                                        style="padding:10px;  font-size:20px;">Oops! No tours
                                        available!</span>
                                </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->



    </div>
    <!-- container-fluid -->
    </div>
@endsection

@section('extra_scripts')
    {{-- add itenary row  and delete itenary row --}}
    <script src="{{ asset('assets/backend_assets/assets/js/tours/itenaries_add_remove_row.js') }}"></script>

    <script src="{{ asset('assets/backend_assets/assets/js/tours/itenaries_add_remove_row_update.js') }}"></script>


    {{-- add activity row  and delete activity row --}}
    <script src="{{ asset('assets/backend_assets/assets/js/tours/activities_add_remove_row.js') }}"></script>


    {{-- tour excludes , add and remove rows --}}
    <script src="{{ asset('assets/backend_assets/assets/js/tours/tour_excludes_add_remove_row.js') }}"></script>

    {{-- tour includes , add and remove rows --}}
    <script src="{{ asset('assets/backend_assets/assets/js/tours/tour_includes_add_remove_row.js') }}"></script>



    {{-- multiple photo upload - environmental activities script --}}
    <script type="text/javascript">
        $(".imgAdd").click(function() {
            $(this).closest(".row").find('.imgAdd').before(
                '<div class="col-md-6 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" name="photo_library[]" class="uploadFile img" value="Upload Photo" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-timess del"><span style="color:#ffffff; ">Remove</span></i></div>'
            );
        });
        $(document).on("click", "i.del", function() {
            // 	to remove card
            $(this).parent().remove();
            // to clear image
            // $(this).parent().find('.imagePreview').css("background-image","url('')");
        });
        $(function() {
            $(document).on("change", ".uploadFile", function() {
                var uploadFile = $(this);
                var files = !!this.files ? this.files : [];
                if (!files.length || !window.FileReader)
                    return; // no file selected, or no FileReader support

                if (/^image/.test(files[0].type)) { // only image file
                    var reader = new FileReader(); // instance of the FileReader
                    reader.readAsDataURL(files[0]); // read the local file

                    reader.onloadend = function() { // set image data as background of div
                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                            "url(" + this.result + ")");
                    }
                }

            });
        });
    </script>


    {{-- end of  multiple photo upload - environmental activities script --}}
@endsection
