@extends('frontend/layouts_frontend/master_frontend')

@section('title')
    Tour Details - Relocate Uganda
@endsection


@section('extra_styles')
@endsection

{{-- CONTENT SECTION --}}
@section('content')
    <section class="main-banner-wrap1 main-banner-wrap5"
        data-bg-image="{{ asset('assets/frontend_assets/img/slider/slider4.jpg') }}">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="main-banner-box1 main-banner-box5">
                        <h1 class="item-title wow fadeInUp" data-wow-delay=".4s">Tour Details</h1>
                        <p style="margin-top:-20px;" class="item-para wow fadeInUp text-center text-white "
                            data-wow-delay=".4s">We have the tours <span class="banner-p"> you have been looking for
                                !</span>
                    </div>



                </div>
            </div>
        </div>
    </section>


    <!--=====================================-->
    <!--=   Single Listing     Start        =-->
    <!--=====================================-->

    <section class="single-listing-wrap1">
        <div class="container">
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif


            @if (session('messagenotours'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagenotours') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif


            <div class="single-property">
                <div class="content-wrapper">
                    <div class="property-heading">
                        <div class="row">
                            <div class="col-lg-3 col-md-12">
                                <div class="single-list-cate">
                                    @if ($tour->slots_available > 0)
                                        <div class="item-categoery">
                                            TOUR AVAILABLE FOR BOOKING
                                        </div>
                                    @elseif($tour->slots_available <= 0)
                                        <button type="submit" class="btn btn-danger" disabled>
                                            TOUR UNITS ALL ALREADY BOOKED

                                        </button>
                                        <br>
                                        <span> You cannot book it.</span>
                                    @else
                                        N/A
                                    @endif



                                </div>


                            </div>
                            <div class="col-lg-9 col-md-12">

                                <div class="single-list-price" style="font-size: 23px; ">
                                    @if (!empty($tour->tour_single_cost))
                                        SINGLES : USD {{ $tour->tour_single_cost }}
                                    @else
                                        <span> SINGLES PRICE : N/A </span>
                                    @endif

                                    |
                                    @if (!empty($tour->tour_single_cost))
                                        COUPLES : USD {{ $tour->tour_single_cost }}
                                    @else
                                        <span> COUPLES PRICE : N/A </span>
                                    @endif

                                    |

                                    @if (!empty($tour->slots_available >= 0))
                                        SLOTS : {{ $tour->slots_available }}
                                    @elseif($tour->slots_available == 0)
                                        <span>0</span>
                                    @else
                                        <span> N/A </span>
                                    @endif

                                </div>


                            </div>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-lg-8 col-md-12">
                                <div class="single-verified-area">

                                    <div class="item-title">
                                        <h3>
                                            @if (!empty($tour->name))
                                                {{ $tour->name }}
                                            @else
                                                <span>N/A </span>
                                            @endif
                                        </h3>
                                    </div>
                                </div>
                                <div class="single-item-address">
                                    <ul>
                                        <li>
                                            <i class="fas fa-map-marker-alt"></i>
                                            @if (!empty($tour->destination))
                                                Destination : {{ $tour->destination }}
                                            @else
                                                <span>destination : N/A </span>
                                            @endif
                                        </li>



                                        <li>
                                            <i class="fas fa-calendar"></i>
                                            @if (!empty($tour->created_at))
                                                Added on : {{ $tour->created_at }}
                                            @else
                                                <span>Added on : N/A </span>
                                            @endif
                                        </li>

                                        <li>
                                            <i class="fas fa-clock"></i>
                                            @if (!empty($tour->tour_category->name))
                                                Category : {{ $tour->tour_category->name }}
                                            @else
                                                <span>Category : N/A</span>
                                            @endif
                                        </li>


                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="row">
                        {{-- left side bar --}}
                        <div class="col-lg-8">

                            {{-- featured photo --}}
                            <a href="javascript::void(0)">
                                <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                    src="{{ asset($tour->featured_photo) }}" alt="preview"
                                    style=" width:100% !important; object-fit:cover;">
                            </a>
                            <hr>
                            {{-- end featured photo --}}

                            <div class="single-listing-box1">
                                <div class="overview-area listing-area">
                                    <h3 class="item-title">About This tour</h3>
                                    <p>
                                        @if (!empty($tour->description))
                                            {{ $tour->description }}
                                        @else
                                            <span>N/A </span>
                                        @endif
                                    </p>

                                </div>

                                {{-- photo library upload --}}
                                <div class="card" style="margin-top:20px;">
                                    <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                        <center>Tour Photos Collection</center>
                                    </div>
                                    <div class="card-body">

                                        <div class="row">

                                            {{-- pick multiple images from array --}}
                                            @if (!empty($tour->photo_library))
                                                @foreach (is_null($tour->photo_library) ? [] : explode(',', $tour->photo_library) as $image)
                                                    {{-- START COL --}}
                                                    <div class=" col-md-4 col-lg-4 col-xs-12">

                                                        <a href="{!! asset($image) !!}">
                                                            <img style="
                                                                height: 300px; 
                                                                background-color:#f1ecec; 
                                                                object-fit:cover;
                                                                max-width:100% !important;
                                                                border:#ffffff 2px solid;
                                                                background-repeat: no-repeat;
                                                                object-position: center center;
                                                                background-size:cover;
                                                                padding:2px; 
                                                                margin:0px;"
                                                                src="{{ asset($image) }}" alt="">
                                                        </a>


                                                    </div>
                                                    {{-- END COL --}}
                                                @endforeach
                                            @else
                                                <center><span>No Photos Available <span></center>
                                            @endif
                                            {{-- end pick multiple images  from array --}}


                                        </div>


                                    </div>
                                </div>

                                {{-- end of photo library upload --}}

                                {{-- overview --}}
                                <div class="overview-area">
                                    <h3 class="item-title">Overview of the Tour</h3>
                                    <div class="gallery-icon-box">
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Start Date</li>
                                                <li class="deep-clr">
                                                    @if (!empty($tour->start_date))
                                                        {{ $tour->start_date }}
                                                    @else
                                                        <span>N/A </span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>


                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>End Date :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($tour->end_date))
                                                        {{ $tour->end_date }}
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>

                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Couples :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($tour->tour_couple_cost))
                                                        {{ $tour->tour_couple_cost }} USD
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Single Cost :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($tour->tour_single_cost))
                                                        {{ $tour->tour_single_cost }} USD
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                    </div>


                                </div>

                                {{-- ITENARY --}}

                                <div class="overview-area floor-plan-box">
                                    <h3 class="item-title">Itenary of the tour</h3>
                                    @php

                                        $tour_itenaries_data = !empty($tour->tour_itenaries)
                                            ? json_decode($tour->tour_itenaries, true)
                                            : [];
                                        $tour_itenaries_data_grouped_by_day = collect($tour_itenaries_data)->groupBy(
                                            'itenary_day_number',
                                        );

                                    @endphp

                                    @foreach ($tour_itenaries_data_grouped_by_day as $dayNumber => $dayItenaries)
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#headingtwo{{ $dayNumber }}"
                                                        aria-expanded="true" role="button">
                                                        <span>Day {{ $dayNumber }}</span>

                                                    </div>
                                                </div>


                                                <div id="headingtwo{{ $dayNumber }}" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    {{-- @foreach ($grouped_iteneraries_by_day as $dayNumber => $iteneraries) --}}
                                                    <div class="card-body">

                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    @foreach ($dayItenaries as $itenary)
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Time </b> :   &nbsp;{{ $itenary['itenary_time'] }}  &nbsp; &nbsp; | &nbsp; &nbsp;
                                                                            <b>Activity </b>  &nbsp;
                                                                            : {{ $itenary['itenary_description'] }}
                                                                        </li>
                                                                    @endforeach
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>
                                                    {{-- @endforeach --}}

                                                </div>
                                            </div>



                                        </div>
                                    @endforeach

                                </div>

                                {{-- END OF ITENARY --}}

                                {{-- activities --}}

                                @php
                                    $tour_activities_data = json_decode($tour->tour_activities);
                                @endphp

                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Tour Includes</h3>
                                    <div class="row">
                                        @forelse ($tour_activities_data ?? [] as $key => $tour_activity)
                                            <div class="col-lg-6">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        {{ $tour_activity }}
                                                    </li>
                                                </ul>
                                            </div>
                                        @empty
                                            <span>No tour activities </span>
                                        @endforelse

                                    </div>
                                </div>
                                <br>


                                {{-- tour includes --}}

                                @php
                                    $tour_includes_data = json_decode($tour->tour_includes);
                                @endphp

                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Tour Includes</h3>
                                    <div class="row">
                                        @forelse ($tour_includes_data ?? [] as $key => $tour_include)
                                            <div class="col-lg-6">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        {{ $tour_include }}
                                                    </li>
                                                </ul>
                                            </div>
                                        @empty
                                            <span>No tour includes </span>
                                        @endforelse

                                    </div>
                                </div>
                                <br>

                                {{-- tour excludes --}}

                                @php
                                    $tour_excludes_data = json_decode($tour->tour_excludes);
                                @endphp

                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Tour Excludes</h3>
                                    <div class="row">
                                        @forelse ($tour_excludes_data ?? [] as $key => $tour_exclude)
                                            <div class="col-lg-6">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        {{ $tour_exclude }}
                                                    </li>
                                                </ul>
                                            </div>
                                        @empty
                                            <span>No tour Excludes </span>
                                        @endforelse

                                    </div>
                                </div>
                                <br>


                                {{-- proximity --}}



                                {{-- google map --}}
                                {{-- <div class="overview-area map-box">
                                    <h3 class="item-title">Map Location</h3>
                                    <div class="item-map">
                                        <iframe
                                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15959.010553132808!2d32.56891338715819!3d0.3287646000000029!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x177d86d12b8d12eb%3A0xf702e15d47576e84!2sProtea%20Hotel%20by%20Marriott%20Kampala!5e0!3m2!1sen!2sug!4v1706687575787!5m2!1sen!2sug"
                                            width="731" height="349" style="border: 0" allowfullscreen=""
                                            loading="lazy"></iframe>
                                    </div>
                                </div> --}}

                                {{-- end of google map --}}


                                {{-- video url --}}
                                {{-- <div class="overview-area video-box1">
                                    <h3 class="item-title">Video showing the property</h3>
                                    @if (!empty($tour->property_video_url))
                                        <div class="ratio ratio-16x9">

                                            <iframe width="130" height="175"
                                                src=" {{ $tour->property_video_url }}"
                                                allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen"
                                                msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen"
                                                webkitallowfullscreen="webkitallowfullscreen">
                                            </iframe>

                                        </div>
                                    @else
                                        <span>No Video Added </span>
                                    @endif
                                </div> --}}
                                {{-- end of video --}}


                            </div>
                        </div>
                        {{-- end left side bar --}}

                        {{-- side bar right --}}
                        <div class="col-lg-4 widget-break-lg sidebar-widget">

                            {{-- BOOKING FORM --}}


                            <div class="widget widget-contact-box">
                                <h3 class="widget-subtitle">Book this tour</h3>


                                <form action="{{ route('tour_bookings.store') }}" method="POST"
                                    enctype="multipart/form-data" class="contact-box">
                                    @csrf
                                    <div class="row">
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="first_name"
                                                placeholder="Your First Name" />

                                            @error('first_name')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="last_name"
                                                placeholder="Last Name" />
                                            @error('last_name')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="email"
                                                placeholder="E-mail" />
                                            @error('email')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="nationality"
                                                placeholder="Enter Your Nationality" />
                                            @error('nationality')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="current_address"
                                                placeholder="Enter Current Address" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="phone_number"
                                                placeholder="Enter Phone Number" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="date" class="form-control" name="arrival_date"
                                                placeholder="Enter arrival date" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="hidden" class="form-control" name="tour_id"
                                                value=" {{ $tour->id }}" placeholder="Enter tour id" />
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <textarea name="message" id="message" class="form-text" placeholder="Message" cols="30" rows="4"></textarea>
                                    </div>


                                    {{-- submit --}}

                                    @if ($tour->slots_available > 0)
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <button type="submit" class="item-btn">
                                                    BOOK TOUR NOW <i class="fas fa-envelope"></i>
                                                </button>
                                            </div>
                                        </div>
                                    @else
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <center>
                                                    <button type="submit" class="btn btn-danger" disabled>
                                                        ALL tour UNITS BOOKED

                                                    </button>
                                                    <br>
                                                    <span> You cannot book it.</span>
                                                </center>
                                            </div>
                                        </div>
                                    @endif


                            </div>
                            <div class="form-response"></div>
                            </form>

                            {{-- END BOOKING FORM --}}


                            {{-- video url --}}
                            @if (!empty($tour->video_url))
                                <h3 class="widget-subtitle">Video tour</h3>
                                <div class="overview-area video-box1">
                                    {{-- <h3 class="item-title">Property Preview</h3> --}}

                                    <div class="ratio ratio-16x9">

                                        <iframe width="130" height="175" src=" {{ $tour->video_url }}"
                                            allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen"
                                            msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen"
                                            webkitallowfullscreen="webkitallowfullscreen">
                                        </iframe>

                                    </div>

                                </div>
                            @else
                                <center><span>No Property Video Added </span></center>
                            @endif
                            {{-- end of video --}}

                            <hr>


                            {{-- google map --}}
                            {{-- @if (!empty($tour->google_map_iframe_url))
                                <div class="overview-area map-box">
                                    <h3 class="widget-subtitle">Google map </h3>
                                    <div class="item-map">
                                        <iframe src="{{ $tour->google_map_iframe_url }}" width="100%" height="349"
                                            style="border: 0" allowfullscreen="" loading="lazy"></iframe>
                                    </div>
                                </div>
                            @else
                                <center><span>No Property Map Added </span></center>
                            @endif

                            <hr> --}}

                            {{-- end of google map --}}


                        </div>

                    </div>
                    {{-- end side bar right --}}
                </div>
            </div>
        </div>
        </div>
    </section>
@endsection
