@extends('frontend/layouts_frontend/master_frontend')

@section('title')
    Apartments - Relocate Uganda
@endsection


@section('extra_styles')
@endsection

{{-- CONTENT SECTION --}}
@section('content')
    <!--=====================================-->
    <!--=   Main Banner     Start           =-->
    <!--=====================================-->

    <section class="main-banner-wrap1 main-banner-wrap5" data-bg-image="assets/frontend_assets/img/slider/slider4.jpg">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="main-banner-box1 main-banner-box5">
                        <h1 class="item-title wow fadeInUp" data-wow-delay=".4s">Apartments Available</h1>
                        <p style="margin-top:-20px;" class="item-para wow fadeInUp text-center text-white "
                            data-wow-delay=".4s">We have the properties <span class="banner-p"> you have been looking for
                                !</span>
                    </div>



                </div>
            </div>
        </div>
    </section>

    <!--=====================================-->
    <!--=   Breadcrumb     Start            =-->
    <!--=====================================-->


    <!--=====================================-->
    <!--=   Grid     Start                  =-->
    <!--=====================================-->

    <section class="grid-wrap3">
        <div class="container">
            <div class="row gutters-40">
                {{-- <div class="col-lg-4 widget-break-lg sidebar-widget">
                    <div class="widget widget-advanced-search">
                        <h3 class="widget-subtitle">Advanced Search</h3>
                        <form action="https://radiustheme.com/demo/html/homlisti/index.html"
                            class="map-forms map-form-style-2">
                            <input type="text" class="form-control" placeholder="What are you looking for?">
                            <div class="row">
                                <div class="col-lg-12 pl-15 mb-0">
                                    <div class="rld-single-select">
                                        <select class="select single-select mr-0">
                                            <option value="1">Property Type</option>
                                            <option value="2">Family House</option>
                                            <option value="3">Apartment</option>
                                            <option value="3">Condo</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12 pl-15 mb-0">
                                    <div class="rld-single-select">
                                        <select class="select single-select mr-0">
                                            <option value="1">All Categories</option>
                                            <option value="2">Rent</option>
                                            <option value="3">Sell</option>
                                            <option value="3">Buy</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12 pl-15">
                                    <div class="rld-single-select">
                                        <select class="select single-select mr-0">
                                            <option value="1">All Cities</option>
                                            <option value="2">Los Angeles</option>
                                            <option value="3">Chicago</option>
                                            <option value="3">Philadelphia</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="banner-search-wrap banner-search-wrap-2">
                            <div class="rld-main-search rld-main-search3">
                                <div class="main-search-field-2">
                                    <!-- Area Range -->
                                    <div class="price-range-wrapper">
                                        <div class="range-box">
                                            <div class="price-label">Price:</div>
                                            <div id="price-range-filter-4" class="price-range-filter"></div>
                                            <div class="price-filter-wrap d-flex align-items-center">
                                                <div class="price-range-select">
                                                    <div class="price-range range-title">$</div>
                                                    <div class="price-range" id="price-range-min-4"></div>
                                                    <div class="price-range">-</div>
                                                    <div class="price-range" id="price-range-max-4"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="filter-button">
                                    <a href="single-listing1.html" class="filter-btn1 search-btn">Search<i
                                            class="fas fa-search"></i></a>
                                </div>
                            </div>
                            <!--/ End Search Form -->
                        </div>
                    </div>

                </div> --}}


                {{-- PROPERTIES GRID --}}
                <div class="col-lg-12">
                    <div class="property-wrap-9">

                        {{-- SEARCH  --}}

                        <div class="rld-main-search">
                            <div class="row">
                                <div class="col-sm-12">

                                    {{-- search form  --}}
                                    <form action="{{ route('apartments.search') }}" method="GET">
                                        <div class="box">
                                            <div class="box-top">
                                                <div class="rld-single-input item">
                                                    <input type="text" name="query"
                                                        placeholder="Search any apartment by price ie 2000" required>
                                                </div>

                                                <div class="item rt-filter-btn">


                                                    {{-- <a class="filter-btn"><button type="submit">
                                                    <span>Search</span><i class="fas fa-search"></i></button></a> --}}
                                                    <button type="submit" class="btn btn-success"
                                                        style="background-color:#8c325f;">Search</button>
                                                </div>
                                            </div>

                                        </div>
                                    </form>
                                    {{-- end search form --}}
                                </div>
                            </div>
                        </div>

                        {{-- END OF SEARCH --}}


                        <div class="tab-style-1 tab-style-3">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="mylisting" role="tabpanel">
                                    <div class="row">

                                        {{-- Properties Loop --}}


                                        @forelse($apartments as $apartment)
                                            <div class="col-lg-4 col-md-4">
                                                <div class="property-box2 wow animated fadeInUp" data-wow-delay=".3s">
                                                    <div class="item-img">
                                                        <a href="{{ route('relocate_apartments.show', $apartment->id) }}">
                                                            {{-- @if (!empty($apartment->featured_photo)) --}}
                                                            {{-- <img src="{{ $apartment->featured_photo }}" alt="photo"
                                                                    width="100%" height="340" > --}}

                                                            <a href="javascript::void(0)">
                                                                <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                                    src="{{ asset($apartment->featured_photo) }}"
                                                                    alt="preview"
                                                                    style="width:100% !important; object-fit:cover;  height: 300px;">
                                                            </a>

                                                            {{-- @else
                                                                <span> N/A </span>
                                                            @endif --}}

                                                        </a>
                                                        <div class="item-category-box1">
                                                            <div class="item-category" style="background-color:#8c325f;">
                                                                @if ($apartment->property_booked_status == 1)
                                                                    Available
                                                                @elseif($apartment->property_booked_status == 0)
                                                                    Booked
                                                                @else
                                                                    N/A
                                                                @endif

                                                            </div>
                                                        </div>
                                                        <div class="rent-price">
                                                            <div class="item-price">

                                                                @if (!empty($apartment->price))
                                                                    {{ $apartment->price }}
                                                                @else
                                                                    <span>N/A </span>
                                                                @endif
                                                                <span><i>/</i>mo</span>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="item-category10"><a
                                                            href="{{ route('relocate_apartments.show', $apartment->id) }}"
                                                            style="color:#8c325f;">Details</a>
                                                    </div>
                                                    <div class="item-content">
                                                        <div class="verified-area">
                                                            <h3 class="item-title">
                                                                <a
                                                                    href="{{ route('relocate_apartments.show', $apartment->id) }}">
                                                                    {{ $apartment->name }} </a>
                                                            </h3>
                                                        </div>
                                                        <div class="location-area"><i class="flaticon-maps-and-flags"></i>
                                                            @if (!empty($apartment->address))
                                                                {{ $apartment->address }}
                                                            @else
                                                                <span>No Address </span>
                                                            @endif

                                                        </div>

                                                        <div class="item-categoery3">
                                                            <ul>
                                                                <li><i class="flaticon-bed"
                                                                        style="background-color:#8c325f; color:#ffffff;"></i>
                                                                    Beds:
                                                                    @if (!empty($apartment->beds))
                                                                        {{ $apartment->beds }}
                                                                    @else
                                                                        <span>N/A </span>
                                                                    @endif
                                                                </li>

                                                                <li><i class="flaticon-shower"
                                                                        style="background-color:#8c325f; color:#ffffff;"></i>Baths:
                                                                    @if (!empty($apartment->bathrooms))
                                                                        {{ $apartment->bathrooms }}
                                                                    @else
                                                                        <span>N/A </span>
                                                                    @endif


                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @empty
                                            <center><span>No apartments found.. </span></center>
                                        @endforelse


                                        {{-- End of properties loop --}}


                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                {{-- END OF PROPERTIES GRID --}}
            </div>
        </div>
    </section>
@endsection

{{-- END OF MAIN CONTENT SECTION --}}

@section('extra_scripts')
@endsection
