@extends('frontend/layouts_frontend/master_frontend')

@section('title')
    Apartment Details - Relocate Uganda
@endsection


@section('extra_styles')
@endsection

{{-- CONTENT SECTION --}}
@section('content')
    <section class="main-banner-wrap1 main-banner-wrap5"
        data-bg-image="{{ asset('assets/frontend_assets/img/slider/slider4.jpg') }}">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="main-banner-box1 main-banner-box5">
                        <h1 class="item-title wow fadeInUp" data-wow-delay=".4s">Apartments Details</h1>
                        <p style="margin-top:-20px;" class="item-para wow fadeInUp text-center text-white "
                            data-wow-delay=".4s">We have the properties <span class="banner-p"> you have been looking for
                                !</span>
                    </div>



                </div>
            </div>
        </div>
    </section>





    <!--=====================================-->
    <!--=   Single Listing     Start        =-->
    <!--=====================================-->

    <section class="single-listing-wrap1">
        <div class="container">
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif


            @if (session('messagenoapartments'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagenoapartments') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif


            <div class="single-property">
                <div class="content-wrapper">
                    <div class="property-heading">

                        <div class="row">
                            <div class="col-lg-6 col-md-12">
                                <div class="single-list-cate">
                                    @if ($apartment->units_available > 0)
                                        <div class="item-categoery">
                                            PROPERTY AVAILABLE FOR BOOKING
                                        </div>
                                    @elseif($apartment->units_available <= 0)
                                        <button type="submit" class="btn btn-danger" disabled>
                                            APARTMENT UNITS ALL ALREADY BOOKED

                                        </button>
                                        <br>
                                        <span> You cannot book it.</span>
                                    @else
                                        N/A
                                    @endif
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12">

                                <div class="single-list-price" style="font-size: 23px; ">
                                    @if (!empty($apartment->price))
                                        PRICE : USD {{ $apartment->price }}
                                    @else
                                        <span> PRICE : N/A </span>
                                    @endif

                                    |
                                    @if (!empty($apartment->units_available >= 0))
                                        UNITS LEFT : {{ $apartment->units_available }}
                                    @elseif($apartment->units_available == 0)
                                        <span>0</span>
                                    @else
                                        <span> N/A </span>
                                    @endif

                                </div>


                            </div>
                        </div>

                        <div class="row align-items-center">
                            <div class="col-lg-8 col-md-12">
                                <div class="single-verified-area">

                                    <div class="item-title">
                                        <h3>
                                            @if (!empty($apartment->name))
                                                {{ $apartment->name }}
                                            @else
                                                <span>N/A </span>
                                            @endif
                                        </h3>
                                    </div>
                                </div>
                                <div class="single-item-address">
                                    <ul>
                                        <li>
                                            <i class="fas fa-map-marker-alt"></i>
                                            @if (!empty($apartment->address))
                                                Address : {{ $apartment->address }}
                                            @else
                                                <span>Address : N/A </span>
                                            @endif
                                        </li>

                                        <li>
                                            <i class="fas fa-map-marker-alt"></i>
                                            @if (!empty($apartment->city))
                                                City : {{ $apartment->city }}
                                            @else
                                                <span>City : N/A </span>
                                            @endif
                                        </li>

                                        <li>
                                            <i class="fas fa-calendar"></i>
                                            @if (!empty($apartment->created_at))
                                                Added on : {{ $apartment->created_at }}
                                            @else
                                                <span>Added on : N/A </span>
                                            @endif
                                        </li>

                                        <li>
                                            <i class="fas fa-clock"></i>
                                            @if (!empty($apartment->apartment_category->category_name))
                                                Category : {{ $apartment->apartment_category->category_name }}
                                            @else
                                                <span>Category : N/A</span>
                                            @endif
                                        </li>


                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="row">
                        {{-- left side bar --}}
                        <div class="col-lg-8">

                            {{-- featured photo --}}
                            {{-- <a href="javascript::void(0)">
                                <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                    src="{{ asset($apartment->featured_photo) }}" alt="preview"
                                    style=" width:100% !important; object-fit:cover;">
                            </a> --}}
                            @if (!empty($apartment->property_video_url))
                                <div class="overview-area video-box1">
                                    <h3 class="widget-subtitle">Video tour</h3>
                                    <hr>

                                    <div class="ratio ratio-16x9">
                                        <iframe width="130" height="175" src=" {{ $apartment->property_video_url }}"
                                            allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen"
                                            msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen"
                                            webkitallowfullscreen="webkitallowfullscreen">
                                        </iframe>

                                    </div>

                                </div>
                            @else
                                <center><span>No Property Video Added </span></center>
                            @endif
                            <hr>
                            {{-- end featured photo --}}

                            <div class="single-listing-box1">
                                <div class="overview-area listing-area">
                                    <h3 class="item-title">About This Apartment</h3>
                                    <p>
                                        @if (!empty($apartment->description))
                                            {{ $apartment->description }}
                                        @else
                                            <span>N/A </span>
                                        @endif
                                    </p>

                                </div> <br>



                                {{-- photo library upload --}}
                                {{-- <div class="card" style="margin-top:20px;">
                                    <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                        <center>Apartment Photos Collection</center>
                                    </div>
                                    <div class="card-body">

                                        <div class="row">

                                            @if (!empty($apartment->photo_library))
                                                @foreach (is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library) as $image)
                                                    <div class=" col-md-4 col-lg-4 col-xs-12">

                                                        <a href="{!! asset($image) !!}">
                                                            <img style="
                                                                height: 300px; 
                                                                background-color:#f1ecec; 
                                                                object-fit:cover;
                                                                max-width:100% !important;
                                                                border:#ffffff 2px solid;
                                                                background-repeat: no-repeat;
                                                                object-position: center center;
                                                                background-size:cover;
                                                                padding:2px; 
                                                                margin:0px;"
                                                                src="{{ asset($image) }}" alt="">
                                                        </a>


                                                    </div>
                                                @endforeach
                                            @else
                                                <center><span>No Photos Available <span></center>
                                            @endif


                                        </div>


                                    </div>
                                </div> --}}

                                {{-- end of photo library upload --}}

                                {{-- overview --}}
                                <div class="overview-area">
                                    <h3 class="item-title">Overview of the apartment</h3>
                                    <div class="gallery-icon-box">
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Unique ID</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->unique_id))
                                                        {{ $apartment->unique_id }}
                                                    @else
                                                        <span>N/A </span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Category :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->apartment_category->category_name))
                                                        {{ $apartment->apartment_category->category_name }}
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Beds :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->beds))
                                                        {{ $apartment->beds }}
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Size :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->size))
                                                        {{ $apartment->size }} Sqft
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="gallery-icon-box">
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Rooms :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->rooms))
                                                        {{ $apartment->rooms }}
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Bathrooms :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->bathrooms))
                                                        {{ $apartment->bathrooms }}
                                                    @else
                                                        <span>N/A</span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Balcony :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->balcony))
                                                        @if ($apartment->balcony == '1')
                                                            Yes
                                                        @endif

                                                        @if ($apartment->balcony == '0')
                                                            No
                                                        @endif
                                                    @else
                                                        <span> N/A </span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Booking :</li>
                                                <li class="deep-clr">
                                                    @if (!empty($apartment->property_booked_status))
                                                        @if ($apartment->property_booked_status == '1')
                                                            Available
                                                        @endif

                                                        @if ($apartment->property_booked_status == '0')
                                                            Booked
                                                        @endif
                                                    @else
                                                        <span> N/A </span>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>



                                {{-- amenities --}}
                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Amenities</h3>
                                    <div class="row">
                                        @forelse ($apartment->amenities as $amenity)
                                            <div class="col-lg-4">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        {{ $amenity->name }}
                                                    </li>
                                                </ul>
                                            </div>
                                        @empty

                                            <span style="color:red;">No Amenities Available </span>
                                        @endforelse

                                    </div>
                                </div>
                                <br>


                                {{-- end of amenities --}}

                                {{-- FETCH PROXIMITY INFORMATION --}}
                                <div class="overview-area floor-plan-box">
                                    <h3 class="item-title">Proximities to nearby areas</h3>
                                    @php
                                        // pick proximities in each category
                                        $apartment_proximities_data = !empty($apartment->apartment_proximities)
                                            ? json_decode($apartment->apartment_proximities, true)
                                            : [];
                                        // pick data
                                        $restaurants_nearyby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'restaurant',
                                        );
                                        $shopping_malls_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'shopping_mall',
                                        );
                                        $police_station_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'police_station',
                                        );
                                        $schools_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'school',
                                        );
                                        $hospitals_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'hospital',
                                        );
                                        $sports_grounds_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'sports_ground',
                                        );
                                        $christian_worship_places_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'christian_worship_place',
                                        );
                                        $moslem_worship_places_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'moslem_worship_place',
                                        );

                                    @endphp


                                    {{-- fetch nearby restaurants --}}
                                    @if (count($restaurants_nearyby) > 0)
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#headingtwo" aria-expanded="true" role="button">
                                                        <span>Restaurants Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="headingtwo" class="collapse" data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    @foreach ($restaurants_nearyby as $key => $restaurant)
                                                                        <li>
                                                                            <i class="fas fa-check-circle"></i>
                                                                            <b> Name </b> : {{ $restaurant['place_name'] }} &nbsp;
                                                                            | &nbsp;<b>Distance</b> : |
                                                                            {{ $restaurant['place_distance'] }}&nbsp;
                                                                            <b> Time</b> &nbsp;
                                                                            : {{ $restaurant['place_time'] }}
                                                                            | &nbsp; <b>Address</b> : {{ $restaurant['place_address'] }}
                                                                        </li> <hr>
                                                                    @endforeach
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    @else
                                        {{-- <center> <span style="color:red;">No Restaurants Nearby </span>
                                        </center> --}}
                                    @endif
                                    {{-- end of fetch nearby restaurants --}}


                                    {{-- fetch nearby shopping malls --}}
                                    @if (count($shopping_malls_nearby) > 0)
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_restaurant" aria-expanded="true"
                                                        role="button">
                                                        <span>Shopping Malls Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_restaurant" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    <div class="card-body">

                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    @foreach ($shopping_malls_nearby as $key => $shopping_mall)
                                                                        {{-- {{ dd($shopping_mall) }} --}}
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name</b> : {{ $shopping_mall['place_name'] }}
                                                                            &nbsp;| Distance :&nbsp; | &nbsp;
                                                                            {{ $shopping_mall['place_distance'] }}
                                                                            <b>Time</b> &nbsp;
                                                                            : &nbsp;{{ $shopping_mall['place_time'] }}
                                                                            | &nbsp; <b>Address</b> :&nbsp;
                                                                            {{ $shopping_mall['place_address'] }}
                                                                        </li><hr>
                                                                    @endforeach
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    @else
                                        {{-- <center> <span style="color:red;">No Shopping Malls Nearby </span>
                                        </center> --}}
                                    @endif
                                    {{-- end of fetch nearby shopping malls --}}

                                    {{-- fetch police stations --}}
                                    @if (count($police_station_nearby) > 0)
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_police_stations" aria-expanded="true"
                                                        role="button">
                                                        <span>Police Stations Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_police_stations" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    @foreach ($police_station_nearby as $key => $police_station)
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name</b> : {{ $police_station['place_name'] }}
                                                                            | &nbsp; <b>Distance</b> : |&nbsp;
                                                                            {{ $police_station['place_distance'] }} &nbsp;
                                                                            <b>Time</b> &nbsp;
                                                                            : {{ $police_station['place_time'] }}&nbsp;
                                                                            | &nbsp; <b>Address</b> :&nbsp;
                                                                            {{ $police_station['place_address'] }}
                                                                        </li><hr>
                                                                    @endforeach
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    @else
                                        {{-- <center> <span style="color:red;">No Police Stations Nearby </span>
                                        </center> --}}
                                    @endif
                                    {{-- end of fetch police stations --}}


                                    {{-- fetch schools nearby --}}
                                    @if (count($schools_nearby) > 0)
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_schools" aria-expanded="true"
                                                        role="button">
                                                        <span>Schools Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_schools" class="collapse" data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    @foreach ($schools_nearby as $key => $schools)
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name :</b>  {{ $schools['place_name'] }} &nbsp;
                                                                            | <b>Distance :</b> | {{ $schools['place_distance'] }}&nbsp;
                                                                            <b>Time</b>
                                                                            : {{ $schools['place_time'] }}
                                                                            | <b>Address :</b> {{ $schools['place_address'] }}&nbsp;
                                                                        </li><hr>
                                                                    @endforeach
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    @else
                                        {{-- <center> <span style="color:red;">No Schools Nearby </span>
                                        </center> --}}
                                    @endif
                                    {{-- end of fetch schools nearby --}}


                                    {{-- fetch Hospitals Nearby --}}
                                    @if (count($hospitals_nearby) > 0)
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_hospital" aria-expanded="true"
                                                        role="button">
                                                        <span>Hospitals Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_hospital" class="collapse" data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    @foreach ($hospitals_nearby as $key => $hospital)
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name : </b> {{ $hospital['place_name'] }} &nbsp;
                                                                            | <b>Distance : </b> |&nbsp;
                                                                            {{ $hospital['place_distance'] }}
                                                                            <b>Time </b>
                                                                            : &nbsp;{{ $hospital['place_time'] }}
                                                                            | <b>Address : </b> &nbsp; {{ $hospital['place_address'] }}
                                                                        </li><hr>
                                                                    @endforeach
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    @else
                                        {{-- <center> <span style="color:red;">No Hospitals Nearby </span>
                                        </center> --}}
                                    @endif
                                    {{-- end of fetch schools nearby --}}

                                    {{-- fetch Sports grounds  Nearby --}}
                                    @if (count($sports_grounds_nearby) > 0)
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_sports_ground" aria-expanded="true"
                                                        role="button">
                                                        <span>Sports Grounds Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_sports_ground" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    @foreach ($sports_grounds_nearby as $key => $sports_ground)
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b> &nbsp; Name : </b> {{ $sports_ground['place_name'] }}
                                                                            | <b> &nbsp;Distance : </b> |
                                                                            {{ $sports_ground['place_distance'] }}
                                                                            <b> &nbsp;Time </b>
                                                                            : {{ $sports_ground['place_time'] }}
                                                                            | <b> &nbsp;Address : </b>
                                                                            {{ $sports_ground['place_address'] }}
                                                                        </li><hr>
                                                                    @endforeach
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    @else
                                        {{-- <center> <span style="color:red;">No Sports grounds Nearby </span>
                                        </center> --}}
                                    @endif
                                    {{-- end of fetch sports ground nearby --}}



                                    {{-- fetch Christian Worship Places  Nearby --}}
                                    @if (auth()->user()->religion === 'christian')
                                        @if (count($christian_worship_places_nearby) > 0)
                                            <div id="accordion" class="accordion">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                            data-bs-target="#heading_christian_worship_place"
                                                            aria-expanded="true" role="button">
                                                            <span>Christian Worship Places Nearby </span>

                                                        </div>
                                                    </div>


                                                    <div id="heading_christian_worship_place" class="collapse"
                                                        data-bs-parent="#accordion">
                                                        <div class="card-body">


                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <ul class="ameniting-list">
                                                                        @foreach ($christian_worship_places_nearby as $key => $christian_worship_place)
                                                                            <li><i class="fas fa-check-circle"></i>
                                                                                <b>Name : </b>
                                                                                {{ $christian_worship_place['place_name'] }}
                                                                                | &nbsp; <b>Distance : </b> |
                                                                                {{ $christian_worship_place['place_distance'] }}
                                                                                &nbsp; <b>Time</b>
                                                                                :
                                                                                {{ $christian_worship_place['place_time'] }}
                                                                                | &nbsp; <b>Address :</b>
                                                                                {{ $christian_worship_place['place_address'] }}
                                                                            </li><hr>
                                                                        @endforeach
                                                                    </ul>
                                                                </div>


                                                            </div>


                                                        </div>


                                                    </div>
                                                </div>



                                            </div>
                                        @else
                                            {{-- <center> <span style="color:red;">No Christian Worship Places Nearby </span>
                                            </center> --}}
                                        @endif
                                        {{-- end of fetch christian worship places nearby --}}
                                    @endif


                                    {{-- fetch Moslem worship Places  Nearby --}}
                                    @if (auth()->user()->religion === 'moslem')
                                        @if (count($moslem_worship_places_nearby) > 0)
                                            <div id="accordion" class="accordion">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                            data-bs-target="#heading_mostlem_worship_place"
                                                            aria-expanded="true" role="button">
                                                            <span>Moslem Worship Places Nearby </span>

                                                        </div>
                                                    </div>


                                                    <div id="heading_mostlem_worship_place" class="collapse"
                                                        data-bs-parent="#accordion">
                                                        <div class="card-body">


                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <ul class="ameniting-list">
                                                                        @foreach ($moslem_worship_places_nearby as $key => $moslem_worship_place)
                                                                            <li><i class="fas fa-check-circle"></i>
                                                                                <b>Name : &nbsp; </b>
                                                                                {{ $moslem_worship_place['place_name'] }}
                                                                                | &nbsp; <b>Distance :</b> |
                                                                                {{ $moslem_worship_place['place_distance'] }}
                                                                                &nbsp; <b>Time </b>
                                                                                : {{ $moslem_worship_place['place_time'] }}
                                                                                | &nbsp; <b> Address : </b>
                                                                                {{ $moslem_worship_place['place_address'] }}
                                                                            </li><hr>
                                                                        @endforeach
                                                                    </ul>
                                                                </div>


                                                            </div>


                                                        </div>


                                                    </div>
                                                </div>



                                            </div>
                                        @else
                                            {{-- <center> <span style="color:red;">No Moslem worship Places Nearby </span>
                                            </center> --}}
                                        @endif
                                    @endif
                                    {{-- end of fetch moslem worship places nearby --}}
                                </div>
                                {{-- END OF FETCH PROXIMITY INFORMATION --}}


                            </div>
                        </div>
                        {{-- end left side bar --}}

                        {{-- side bar right --}}
                        <div class="col-lg-4 widget-break-lg sidebar-widget">

                            {{-- BOOKING FORM --}}

                            <div class="widget widget-contact-box">
                                <h3 class="widget-subtitle">Book this apartment</h3>


                                <form action="{{ route('bookings.store') }}" method="POST"
                                    enctype="multipart/form-data" class="contact-box">
                                    @csrf
                                    <div class="row">
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="first_name"
                                                placeholder="Your First Name" />

                                            @error('first_name')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="last_name"
                                                placeholder="Last Name" />
                                            @error('last_name')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="email"
                                                placeholder="E-mail" />
                                            @error('email')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="nationality"
                                                placeholder="Enter Your Nationality" />
                                            @error('nationality')
                                                <small class="text-danger"> {{ $message }}</small>
                                            @enderror
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="current_address"
                                                placeholder="Enter Current Address" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="phone_number"
                                                placeholder="Enter Phone Number" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="date" class="form-control" name="arrival_date"
                                                placeholder="Enter arrival date" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="hidden" class="form-control" name="apartment_id"
                                                value=" {{ $apartment->id }}" placeholder="Enter apartment id" />
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <textarea name="message" id="message" class="form-text" placeholder="Message" cols="30" rows="4"></textarea>
                                    </div>


                                    {{-- submit --}}

                                    @if ($apartment->units_available > 0)
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <button type="submit" class="item-btn">
                                                    BOOK NOW <i class="fas fa-envelope"></i>
                                                </button>
                                            </div>
                                        </div>
                                    @else
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <center>
                                                    <button type="submit" class="btn btn-danger" disabled>
                                                        ALL APARTMENT UNITS BOOKED

                                                    </button>
                                                    <br>
                                                    <span> You cannot book it.</span>
                                                </center>
                                            </div>
                                        </div>
                                    @endif


                            </div>
                            <div class="form-response"></div>
                            </form>

                            {{-- END BOOKING FORM --}}



                            {{-- video url --}}
                            {{-- @if (!empty($apartment->property_video_url))
                                <h3 class="widget-subtitle">Video tour</h3>
                                <div class="overview-area video-box1">
                                    <div class="ratio ratio-16x9">
                                        <iframe width="130" height="175"
                                            src=" {{ $apartment->property_video_url }}" allowfullscreen="allowfullscreen"
                                            mozallowfullscreen="mozallowfullscreen" msallowfullscreen="msallowfullscreen"
                                            oallowfullscreen="oallowfullscreen"
                                            webkitallowfullscreen="webkitallowfullscreen">
                                        </iframe>

                                    </div>

                                </div>
                            @else
                                <center><span>No Property Video Added </span></center>
                            @endif --}}
                            {{-- end of video --}}

                            <hr>


                            {{-- google map --}}
                            @if (!empty($apartment->google_map_iframe_url))
                                <div class="overview-area map-box">
                                    <h3 class="widget-subtitle">Google map </h3>
                                    <div class="item-map">
                                        <iframe src="{{ $apartment->google_map_iframe_url }}" width="100%"
                                            height="349" style="border: 0" allowfullscreen="" loading="lazy"></iframe>
                                    </div>
                                </div>
                            @else
                                <center><span>No Property Map Added </span></center>
                            @endif

                            <hr>

                            {{-- end of google map --}}


                        </div>



                    </div>
                    {{-- end side bar right --}}
                </div>
            </div>
        </div>
        </div>
    </section>
@endsection
