<?php $__env->startSection('title'); ?>
    All Tours
<?php $__env->stopSection(); ?>


<?php $__env->startSection('extra_styles'); ?>
    <style>
        /* multiple photo upload - environmental activities css */
        .imagePreview {
            width: 100%;
            height: 300px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            1 display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            width: 80px;
            height: 40px;
            padding-top: 3px;
            padding-left: 8px;
            padding-right: 8px;
            background-color: #f60909;
            color: #ffffff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .imgAdd {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .dell {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #ca078c;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        /* end of multiple photo upload - environmental activities css */
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Tours <span class="text-muted fw-normal ms-2">(<?php echo e($count_tours); ?>)</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tour-create')): ?>
                                <a href="/admin/tours/create" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    Add Tour</a>
                            <?php endif; ?>
                        </div>

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tour-restore')): ?>
                                <a href="<?php echo e(route('tours.trashed')); ?>" class="btn bg-danger text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Trashed Tours</a>
                            <?php endif; ?>
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH tours -->
            
            <!-- FETCH FEEDBACKS -->
            
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagedelete')): ?>
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    <?php echo e(session('messagedelete')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                
            <?php endif; ?>

            
            <?php if(session('messageupdate')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messageupdate')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagerestore')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagerestore')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            
                            <th scope="col"> ID</th>
                            <th scope="col">Tour Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Units Available</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                            $counter = 1;
                        ?>

                        <?php $__empty_1 = true; $__currentLoopData = $tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>

                                <td><?php echo e($counter + $key); ?></td>

                                <td>
                                    <?php if(!empty($tour->name)): ?>
                                        <?php echo e($tour->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($tour->tour_category->name)): ?>
                                        <?php echo e($tour->tour_category->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($tour->slots_available)): ?>
                                        <?php echo e($tour->slots_available); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <?php if(!empty($tour->user->name)): ?>
                                        <?php echo e($tour->user->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tour-show')): ?>
                                            <div class="col-md-4">
                                                <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                    data-bs-target="#viewtourDetails<?php echo e($tour->id); ?>"
                                                    data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                            </div>
                                        <?php endif; ?>

                                        
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tour-edit')): ?>
                                            <div class="col-md-4">

                                                <a href="<?php echo e(route('tours.edit', $tour->id)); ?>"><button type="button"
                                                        class="btn btn-info"><i class="fas fa-pencil-alt "></i>
                                                    </button></a>

                                                

                                            </div>
                                        <?php endif; ?>

                                        <!-- delete  -->

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tour-delete')): ?>
                                            <div class="col-md-4">
                                                <form action="<?php echo e(route('tours.destroy', $tour->id)); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        <?php endif; ?>


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewtourDetails<?php echo e($tour->id); ?>" tabindex="-1"
                                aria-labelledby="viewtourDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewtourDetailsLabel"> tour
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            
                                            <p>Featured Photo </p>
                                            <hr>

                                            <a href="<?php echo asset($tour->featured_photo); ?>">
                                                <img onerror="if (this.src != '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>') this.src = '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>';"
                                                    src="<?php echo e(asset($tour->featured_photo)); ?>" alt="preview"
                                                    style=" width:100% !important; object-fit:cover;">
                                            </a>
                                            <hr>

                                            <p> Tour Name :
                                                <?php if(!empty($tour->name)): ?>
                                                    <?php echo e($tour->name); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>



                                            <p>Created By :
                                                <?php if(!empty($tour->user->name)): ?>
                                                    <?php echo e($tour->user->name); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> Start Date :
                                                <?php if(!empty($tour->start_date)): ?>
                                                    <?php echo e($tour->start_date); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> End Date :
                                                <?php if(!empty($tour->end_date)): ?>
                                                    <?php echo e($tour->end_date); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> Slots available :
                                                <?php if(!empty($tour->slots_available)): ?>
                                                    <?php echo e($tour->slots_available); ?> slots
                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> Tour Singles Price :
                                                <?php if(!empty($tour->tour_single_cost)): ?>
                                                    <?php echo e($tour->tour_single_cost); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> Tour Couple Price :
                                                <?php if(!empty($tour->tour_couple_cost)): ?>
                                                    <?php echo e($tour->tour_couple_cost); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            





                                            <p>Tour Status :
                                                <?php if($tour->tour_status == 1): ?>
                                                    Active
                                                <?php elseif($tour->tour_status == 0): ?>
                                                    Inactive
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Booking Status :
                                                <?php if($tour->booking_status == 1): ?>
                                                    Available for booking
                                                <?php elseif($tour->booking_status == 0): ?>
                                                    Inactive
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            
                                            <div class="card" style="margin-top:2px; padding-top:10px;">
                                                <div class="card-header bg-primary" style=" color:#ffffff;">
                                                    Tour Detailed Itenary

                                                </div>


                                                <?php
                
                                                $tour_itenaries_data = !empty($tour->tour_itenaries) ? json_decode($tour->tour_itenaries, true): [];
                                                 $tour_itenaries_data_grouped_by_day = collect($tour_itenaries_data)->groupBy('itenary_day_number');
                                
                                               ?>
                                               
                                
                                               <ul>
                                                <?php $__currentLoopData = $tour_itenaries_data_grouped_by_day; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dayNumber => $dayItenaries): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <br>
                                                    <li>
                                                        <strong>Day <?php echo e($dayNumber); ?></strong>
                                                        <ul>
                                                            <?php $__currentLoopData = $dayItenaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itenary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Time: <?php echo e($itenary['itenary_time']); ?> - Description: <?php echo e($itenary['itenary_description']); ?>

                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                              
                                


                                                
                                                <div class="card" style="margin-top:2px; padding-top:10px;">
                                                    <div class="card-header bg-primary" style=" color:#ffffff;">
                                                        Tour Includes
                                                    </div>
                                                    <?php
                                                        $tour_includes_data = json_decode($tour->tour_includes);
                                                    ?>
                                                    
                                                    <p>

                                                    <ul style="padding-top:20px;">
                                                        <?php $__empty_2 = true; $__currentLoopData = $tour_includes_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour_include): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                            <li><?php echo e($tour_include); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                            <span>No tour includes </span>
                                                        <?php endif; ?>
                                                    </ul>
                                                    </p>





                                                </div>
                                                <br>

                                                
                                                <div class="card" style="margin-top:2px; padding-top:10px;">
                                                    <div class="card-header bg-primary" style=" color:#ffffff;">
                                                        Tour Excludes

                                                    </div>
                                                    <?php
                                                        $tour_excludes_data = json_decode($tour->tour_excludes);
                                                    ?>
                                                    <p>

                                                    <ul style="padding-top:20px;">
                                                        <?php $__empty_2 = true; $__currentLoopData = $tour_excludes_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour_exclude): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                            <li><?php echo e($tour_exclude); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                            <span>No tour excludes </span>
                                                        <?php endif; ?>
                                                    </ul>
                                                    </p>

                                                </div>

                                                
                                                <div class="card" style="margin-top:2px; padding-top:10px;">
                                                    <div class="card-header bg-primary" style=" color:#ffffff;">
                                                        Tour Activities

                                                    </div>
                                                    <?php
                                                        $tour_activities_data = json_decode($tour->tour_activities);
                                                    ?>
                                                    <p>

                                                    <ul style="padding-top:20px;">
                                                        <?php $__empty_2 = true; $__currentLoopData = $tour_activities_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour_activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                            <li><?php echo e($tour_activity); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                            <span>No tour activities </span>
                                                        <?php endif; ?>
                                                    </ul>
                                                    </p>

                                                </div>





                                                <p>Video Tour Preview </p>
                                                <div class="card-body">
                                                    <!-- 16:9 aspect ratio -->
                                                    <div class="ratio ratio-16x9">
                                                        <iframe width="130" height="175"
                                                            src=" <?php echo e($tour->video_url); ?>"
                                                            allowfullscreen="allowfullscreen"
                                                            mozallowfullscreen="mozallowfullscreen"
                                                            msallowfullscreen="msallowfullscreen"
                                                            oallowfullscreen="oallowfullscreen"
                                                            webkitallowfullscreen="webkitallowfullscreen">
                                                        </iframe>
                                                    </div>
                                                </div>


                                                <hr>
                                                
                                                <div class="card" style="margin-top:20px;">
                                                    <div class="card-header"
                                                        style="background-color:#0e274c; color:#ffffff;">
                                                        <center>Tour Photos Collection</center>
                                                    </div>
                                                    <div class="card-body">

                                                        <div class="row">

                                                            
                                                            <?php if(!empty($tour->photo_library)): ?>
                                                                <?php $__currentLoopData = is_null($tour->photo_library) ? [] : explode(',', $tour->photo_library); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    
                                                                    <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                        <a href="<?php echo asset($image); ?>">
                                                                            <img style="
                                                                            height: 200px; 
                                                                            background-color:#ffffff; 
                                                                            object-fit:cover;
                                                                            max-width:100% !important;
                                                                            border:#ffffff 2px solid;
                                                                            background-repeat: no-repeat;
                                                                            object-position: center center;
                                                                            background-size:cover;
                                                                            padding:7px; 
                                                                            margin:0px;"
                                                                                src="<?php echo e(asset($image)); ?>" alt="">
                                                                        </a>


                                                                    </div>
                                                                    
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <center><span>No Photos Available <span></center>
                                                            <?php endif; ?>
                                                            


                                                        </div>


                                                    </div>
                                                </div>
                                                <hr>

                                                

                                                
                                                <p>Tour Description : <br>
                                                    <?php if(!empty($tour->description)): ?>
                                                        <?php echo e($tour->description); ?>

                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </p>




                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-danger"
                                                    data-bs-dismiss="modal">Close
                                                </button>

                                                

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- END OF VIEW DETAILS MODEL -->



                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <center>
                                    <span class="badge bg-soft-danger text-danger"
                                        style="padding:10px;  font-size:20px;">Oops! No tours
                                        available!</span>
                                </center>
                        <?php endif; ?>

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->



    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_scripts'); ?>
    
    <script src="<?php echo e(asset('assets/backend_assets/assets/js/tours/itenaries_add_remove_row.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/backend_assets/assets/js/tours/itenaries_add_remove_row_update.js')); ?>"></script>


    
    <script src="<?php echo e(asset('assets/backend_assets/assets/js/tours/activities_add_remove_row.js')); ?>"></script>


    
    <script src="<?php echo e(asset('assets/backend_assets/assets/js/tours/tour_excludes_add_remove_row.js')); ?>"></script>

    
    <script src="<?php echo e(asset('assets/backend_assets/assets/js/tours/tour_includes_add_remove_row.js')); ?>"></script>



    
    <script type="text/javascript">
        $(".imgAdd").click(function() {
            $(this).closest(".row").find('.imgAdd').before(
                '<div class="col-md-6 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" name="photo_library[]" class="uploadFile img" value="Upload Photo" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-timess del"><span style="color:#ffffff; ">Remove</span></i></div>'
            );
        });
        $(document).on("click", "i.del", function() {
            // 	to remove card
            $(this).parent().remove();
            // to clear image
            // $(this).parent().find('.imagePreview').css("background-image","url('')");
        });
        $(function() {
            $(document).on("change", ".uploadFile", function() {
                var uploadFile = $(this);
                var files = !!this.files ? this.files : [];
                if (!files.length || !window.FileReader)
                    return; // no file selected, or no FileReader support

                if (/^image/.test(files[0].type)) { // only image file
                    var reader = new FileReader(); // instance of the FileReader
                    reader.readAsDataURL(files[0]); // read the local file

                    reader.onloadend = function() { // set image data as background of div
                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                            "url(" + this.result + ")");
                    }
                }

            });
        });
    </script>


    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/tours/index.blade.php ENDPATH**/ ?>