<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> Tour Booking Notification</title>
    <style>
        /* Reset some default styles */
        body,
        h1,
        h2,
        p {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f4;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            color: #333333;
            margin-bottom: 20px;
        }

        p {
            color: #555555;
            margin-bottom: 20px;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 5px;
        }
    </style>
</head>

<body>
    <div class="container">

        <h2>Hi, Relocate Portal #Administrator</h2>
        <hr> <br>

        <p><b>New Tour Booking! Find details below. </b></p>

        <p>Tour :
            <?php echo e($admin_tour_booking_data['tour']['name']); ?>

        </p>
        <p>First Name :
            <?php if(!empty($admin_tour_booking_data['first_name'])): ?>
                <?php echo e($admin_tour_booking_data['first_name']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>


        </p>
        <p>Last Name :

            <?php if(!empty($admin_tour_booking_data['last_name'])): ?>
                <?php echo e($admin_tour_booking_data['last_name']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>

        </p>

        <p>Email :
            <?php if(!empty($admin_tour_booking_data['email'])): ?>
                <?php echo e($admin_tour_booking_data['email']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>
        </p>


        <p>Nationality :

            <?php if(!empty($admin_tour_booking_data['nationality'])): ?>
                <?php echo e($admin_tour_booking_data['nationality']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>
        </p>

        <p>Phone Number :

            <?php if(!empty($admin_tour_booking_data['phone_number'])): ?>
                <?php echo e($admin_tour_booking_data['phone_number']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>

        </p>
        <p>Arrival Date :

            <?php if(!empty($admin_tour_booking_data['arrival_date'])): ?>
                <?php echo e($admin_tour_booking_data['arrival_date']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>

        </p>

        <p style="max-width: 100%; word-wrap: break-word;"> Message <br>

            <?php if(!empty($admin_tour_booking_data['message'])): ?>
                <?php echo e($admin_tour_booking_data['message']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>
        </p>

        <hr>
        
        <p>Thank you for your noting down these details.</p>
        <p>It will be helpful if you give me response soon</p>
        <p>Best regards,<br>
            <?php if(!empty($admin_tour_booking_data['first_name'])): ?>
                <?php echo e($admin_tour_booking_data['first_name']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>

            <?php if(!empty($admin_tour_booking_data['last_name'])): ?>
                <?php echo e($admin_tour_booking_data['last_name']); ?>

            <?php else: ?>
                <span> N/A </span>
            <?php endif; ?>

        </p>
    </div>
</body>

</html>
<?php /**PATH /home/vagrant/code/relocateug/resources/views/frontend/pages_frontend/emails/tours/admin_tour_booking_notification.blade.php ENDPATH**/ ?>