<?php $__env->startSection('title'); ?>
    All Apartments
<?php $__env->stopSection(); ?>


<?php $__env->startSection('extra_styles'); ?>
    <style>
        /* multiple photo upload - environmental activities css */
        .imagePreview {
            width: 100%;
            height: 300px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            1 display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            width: 80px;
            height: 40px;
            padding-top: 3px;
            padding-left: 8px;
            padding-right: 8px;
            background-color: #f60909;
            color: #ffffff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .imgAdd {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .dell {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #ca078c;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        /* end of multiple photo upload - environmental activities css */
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Apartments <span
                                class="text-muted fw-normal ms-2">(<?php echo e($count_apartments); ?>)</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-create')): ?>
                                <a href="/admin/apartments/create" class="btn bg-primary text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Add Apartment</a>
                            <?php endif; ?>
                        </div>

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-restore')): ?>
                                <a href="<?php echo e(route('apartments.trashed')); ?>" class="btn bg-danger text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Trashed Apartments</a>
                            <?php endif; ?>
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH apartments -->
            
            <!-- FETCH FEEDBACKS -->
            
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagedelete')): ?>
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    <?php echo e(session('messagedelete')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                
            <?php endif; ?>

            
            <?php if(session('messageupdate')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messageupdate')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagerestore')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagerestore')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            
                            <th scope="col"> Unique ID</th>
                            <th scope="col">Apartment Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Units Available</th>
                            <th scope="col">Price</th>
                            <th scope="col">Price Range</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__empty_1 = true; $__currentLoopData = $apartments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apartment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>

                                
                                <td><?php echo e($apartment->unique_id); ?></td>

                                <td>
                                    <?php if(!empty($apartment->name)): ?>
                                        <?php echo e($apartment->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($apartment->apartment_category->category_name)): ?>
                                        <?php echo e($apartment->apartment_category->category_name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($apartment->units_available)): ?>
                                        <?php echo e($apartment->units_available); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>


                                <td>
                                    <?php if(!empty($apartment->price)): ?>
                                        <?php echo e($apartment->price); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>

                                <td>


                                    <?php if(!empty($apartment->price_range)): ?>
                                        <?php if($apartment->price_range == '1000_2000'): ?>
                                            <?php echo e('1000 - 2000 '); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == '2000_3000'): ?>
                                            <?php echo e('2000 - 3000'); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == '3000_4000'): ?>
                                            <?php echo e('3000 - 4000'); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == '4000_5000'): ?>
                                            <?php echo e('4000 - 5000'); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == 'null'): ?>
                                            <?php echo e('N/A'); ?>

                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span> N/A </span>
                                    <?php endif; ?>

                                </td>
                                <td>
                                    <?php if(!empty($apartment->user->name)): ?>
                                        <?php echo e($apartment->user->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-show')): ?>
                                            <div class="col-md-4">
                                                <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                    data-bs-target="#viewapartmentDetails<?php echo e($apartment->id); ?>"
                                                    data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                            </div>
                                        <?php endif; ?>

                                        
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-edit')): ?>
                                            <div class="col-md-4">
                                                <a href="<?php echo e(route('apartments.edit', $apartment->id)); ?>"><button type="button"
                                                    class="btn btn-info"><i class="fas fa-pencil-alt "></i>
                                                </button></a>
                                                

                                            </div>
                                        <?php endif; ?>

                                        <!-- delete  -->

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-delete')): ?>
                                            <div class="col-md-4">
                                                <form action="<?php echo e(route('apartments.destroy', $apartment->id)); ?>"
                                                    method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        <?php endif; ?>


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewapartmentDetails<?php echo e($apartment->id); ?>" tabindex="-1"
                                aria-labelledby="viewapartmentDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel"> Apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            
                                            <p>Featured Photo </p>
                                            <hr>

                                            <a href="<?php echo asset($apartment->featured_photo); ?>">
                                                <img onerror="if (this.src != '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>') this.src = '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>';"
                                                    src="<?php echo e(asset($apartment->featured_photo)); ?>" alt="preview"
                                                    style=" width:100% !important; object-fit:cover;">
                                            </a>
                                            <hr>

                                            <p> Property Name :
                                                <?php if(!empty($apartment->name)): ?>
                                                    <?php echo e($apartment->name); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>


                                            <p> Unique ID :
                                                <?php if(!empty($apartment->unique_id)): ?>
                                                    <?php echo e($apartment->unique_id); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Created By :
                                                <?php if(!empty($apartment->user->name)): ?>
                                                    <?php echo e($apartment->user->name); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> Address :
                                                <?php if(!empty($apartment->address)): ?>
                                                    <?php echo e($apartment->address); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> City :
                                                <?php if(!empty($apartment->city)): ?>
                                                    <?php echo e($apartment->city); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> Beds :
                                                <?php if(!empty($apartment->beds)): ?>
                                                    <?php echo e($apartment->beds); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p> Size :
                                                <?php if(!empty($apartment->size)): ?>
                                                    <?php echo e($apartment->size); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Rooms :
                                                <?php if(!empty($apartment->rooms)): ?>
                                                    <?php echo e($apartment->rooms); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Bathrooms :
                                                <?php if(!empty($apartment->bathrooms)): ?>
                                                    <?php echo e($apartment->bathrooms); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Balcony :
                                                <?php if($apartment->property_booked_status == 1): ?>
                                                    Available
                                                <?php elseif($apartment->property_booked_status == 0): ?>
                                                    Booked
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Property Booked Status :
                                                <?php if($apartment->property_booked_status == 1): ?>
                                                    Available
                                                <?php elseif($apartment->property_booked_status == 0): ?>
                                                    Booked
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Property Status :
                                                <?php if($apartment->property_status == 1): ?>
                                                    Active
                                                <?php elseif($apartment->property_status == 0): ?>
                                                    De-activated
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Price :
                                                <?php if(!empty($apartment->price)): ?>
                                                    <?php echo e($apartment->price); ?>

                                                <?php else: ?>
                                                    <span>N/A</span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>

                                            <p>Price Range :
                                                <?php if(!empty($apartment->price_range)): ?>
                                                    <?php if($apartment->price_range == '1000_2000'): ?>
                                                        <?php echo e('1000 - 2000 '); ?>

                                                    <?php endif; ?>

                                                    <?php if($apartment->price_range == '2000_3000'): ?>
                                                        <?php echo e('2000 - 3000'); ?>

                                                    <?php endif; ?>

                                                    <?php if($apartment->price_range == '3000_4000'): ?>
                                                        <?php echo e('3000 - 4000'); ?>

                                                    <?php endif; ?>

                                                    <?php if($apartment->price_range == '4000_5000'): ?>
                                                        <?php echo e('4000 - 5000'); ?>

                                                    <?php endif; ?>

                                                    <?php if($apartment->price_range == '5000_6000'): ?>
                                                        <?php echo e('5000 - 6000'); ?>

                                                    <?php endif; ?>

                                                    <?php if($apartment->price_range == '6000_7000'): ?>
                                                        <?php echo e('6000 - 7000'); ?>

                                                    <?php endif; ?>

                                                    <?php if($apartment->price_range == '7000_8000'): ?>
                                                        <?php echo e('7000 -8000'); ?>

                                                    <?php endif; ?>

                                                    <?php if($apartment->price_range == ''): ?>
                                                        <?php echo e('N/A'); ?>

                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span> N/A </span>
                                                <?php endif; ?>
                                            </p>
                                            <hr>



                                            
                                            <div class="card" style="margin-top:20px;">
                                                <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                                    <center>Apartment Proximities</center>
                                                </div>
                                                <?php
                                        // pick proximities in each category
                                        $apartment_proximities_data = !empty($apartment->apartment_proximities) ? json_decode($apartment->apartment_proximities, true): [];
                                        // pick data
                                        $restaurants_nearyby = collect($apartment_proximities_data)->where('place_category','restaurant');
                                        $shopping_malls_nearby = collect($apartment_proximities_data)->where('place_category','shopping_mall');
                                        $police_station_nearby = collect($apartment_proximities_data)->where('place_category','police_station');
                                        $schools_nearby = collect($apartment_proximities_data)->where('place_category','school');
                                        $hospitals_nearby = collect($apartment_proximities_data)->where('place_category','hospital');
                                        $sports_grounds_nearby = collect($apartment_proximities_data)->where('place_category','sports_ground');
                                        $christian_worship_places_nearby = collect($apartment_proximities_data)->where('place_category','christian_worship_place');
                                        $moslem_worship_places_nearby = collect($apartment_proximities_data)->where('place_category','moslem_worship_place');

                                        

                                    ?>

                                                <div class="card-body">

                                                    
                                                    <div class="row">
                                                        

                                                        
                                                        <?php if(count($restaurants_nearyby) > 0): ?>
                                                            <p><b>RESTAURANTS NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $restaurants_nearyby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $restaurant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($restaurant['place_name']); ?>

                                                                    | Distance : | <?php echo e($restaurant['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($restaurant['place_time']); ?>

                                                                    | Address : <?php echo e($restaurant['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Restaurants Nearby </span>
                                                            </center>
                                                        <?php endif; ?>
                                                        

                                                        
                                                        <?php if(count($shopping_malls_nearby) > 0): ?>
                                                            <p><b>SHOPPING MALLS NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $shopping_malls_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shopping_mall): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($shopping_mall['place_name']); ?>

                                                                    | Distance : | <?php echo e($shopping_mall['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($shopping_mall['place_time']); ?>

                                                                    | Address : <?php echo e($shopping_mall['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Shopping Malls Nearby
                                                                </span></center>
                                                        <?php endif; ?>
                                                        


                                                        
                                                        <?php if(count($police_station_nearby) > 0): ?>
                                                            <p><b>POLICE STATIONS NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $police_station_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $police_station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($police_station['place_name']); ?>

                                                                    | Distance : | <?php echo e($police_station['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($police_station['place_time']); ?>

                                                                    | Address : <?php echo e($police_station['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Police Stations Malls
                                                                    Nearby
                                                                </span></center>
                                                        <?php endif; ?>
                                                        


                                                        
                                                        <?php if(count($schools_nearby) > 0): ?>
                                                            <p><b>SCHOOLS NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $schools_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($school['place_name']); ?>

                                                                    | Distance : | <?php echo e($school['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($school['place_time']); ?>

                                                                    | Address : <?php echo e($school['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Schools Malls Nearby
                                                                </span></center>
                                                        <?php endif; ?>
                                                        


                                                        
                                                        <?php if(count($hospitals_nearby) > 0): ?>
                                                            <p><b>HOSPITALS NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $hospitals_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $hospital): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($hospital['place_name']); ?>

                                                                    | Distance : | <?php echo e($hospital['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($hospital['place_time']); ?>

                                                                    | Address : <?php echo e($hospital['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Christian Worship place
                                                                    Nearby
                                                                </span></center>
                                                        <?php endif; ?>
                                                        



                                                        
                                                        <?php if(count($sports_grounds_nearby) > 0): ?>
                                                            <p><b>SPORTS GROUNDS NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $sports_grounds_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sports_ground): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($sports_ground['place_name']); ?>

                                                                    | Distance : | <?php echo e($sports_ground['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($sports_ground['place_time']); ?>

                                                                    | Address : <?php echo e($sports_ground['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Sports Ground Malls Nearby
                                                                </span></center>
                                                        <?php endif; ?>
                                                        



                                                        
                                                        <?php if(count($christian_worship_places_nearby) > 0): ?>
                                                            <p><b>CHRISTIAN WORSHIP PLACES NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $christian_worship_places_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $christian_worship_place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($christian_worship_place['place_name']); ?>

                                                                    | Distance : | <?php echo e($christian_worship_place['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($christian_worship_place['place_time']); ?>

                                                                    | Address : <?php echo e($christian_worship_place['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Christian Worship place
                                                                    Nearby
                                                                </span></center>
                                                        <?php endif; ?>
                                                        

                                                        
                                                        <?php if(count($moslem_worship_places_nearby) > 0): ?>
                                                            <p><b>MOSLEM WORSHIP NEARBY</b> </p>
                                                            <ul>
                                                                <?php $__currentLoopData = $moslem_worship_places_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $moslem_worship_place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    Name : <?php echo e($moslem_worship_place['place_name']); ?>

                                                                    | Distance : | <?php echo e($moslem_worship_place['place_distance']); ?>

                                                                    Time
                                                                    : <?php echo e($moslem_worship_place['place_time']); ?>

                                                                    | Address : <?php echo e($moslem_worship_place['place_address']); ?>

                                                                </li>
                                                                    <hr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        <?php else: ?>
                                                            <center> <span style="color:red;">No Moslem Worship Places
                                                                    Nearby </span></center>
                                                        <?php endif; ?>
                                                        



                                                    </div>


                                                </div>
                                            </div>


                                            <hr>
                                            <p> Amenities </p>
                                            <hr>
                                            <div class="row">
                                                <?php $__empty_2 = true; $__currentLoopData = $apartment->amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                    <div class="col-lg-6">
                                                        <div class="card bg-primary border-primary text-white-50">
                                                            <div class="card-body">
                                                                <h5 class="mb-3 text-white text-center">
                                                                    <?php echo e($amenity->name); ?></h5>
                                                                
                                                            </div>
                                                        </div>
                                                    </div>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>

                                                    <span style="color:red;">No Amenities Available </span>
                                                <?php endif; ?>

                                            </div>

                                            <hr>
                                            <p>Property 3D Video </p>
                                            <div class="card-body">
                                                <!-- 16:9 aspect ratio -->
                                                <div class="ratio ratio-16x9">
                                                    
                                                    <iframe width="130" height="175"
                                                        src=" <?php echo e($apartment->property_video_url); ?>"
                                                        allowfullscreen="allowfullscreen"
                                                        mozallowfullscreen="mozallowfullscreen"
                                                        msallowfullscreen="msallowfullscreen"
                                                        oallowfullscreen="oallowfullscreen"
                                                        webkitallowfullscreen="webkitallowfullscreen">
                                                    </iframe>
                                                </div>
                                            </div>


                                            <hr>
                                            
                                            <div class="card" style="margin-top:20px;">
                                                <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                                    <center>Apartment Photos Collection</center>
                                                </div>
                                                <div class="card-body">

                                                    <div class="row">

                                                        
                                                        <?php if(!empty($apartment->photo_library)): ?>
                                                            <?php $__currentLoopData = is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                
                                                                <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                    <a href="<?php echo asset($image); ?>">
                                                                        <img style="
                                                                            height: 200px; 
                                                                            background-color:#ffffff; 
                                                                            object-fit:cover;
                                                                            max-width:100% !important;
                                                                            border:#ffffff 2px solid;
                                                                            background-repeat: no-repeat;
                                                                            object-position: center center;
                                                                            background-size:cover;
                                                                            padding:7px; 
                                                                            margin:0px;"
                                                                            src="<?php echo e(asset($image)); ?>" alt="">
                                                                    </a>


                                                                </div>
                                                                
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <center><span>No Photos Available <span></center>
                                                        <?php endif; ?>
                                                        


                                                    </div>


                                                </div>
                                            </div>

                                            

                                            
                                            <p>Google Map </p>
                                            <?php if(!empty($apartment->google_map_iframe_url)): ?>
                                                <div class="overview-area map-box">
                                                    
                                                    <div class="item-map">
                                                        <iframe src="<?php echo e($apartment->google_map_iframe_url); ?>"
                                                            width="100%" height="349" style="border: 0"
                                                            allowfullscreen="" loading="lazy"></iframe>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <center><span>No Property Map Added </span></center>
                                            <?php endif; ?>

                                            <hr>



                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-edit')): ?>
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editapartment<?php echo e($apartment->id); ?>"
                                                    data-bs-whatever="@getbootstrap">Edit apartment
                                                </button>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            
                            <div class="modal fade" id="editapartment<?php echo e($apartment->id); ?>" tabindex="-1"
                                aria-labelledby="editapartmentLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel">Edit apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE  CATEGORIES -->

                                            <form action="<?php echo e(route('apartments.update', $apartment->id)); ?>">
                                                 <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">Apartment/Property
                                                                Name</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="name"
                                                                placeholder="Enter apartment name"
                                                                value="<?php echo e($apartment->name); ?>">
                                                            <div>
                                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <small class="text-danger"> <?php echo e($message); ?></small>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Address</label>
                                                                    <input type="text" class="form-control"
                                                                        id="validationCustom01" name="address"
                                                                        placeholder="Enter  addresss"
                                                                        value="<?php echo e($apartment->address); ?>">
                                                                    <div>
                                                                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Apartment
                                                                        Category</label>

                                                                    <select name="apartment_category_id"
                                                                        class="form-select">
                                                                        <?php $__currentLoopData = $apartment_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apartment_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($apartment_category->id); ?>"
                                                                                <?php if($apartment_category->id == $apartment->apartment_category_id): echo 'selected'; endif; ?>>
                                                                                <?php echo e($apartment_category->category_name); ?>

                                                                            </option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>

                                                                    <div>
                                                                        <?php $__errorArgs = ['apartment_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>



                                                        </div>


                                                    </div>

                                                    
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Number Of
                                                                        Beds</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="beds"
                                                                        placeholder="Enter  number of beds"
                                                                        value="<?php echo e($apartment->beds); ?>">
                                                                    <div>
                                                                        <?php $__errorArgs = ['beds'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Area (sqft)</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="size"
                                                                        placeholder="Enter area in square ft"
                                                                        value="<?php echo e($apartment->size); ?>">
                                                                    <div>
                                                                        <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    

                                                    
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Number Of
                                                                        Rooms</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="rooms"
                                                                        placeholder="Enter number of rooms"
                                                                        value="<?php echo e($apartment->rooms); ?>">
                                                                    <div>
                                                                        <?php $__errorArgs = ['rooms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Bathrooms</label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="bathrooms"
                                                                        placeholder="Enter number of bathrooms"
                                                                        value="<?php echo e($apartment->bathrooms); ?>">
                                                                    <div>
                                                                        <?php $__errorArgs = ['bathrooms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">City</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="city"
                                                                placeholder="Enter  city"
                                                                value="<?php echo e($apartment->city); ?>">
                                                            <div>
                                                                <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <small class="text-danger"> <?php echo e($message); ?></small>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Units
                                                                Available </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="units_available"
                                                                value="<?php echo e($apartment->units_available); ?>">
                                                            <div>
                                                                <?php $__errorArgs = ['units_available'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <small class="text-danger"> <?php echo e($message); ?></small>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <div class="card-header  bg-primary" style=" color:#ffffff;">
                                                                Select Amenities for this apartment

                                                            </div>
                                                            <hr>
                                                            <div class="row">

                                                                <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <div class="col-md-4">
                                                                        <label>
                                                                            <input type="checkbox" name="amenities[]"
                                                                                value="<?php echo e($amenity->id); ?>"
                                                                                
                                                                                <?php echo e(in_array($amenity->id, $apartment->amenities->pluck('id')->toArray()) ? 'checked' : ''); ?>>
                                                                            <?php echo e($amenity->name); ?>

                                                                        </label>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>


                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">3D Video
                                                                Link
                                                                (Youtube)
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="property_video_url"
                                                                placeholder="Enter video link from youtube"
                                                                value="<?php echo e($apartment->property_video_url); ?>">
                                                            <div>
                                                                <?php $__errorArgs = ['property_video_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <small class="text-danger"> <?php echo e($message); ?></small>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Google Map
                                                                Iframe Link (src)</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="google_map_iframe_url"
                                                                value="<?php echo e($apartment->google_map_iframe_url); ?>"
                                                                placeholder="Enter Google map iframe Link (src)">
                                                            <div>
                                                                <?php $__errorArgs = ['google_map_iframe_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <small class="text-danger"> <?php echo e($message); ?></small>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Price / Month (USD)
                                                                    </label>
                                                                    <input type="number" class="form-control"
                                                                        id="validationCustom01" name="price"
                                                                        placeholder="Enter apartment price"
                                                                        value="<?php echo e($apartment->price); ?>">
                                                                    <div>
                                                                        <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Price Range ( USD
                                                                        )</label>

                                                                    <select name="price_range" class="form-select">
                                                                        
                                                                        <option value="1000_2000"
                                                                            <?php echo e($apartment->price_range == '1000_2000' ? 'selected' : ''); ?>>
                                                                            1000 - 2000 USD
                                                                        </option>
                                                                        <option value="2000_3000"
                                                                            <?php echo e($apartment->price_range == '2000_3000' ? 'selected' : ''); ?>>
                                                                            2000 - 3000 USD
                                                                        </option>
                                                                        <option value="3000_4000"
                                                                            <?php echo e($apartment->price_range == '3000_4000' ? 'selected' : ''); ?>>
                                                                            3000 - 4000 USD
                                                                        </option>
                                                                        <option value="4000_5000"
                                                                            <?php echo e($apartment->price_range == '4000_5000' ? 'selected' : ''); ?>>
                                                                            4000 - 5000 USD
                                                                        </option>
                                                                        <option value="5000_6000"
                                                                            <?php echo e($apartment->price_range == '5000_6000' ? 'selected' : ''); ?>>
                                                                            5000 - 6000 USD
                                                                        </option>
                                                                        <option value="6000_7000"
                                                                            <?php echo e($apartment->price_range == '6000_7000' ? 'selected' : ''); ?>>
                                                                            6000 - 7000 USD
                                                                        </option>
                                                                        <option value="7000_8000"
                                                                            <?php echo e($apartment->price_range == '7000_8000' ? 'selected' : ''); ?>>
                                                                            7000 - 8000 USD
                                                                        </option>
                                                                        <option value="8000_9000"
                                                                            <?php echo e($apartment->price_range == '8000_9000' ? 'selected' : ''); ?>>
                                                                            8000 - 9000 USD
                                                                        </option>
                                                                        <option value="9000_10000"
                                                                            <?php echo e($apartment->price_range == '9000_10000' ? 'selected' : ''); ?>>
                                                                            9000 - 10000 USD
                                                                        </option>


                                                                    </select>

                                                                    <div>
                                                                        <?php $__errorArgs = ['price_range'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    



                                                    
                                                    <hr>
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Property
                                                                        Status</label>
                                                                    <div class="form-check form-check-inline">
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_status" type="radio"
                                                                                id="property_status" 
                                                                                <?php echo e($apartment->property_status == '1' ? 'checked' : ''); ?>

                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="property_status">Active</label>
                                                                        </div>
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_status" type="radio"
                                                                                id="property_status" 
                                                                                <?php echo e($apartment->property_status == '0' ? 'checked' : ''); ?>

                                                                                value="0">
                                                                            <label class="form-check-label"
                                                                                for="property_status">In
                                                                                Active</label>
                                                                        </div>
                                                                        
                                                                        <?php $__errorArgs = ['property_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <span
                                                                                class="text-danger"><?php echo e($message); ?></span>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Booking
                                                                        Status</label>
                                                                    <div class="form-check form-check-inline">
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_booked_status"
                                                                                type="radio" id="property_booked_status"
                                                                                
                                                                                <?php echo e($apartment->property_booked_status == '1' ? 'checked' : ''); ?>

                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="property_booked_status">Available</label>
                                                                        </div>
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input"
                                                                                name="property_booked_status"
                                                                                type="radio" id="property_booked_status"
                                                                                
                                                                                <?php echo e($apartment->property_booked_status == '0' ? 'checked' : ''); ?>

                                                                                value="0">
                                                                            <label class="form-check-label"
                                                                                for="property_booked_status">Booked</label>
                                                                        </div>
                                                                        
                                                                        <?php $__errorArgs = ['property_booked_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <span
                                                                                class="text-danger"><?php echo e($message); ?></span>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        


                                                    </div>
                                                    <hr>
                                                    


                                                    
                                                    <div class="col-md-12">
                                                        <div class="row">
                                                            
                                                            <div class="col-md-12">
                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Balcony </label>
                                                                    <div class="form-check form-check-inline">
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input" name="balcony"
                                                                                type="radio" id="balcony"
                                                                                
                                                                                <?php echo e($apartment->balcony == '1' ? 'checked' : ''); ?>

                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="balcony">Available</label>
                                                                        </div>
                                                                        <div class="form-check form-check-inline">
                                                                            <input class="form-check-input" name="balcony"
                                                                                type="radio" id="balcony"
                                                                                
                                                                                <?php echo e($apartment->balcony == '0' ? 'checked' : ''); ?>

                                                                                value="0">
                                                                            <label class="form-check-label"
                                                                                for="balcony">Unavailable</label>
                                                                        </div>
                                                                        
                                                                        <?php $__errorArgs = ['balcony'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <span
                                                                                class="text-danger"><?php echo e($message); ?></span>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="col-md-12">

                                                                
                                                                <a href="javascript::void(0)">
                                                                    <img onerror="if (this.src != '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>') this.src = '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>';"
                                                                        src="<?php echo e(asset($apartment->featured_photo)); ?>"
                                                                        alt="preview"
                                                                        style=" width:100% !important; object-fit:cover;">
                                                                </a>

                                                                <div class="mb-3">
                                                                    <label class="form-label"
                                                                        for="validationCustom01">Featured Photo</label>
                                                                    <input type="file" class="form-control"
                                                                        name="featured_photo" id="⁠⁠featured_photo"
                                                                        placeholder="">
                                                                    <div>
                                                                        <?php $__errorArgs = ['⁠⁠featured_photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <small class="text-danger">
                                                                                <?php echo e($message); ?></small>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        


                                                    </div>
                                                    <hr>
                                                    


                                                    

                                                    <div class="card" style="margin-top:20px; padding-top:10px;">
                                                        
                                                        <div class="card-header bg-primary" style=" color:#ffffff;">
                                                            Apartment photos collection

                                                        </div>
                                                        

                                                        
                                                        <div class="row">
                                                            <?php if(!empty($apartment->photo_library)): ?>
                                                                <?php $__currentLoopData = is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    
                                                                    <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                        <a href="<?php echo asset($image); ?>">
                                                                            <img style="
                                                                        height: 200px; 
                                                                        background-color:#ffffff; 
                                                                        object-fit:cover;
                                                                        width:100% !important;
                                                                        border:#ffffff 2px solid;
                                                                        background-repeat: no-repeat;
                                                                        object-position: center center;
                                                                        background-size:cover;
                                                                        padding:7px; 
                                                                        margin:0px;"
                                                                                src="<?php echo e(asset($image)); ?>"
                                                                                alt="">
                                                                        </a>

                                                                        <p>Remove</p>
                                                                        
                                                                        


                                                                    </div>

                                                                    
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <center><span>No Photos Available <span></center>
                                                            <?php endif; ?>
                                                        </div>
                                                        

                                                        <!-- Display existing images -->
                                                        


                                                        
                                                        <div class="card-header bg-primary" style=" color:#ffffff;">
                                                            Add more photos to the apartment collection

                                                        </div>
                                                        


                                                        <div class="card-body">



                                                            
                                                            <?php $__errorArgs = ['photo_library'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="text-danger"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                                                            

                                                            <input type="file" multiple class="form-control"
                                                                name="photo_library[]" id="upload_multiple">


                                                        </div>
                                                    </div>

                                                    

                                                    

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">Description</label>

                                                            <textarea class="form-control" name="description" id="exampleFormControlTextarea5"
                                                                placeholder="Describe the apartment" rows="3"><?php echo e($apartment->description); ?></textarea>
                                                            <div>
                                                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <small class="text-danger"> <?php echo e($message); ?></small>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <button class="btn btn-primary" type="submit">Update
                                                        Apartment</button>
                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No apartments available!</span>
                            </center>
                        <?php endif; ?>

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_scripts'); ?>
    
    <script type="text/javascript">
        $(".imgAdd").click(function() {
            $(this).closest(".row").find('.imgAdd').before(
                '<div class="col-md-6 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" name="photo_library[]" class="uploadFile img" value="Upload Photo" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-timess del"><span style="color:#ffffff; ">Remove</span></i></div>'
            );
        });
        $(document).on("click", "i.del", function() {
            // 	to remove card
            $(this).parent().remove();
            // to clear image
            // $(this).parent().find('.imagePreview').css("background-image","url('')");
        });
        $(function() {
            $(document).on("change", ".uploadFile", function() {
                var uploadFile = $(this);
                var files = !!this.files ? this.files : [];
                if (!files.length || !window.FileReader)
                    return; // no file selected, or no FileReader support

                if (/^image/.test(files[0].type)) { // only image file
                    var reader = new FileReader(); // instance of the FileReader
                    reader.readAsDataURL(files[0]); // read the local file

                    reader.onloadend = function() { // set image data as background of div
                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                            "url(" + this.result + ")");
                    }
                }

            });
        });
    </script>


    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wanrlnwf/relocateapp.wanraninc.com/relocateapp/resources/views/backend/pages_backend/apartments/index.blade.php ENDPATH**/ ?>