<?php $__env->startSection('title'); ?>
    Trashed Tours
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Trashed Tours <span
                                class="text-muted fw-normal ms-2">(<?php echo e($count_trashed_tours); ?>)</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tour-list')): ?>
                                <a href="/admin/tours" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    All Tours</a>
                            <?php endif; ?>
                        </div>




                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH tours -->
            
            <!-- FETCH FEEDBACKS -->
            
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagedelete')): ?>
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    <?php echo e(session('messagedelete')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                
            <?php endif; ?>

            
            <?php if(session('messageupdate')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messageupdate')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagerestore')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagerestore')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            
                            <th scope="col"> ID</th>
                            <th scope="col">Tour Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Units Available</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                            $counter = 1;
                        ?>
                        <?php $__empty_1 = true; $__currentLoopData = $trashed_tours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>

                               
                                <td><?php echo e($counter + $key); ?></td>

                                <td>
                                    <?php if(!empty($tour->name)): ?>
                                        <?php echo e($tour->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($tour->tour_category->name)): ?>
                                        <?php echo e($tour->tour_category->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($tour->slots_available)): ?>
                                        <?php echo e($tour->slots_available); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <?php if(!empty($tour->user->name)): ?>
                                        <?php echo e($tour->user->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>




                                <td colspan="6">
                                    <div class="row">

                                        <!-- delete  -->
                                        
                                            <div class="col-md-4">
                                                <form action="<?php echo e(route('tours.restore', $tour->id)); ?>"
                                                    method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('POST'); ?>
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-arrow-left"> </button> </a>
                                                </form>
                                            </div>
                                        


                                    </div>
                                </td>
                            </tr>

                        

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No tours available!</span>
                            </center>
                        <?php endif; ?>

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/tours/trashed_tours.blade.php ENDPATH**/ ?>