<?php

namespace App\Http\Controllers\BackEnd\ApartmentCategories;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ApartmentCategory;
use App\Http\Requests\ApartmentCategories\UpdateApartmentCategoryRequest;
use App\Http\Requests\ApartmentCategories\StoreApartmentCategoryRequest;
use App\Http\Requests\Ammenities\StoreAmmenityRequest;



class ApartmentCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $apartment_categories = ApartmentCategory::all();
        $count_apartment_categories = ApartmentCategory::all()->count();
        return view('backend.pages_backend.apartment_categories.index',compact('apartment_categories','count_apartment_categories'));
    }

     // trashed 
     public function trashed_apartment_categories(){
        $trashed_apartment_categories = ApartmentCategory::onlyTrashed()->get();
        $count_trashed_apartment_categories = ApartmentCategory::onlyTrashed()->count();
        // dd($trashed_apartment_categories);
        return view('backend.pages_backend.apartment_categories.trashed_apartment_categories',compact('count_trashed_apartment_categories','trashed_apartment_categories'));

    }

    // restore trashed 
    public function restore_trashed_apartment_categories($id){
        $restore_trashed_category = ApartmentCategory::where('id', $id)->withTrashed()->restore();
        return redirect('/admin/apartment_categories')->with('messagerestore','Apartment Category Restored successfuly');


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages_backend.apartment_categories.create');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreApartmentCategoryRequest $request)
    {
        $apartmentCategory = new ApartmentCategory();
        $apartmentCategory->category_name = $request->category_name;
        $apartmentCategory->category_description = $request->category_description;
        // $apartmentCategory->created_by = auth()->user()->id;

        // return($apartmentCategory);
        $apartmentCategory->save();

        return redirect('/admin/apartment_categories')->with('messagesave','Apartment category added successfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $apartmentCategory = ApartmentCategory::find($id);
        $apartmentCategory->category_name = $request->category_name;
        $apartmentCategory->category_description = $request->category_description;
        $apartmentCategory->save();

        return redirect('/admin/apartment_categories')->with('messageupdate','Apartment category updated successfuly');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $apartment_category = ApartmentCategory::find($id);
        $apartment_category->delete();
        return redirect('/admin/apartment_categories')->with('messagedelete','Apartment category Deleted successfuly');
    }
}
