<?php

namespace App\Http\Controllers\BackEnd\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Shelter;
use App\Models\ShelterFormat;
use App\Models\TargetGroup;
use App\Models\District;
use App\Models\Region;
use Auth;
// activity logs
use Spatie\Activitylog\Models\Activity;
// login activity
use Haruncpi\LaravelUserActivity\Traits\Loggable;
use PDF;


class ShelterReportsController extends Controller
{
    use Loggable;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */




    public function index()
    {

        $shelters = Shelter::all();
        $count_shelters = Shelter::all()->count();

        // update shelter form modal fields
        $shelter_formats =  ShelterFormat::all();
        $target_groups =  TargetGroup::all();
        $shelter_districts =  District::all();
        $shelter_regions =  Region::all();
        $created_by = Auth::user()->name ;
        $updated_by = Auth::user()->name ;
        $allActivity = Activity::all();


        return view('backend.pages_backend.reports.shelters.shelter_reports',
        ['shelters' => $shelters ,
        'count_shelters' => $count_shelters,
        'shelter_formats' => $shelter_formats ,
        'target_groups' => $target_groups,
        'shelter_districts' => $shelter_districts,
        'shelter_regions' =>  $shelter_regions,
        'updated_by' => $updated_by,
        'created_by' => $created_by,


    ]);

    }

    // generate shelter single data report pdf
    public function singleShelterReportData(Request $request, $id)
    {

       $shelter =  Shelter::find($id);
       //    report data array
           $data = [
             'shelter_name' => $shelter->minority_shelter_organization_name,
             'imagePath'    => public_path('img/logo.png'),
             'date' => date('d/m/Y'),
             'shelter_format_name' => $shelter->shelter_format_r->shelter_format_name,
             'target_group_name' => $shelter->target_group_r->target_group_name,
             'district_name' =>  $shelter->shelter_district_r->district_name,
             'region_name' => $shelter->shelter_region_r->region_name,
             'internal_assessement_status' => $shelter->internal_assessement_status,
             'estimated_maximum_capacity_of_occupants' => $shelter->estimated_maximum_capacity_of_occupants,
             'occupants_present_today' => $shelter->occupants_present_today,
             'email' => $shelter->email,
             'primary_contact_name' => $shelter->primary_contact_name,
             'primary_contact_number' => $shelter->primary_contact_number,
             'secondary_contact_name' => $shelter->secondary_contact_name,
             'secondary_contact_number' => $shelter->secondary_contact_number,

           //  'shelters' => $shelter
          ];

        $pdf = PDF::loadView('backend.pages_backend.reports.shelters.shelter_report_template', $data);
        // dd($pdf);
        return $pdf->stream($shelter->minority_shelter_organization_name . ' Report.pdf');
    }




    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
