<?php

namespace App\Http\Controllers\BackEnd\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Shelter;
use App\Models\Tenant;
use Auth;
use PDF;

class TenantReportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // dd("tenants");
        $tenants = Tenant::all();
        $count_tenants = Tenant::all()->count();
        $shelters =  Shelter::all();
        // updated by
        $created_by = Auth::user()->name ;
        $updated_by = Auth::user()->name ;

        return view('backend.pages_backend.reports.tenants.tenant_reports_data',
        [

        'tenants' => $tenants ,
        'count_tenants' => $count_tenants,
        'shelters' => $shelters,
        'updated_by' => $updated_by,
        'created_by' => $created_by,

    ]);
    }

     // generate shelter single data report pdf
     public function singleTenantReportData(Request $request, $id)
     {

        $tenant =  Tenant::find($id);
        //    report data array
            $data = [
              'fullname' => $tenant->fullname,
              'imagePath'    => public_path('img/logo.png'),
              'date' => date('d/m/Y'),
              'tenant_serial_number' => $tenant->tenant_serial_number,
              'shelter_id'           => $tenant->shelter_r->minority_shelter_organization_name,
              'created_by'           => $tenant->created_by,
              'email'                => $tenant->email,
              'phone_no'             => $tenant->phone_no,
              'whatsap_number'       => $tenant->whatsap_number,
              'national_id_availability'                => $tenant->national_id_availability,
              'date_of_birth'                => $tenant->date_of_birth,
              'current_age'                => $tenant->current_age,
              'gender'                => $tenant->gender,
              'hightest_level_of_education'                => $tenant->hightest_level_of_education,
              'skills_and_job_experience'                => $tenant->skills_and_job_experience,
              'pronoun'                => $tenant->pronoun,
              'referee_full_name'                => $tenant->referee_full_name,
              'referee_phone_number'                => $tenant->referee_phone_number,
              'referee_email'                => $tenant->referee_email,
              'former_area_of_residence'                => $tenant->former_area_of_residence,
              'current_area_of_residence'                => $tenant->current_area_of_residence,
              'expected_time_of_stay'                => $tenant->expected_time_of_stay,
              'reason_for_joining'                => $tenant->reason_for_joining,
              'describe_why_homeless'                => $tenant->describe_why_homeless,
              'have_you_been_to_shelter_before'                => $tenant->have_you_been_to_shelter_before,
              'national_id_front_photo'                => $tenant->national_id_front_photo,
              'national_id_back_photo'                => $tenant->national_id_back_photo,
              'passport_photo'                => $tenant->passport_photo,
              'selfie_photo'                => $tenant->selfie_photo,
              'back_driving_permit'                => $tenant->back_driving_permit,
              'front_driving_permit'                => $tenant->front_driving_permit,
              'other_id_front'                => $tenant->other_id_front,
              'other_id_back'                => $tenant->other_id_back,
              'comment_on_tenant'                => $tenant->comment_on_tenant,
           ];

         $pdf = PDF::loadView('backend.pages_backend.reports.tenants.tenant_report_template', $data);
         // dd($pdf);
         return $pdf->stream($tenant->fullname . ' Report.pdf');
     }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
