<?php

namespace App\Http\Requests\Apartments;

use Illuminate\Foundation\Http\FormRequest;

class StoreApartmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'unique_id' => 'nullable',
            'apartment_category_id' => 'required',
            'address' => 'nullable',
            'city' => 'nullable',
            'beds' => 'nullable',
            'size' => 'nullable',
            'rooms' => 'nullable',
            'bathrooms' => 'nullable',
            'property_status' => 'nullable',
            'google_map_iframe_url' => 'nullable',
            'booked_status' => 'nullable',
            'balcony' => 'nullable',
            'property_video_url' => 'nullable',
            'price' => 'nullable',
            'price_range' => 'nullable',
            'description' => 'nullable',
            'photo_library_photo_caption' => 'nullable',
            'featured_photo' => 'nullable|mimes:doc,pdf,docx,zip,jpeg,jpg,csv,txt,xlx,xls,png,svg',

            // 'photo_library.*' => 'image|mimes:jpeg,png,jpg,svg,gif|max:2048',
            'photo_library' => 'nullable',
            'photo_library.*' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048'

        ];
    }

     // custom messages
     public function messages(): array
     {
         return [
             'name.required' => 'Please enter the apartment name',
             'address.required' => 'Please enter the address ',
             'photo_library.required' => 'Please upload some property photos',
             
         ];
     }
}
