<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Booking extends Model
{
    use HasFactory, SoftDeletes;

    // booking belongs to an apartment
    public function apartment()
    {
        return $this->belongsTo(Apartment::class);
    }

    // booking belongs to a user
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
