<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('apartments', function (Blueprint $table) {
            $table->id();
            $table->text('name')->nullable();
            $table->string('unique_id')->nullable();
            $table->text('address')->nullable();
            $table->string('city')->nullable();
            $table->integer('beds')->nullable();
            $table->integer('size')->nullable();
            $table->integer('rooms')->nullable();
            $table->integer('bathrooms')->nullable();
            $table->tinyInteger('property_status')->default(1)->comment('1=active,0=in_active')->nullable();
            $table->tinyInteger('property_booked_status')->default(1)->comment('1=available,0=booked')->nullable();
            $table->tinyInteger('balcony')->default(1)->comment('1=available,0=unavailable')->nullable();
            $table->text('featured_photo')->nullable();
            $table->text('photo_library')->nullable();
            $table->text('photo_library_photo_caption')->nullable();
            $table->text('property_video_url')->nullable();
            $table->text('description')->nullable();
            $table->text('google_map_iframe_url')->nullable();
            $table->string('price')->nullable();
            $table->string('price_range')->nullable();
            $table->foreignId('created_by')->constrained('users');
            $table->foreignId('apartment_category_id')->constrained('apartment_categories');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('apartments');
    }
};
