<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {


        //  PERMISSIONS
         $permissions = [

            //  frontend
            ['name' => 'view-homepage-frontend','description' => 'View Homepage Frontend '],
            ['name' => 'view-apartments-frontend','description'   => 'View apartments Frontend'],
            ['name' => 'view-faq-frontend','description'   => 'View faq Frontend'],
            ['name' => 'view-contact-frontend','description'   => 'View contact Frontend'],




            // backend
             // dashboard
             ['name' => 'dashboard-list','description' => 'View Dashboard '],
             ['name' => 'dashboard-counter-statistics','description'   => 'Dashboard Statistics'],
             ['name' => 'dashboard-graph-statistics','description'   => 'Dashboard Graphs'],
   
            // users
            ['name' => 'user-create','description' => 'Add User'],
            ['name' => 'user-list','description'   => 'View All Users'],
            ['name' => 'user-show','description'   => 'Show  User'],
            ['name' => 'user-edit','description'   => 'Edit User'],
            ['name' => 'user-delete','description' => 'Delete User'],
   
            // Role
            ['name' => 'role-create','description' => 'Add Role'],
            ['name' => 'role-list','description'   => 'View All Role'],
            ['name' => 'role-show','description'   => 'Show  Role'],
            ['name' => 'role-edit','description'   => 'Edit Role'],
            ['name' => 'role-delete','description' => 'Delete Role'],

             // Permission
             ['name' => 'permission-create','description' => 'Add permission'],
             ['name' => 'permission-list','description'   => 'View All permission'],
             ['name' => 'permission-show','description'   => 'Show  permission'],
             ['name' => 'permission-edit','description'   => 'Edit permission'],
             ['name' => 'permission-delete','description' => 'Delete permission'],

              // Activity Log
              ['name' => 'activity_log-create','description' => 'Add activity log'],
              ['name' => 'activity_log-list','description'   => 'View All activity logs'],
              ['name' => 'activity_log-show','description'   => 'Show  activity log'],
              ['name' => 'activity_log-edit','description'   => 'Edit activity log'],
              ['name' => 'activity_log-delete','description' => 'Delete activity log'],

            //   aammenity
             ['name' => 'amenity-create','description' => 'Add ammenity'],
             ['name' => 'amenity-list','description'   => 'View amenities'],
             ['name' => 'amenity-show','description'   => 'Show  amenity'],
             ['name' => 'amenity-edit','description'   => 'Edit amenity'],
             ['name' => 'amenity-delete','description' => 'Delete amenity'],
             ['name' => 'amenity-restore','description' => 'Restore amenity'],

              //   apartment categories
              ['name' => 'apartment-category-create','description' => 'Add apartment category'],
              ['name' => 'apartment-category-list','description'   => 'View apartment categories'],
              ['name' => 'apartment-category-show','description'   => 'Show  apartment category'],
              ['name' => 'apartment-category-edit','description'   => 'Edit apartment category'],
              ['name' => 'apartment-category-delete','description' => 'Delete apartment category'],
              ['name' => 'apartment-category-restore','description' => 'Restore apartment category'],

              //   apartments
              ['name' => 'apartment-create','description' => 'Add apartment'],
              ['name' => 'apartment-list','description'   => 'View apartment'],
              ['name' => 'apartment-show','description'   => 'Show  apartment'],
              ['name' => 'apartment-edit','description'   => 'Edit apartment'],
              ['name' => 'apartment-delete','description' => 'Delete apartment'],
              ['name' => 'apartment-restore','description' => 'Restore apartment'],

            //   price range permissions
             //   apartments
             ['name' => '1000-2000','description' => '1000 - 2000 USD Apartments'],
             ['name' => '2000-3000','description' => '2000-3000 USD Apartments'],
             ['name' => '3000-4000','description' => '3000-4000 USD Apartments'],
             ['name' => '4000-5000','description' => '4000-5000 USD Apartments'],
             ['name' => '5000-6000','description' => '5000-6000 USD Apartments'],
             ['name' => '6000-7000','description' => '6000-7000 USD Apartments'],
             ['name' => '7000-8000','description' => '7000-8000 USD Apartments'],
             ['name' => '8000-9000','description' => '8000-9000 USD Apartments'],

            //  tour categories permissions
            //   apartment categories
            ['name' => 'tour-category-create','description' => 'Add tour category'],
            ['name' => 'tour-category-list','description'   => 'View tour categories'],
            ['name' => 'tour-category-show','description'   => 'Show  tour category'],
            ['name' => 'tour-category-edit','description'   => 'Edit tour category'],
            ['name' => 'tour-category-delete','description' => 'Delete tour category'],
            ['name' => 'tour-category-restore','description' => 'Restore tour category'],

             //   tours
             ['name' => 'tour-create','description' => 'Add tour '],
             ['name' => 'tour-list','description'   => 'View tour'],
             ['name' => 'tour-show','description'   => 'Show  tour '],
             ['name' => 'tour-edit','description'   => 'Edit tour '],
             ['name' => 'tour-delete','description' => 'Delete tour '],
             ['name' => 'tour-restore','description' => 'Restore tour '],



        ];


         foreach ($permissions as $permission) {
            Permission::firstOrCreate($permission);
       }
    }
}
