@extends('backend.layouts_backend.master')

@section('title')
    Last logged activity
@endsection

@section('extra_styles')
    <style>
        table {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        td,
        th {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }

        tr:nth-child(even) {
            background-color: #dddddd;
        }
    </style>
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">





            <div style="margin: 0 auto;">

                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <h5 class="card-title">Last logged activity <span class="text-muted fw-normal ms-2"></span></h5>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                            <div>

                                <a href="activity_logs" class="btn bg-primary text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    All activity logs</a>
                                {{-- <a class="btn btn-primary" href="/districts_report">Districts Report</a> --}}


                            </div>


                        </div>

                    </div>
                </div>
                <!-- end row -->



                <div class="table-responsive mb-4">
                    <table table class="table align-middle datatable dt-responsive table-check nowrap"
                        style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">

                        {{-- Causer/User fields --}}

                        <tr>
                            <td>Logged on:</td>
                            <td>{{ $causer->created_at }}</td>
                        </tr>
                        <tr>
                            <td>Responder Name:</td>
                            <td>{{ $causer->name }}</td>
                        </tr>
                        <tr>
                            <td>Responder Email:</td>
                            <td>{{ $causer->email }}</td>
                        </tr>

                        {{-- subject fields --}}
                        <tr>
                            <td>Subject:</td>
                            <td>{{ $subject }}</td>
                        </tr>

                        <tr>
                            <td>Subject:</td>
                            <td>{{ $subject }}</td>
                        </tr>

                        <tr>
                            <td>description:</td>
                            <td>{{ $description }}</td>
                        </tr>


                    </table>
                </div>



            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
