@extends('backend.layouts_backend.master')

@section('title')
    Edit Apartment
@endsection


@section('extra_styles')
    <style>
        /* multiple photo upload - environmental activities css */
        .imagePreview {
            width: 100%;
            height: 300px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            1 display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            width: 80px;
            height: 40px;
            padding-top: 3px;
            padding-left: 8px;
            padding-right: 8px;
            background-color: #f60909;
            color: #ffffff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .imgAdd {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .dell {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #ca078c;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        /* end of multiple photo upload - environmental activities css */
    </style>
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Apartments <span
                                class="text-muted fw-normal ms-2">({{ $count_apartments }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('apartment-create')
                                <a href="/admin/apartments/create" class="btn bg-primary text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Add Apartment</a>
                            @endcan
                        </div>

                        <div>
                            @can('apartment-restore')
                                <a href="{{ route('apartments.trashed') }}" class="btn bg-danger text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Trashed Apartments</a>
                            @endcan
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH apartments -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert restore item --}}
            @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-md-2"></div>
                <div class="col-md-8">

                    <form action="{{ route('apartments.update', $apartment->id) }}" method="post"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')

                        <div class="row">

                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">Apartment/Property
                                        Name</label>
                                    <input type="text" class="form-control" id="validationCustom01" name="name"
                                        placeholder="Enter apartment name" value="{{ $apartment->name }}">
                                    <div>
                                        @error('name')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Address</label>
                                            <input type="text" class="form-control" id="validationCustom01"
                                                name="address" placeholder="Enter  addresss"
                                                value="{{ $apartment->address }}">
                                            <div>
                                                @error('address')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Apartment
                                                Category</label>

                                            <select name="apartment_category_id" class="form-select">
                                                @foreach ($apartment_categories as $apartment_category)
                                                    <option value="{{ $apartment_category->id }}"
                                                        @selected($apartment_category->id == $apartment->apartment_category_id)>
                                                        {{ $apartment_category->category_name }}
                                                    </option>
                                                @endforeach
                                            </select>

                                            <div>
                                                @error('apartment_category_id')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>



                                </div>


                            </div>

                            {{-- start  multiple column --}}
                            <div class="col-md-12">
                                <div class="row">
                                    {{-- col-1 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Number Of
                                                Beds</label>
                                            <input type="number" class="form-control" id="validationCustom01"
                                                name="beds" placeholder="Enter  number of beds"
                                                value="{{ $apartment->beds }}">
                                            <div>
                                                @error('beds')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    {{-- col-2 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Area (sqft)</label>
                                            <input type="number" class="form-control" id="validationCustom01"
                                                name="size" placeholder="Enter area in square ft"
                                                value="{{ $apartment->size }}">
                                            <div>
                                                @error('size')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- end multiple column --}}

                            {{-- start  multiple column --}}
                            <div class="col-md-12">
                                <div class="row">
                                    {{-- col-1 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Number Of
                                                Rooms</label>
                                            <input type="number" class="form-control" id="validationCustom01"
                                                name="rooms" placeholder="Enter number of rooms"
                                                value="{{ $apartment->rooms }}">
                                            <div>
                                                @error('rooms')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    {{-- col-2 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Bathrooms</label>
                                            <input type="number" class="form-control" id="validationCustom01"
                                                name="bathrooms" placeholder="Enter number of bathrooms"
                                                value="{{ $apartment->bathrooms }}">
                                            <div>
                                                @error('bathrooms')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- end multiple column --}}

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">City</label>
                                    <input type="text" class="form-control" id="validationCustom01" name="city"
                                        placeholder="Enter  city" value="{{ $apartment->city }}">
                                    <div>
                                        @error('city')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            {{-- units available  --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">Units
                                        Available </label>
                                    <input type="text" class="form-control" id="validationCustom01"
                                        name="units_available" value="{{ $apartment->units_available }}">
                                    <div>
                                        @error('units_available')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            {{-- proximities --}}
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <div class="card-header  bg-primary" style=" color:#ffffff;">
                                        ADD PROXMITY ( ADD SPECIFIC PROXIMITY )

                                    </div>

                                    @php
                                        $apartment_proximities = !empty($apartment->apartment_proximities)
                                            ? json_decode($apartment->apartment_proximities, true)
                                            : [];
                                    @endphp
                                    <hr>

                                    {{-- {{ dd( $apartment_proximities) }} --}}

                                    <table class="table color-table inverse-table table-responsive table-borderless"
                                        id="apartment_proximities_details_table">
                                        <tbody id="apartment_proximities_data">
                                            @if (!empty($apartment_proximities))
                                                {{-- if apartment proximities exist --}}
                                                @foreach ($apartment_proximities as $key => $apartment_proximity)
                                                    <tr>
                                                        <td>
                                                            <div class="row mb-2">
                                                                <div class="row">
                                                                    <div class="col-md-4" style="margin-top:10px;">
                                                                        <select name="place_category[]"
                                                                            id="place_category_1" class="form-select">
                                                                            <option value="null"
                                                                                {{ $apartment_proximity['place_category'] == 'null' ? 'selected' : '' }}>
                                                                                -- Select Category --
                                                                            </option>
                                                                            <option value="restaurant"
                                                                                {{ $apartment_proximity['place_category'] == 'restaurant' ? 'selected' : '' }}>
                                                                                Restaurant
                                                                            </option>
                                                                            <option value="shopping_mall"
                                                                                {{ $apartment_proximity['place_category'] == 'shopping_mall' ? 'selected' : '' }}>
                                                                                Shopping Mall
                                                                            </option>
                                                                            <option value="police_station"
                                                                                {{ $apartment_proximity['place_category'] == 'police_station' ? 'selected' : '' }}>
                                                                                Police Station
                                                                            </option>
                                                                            <option value="school"
                                                                                {{ $apartment_proximity['place_category'] == 'school' ? 'selected' : '' }}>
                                                                                School </option>
                                                                            <option value="hospital"
                                                                                {{ $apartment_proximity['place_category'] == 'hospital' ? 'selected' : '' }}>
                                                                                Hospital </option>
                                                                            <option value="sports_ground"
                                                                                {{ $apartment_proximity['place_category'] == 'sports_ground' ? 'selected' : '' }}>
                                                                                Sports Ground
                                                                            </option>
                                                                            <option value="christian_worship_place"
                                                                                {{ $apartment_proximity['place_category'] == 'christian_worship_place' ? 'selected' : '' }}>
                                                                                Christian Worship Place </option>
                                                                            <option value="moslem_worship_place"
                                                                                {{ $apartment_proximity['place_category'] == 'moslem_worship_place' ? 'selected' : '' }}>
                                                                                Moslem
                                                                                Worship Place</option>
                                                                        </select>
                                                                    </div>
                                                                    <div class="col-md-5" style="margin-top:10px;">
                                                                        <input type="text" class="form-control"
                                                                            name="place_name[]" id="place_name_1"
                                                                            value="{{ $apartment_proximity['place_name'] }}"
                                                                            placeholder="Place Name" >

                                                                    </div>

                                                                    <div class="col-md-2" style="margin-top:10px;">
                                                                        <input type="text" class="form-control"
                                                                            name="place_distance[]" id="place_distance_1"
                                                                            value="{{ $apartment_proximity['place_distance'] }}"
                                                                            placeholder="Distance" >
                                                                    </div>



                                                                    <div class="col-md-1">
                                                                        <button onclick="deleteProximityRow(this)"
                                                                            class="btn btn-sm btn-rounded btn-danger"
                                                                            title="Delete this row" style="color: white;"
                                                                            type="button"><i
                                                                                class="fa fa-trash"></i></button>
                                                                    </div>


                                                                    <div class="col-md-4" style="margin-top:10px;">
                                                                        <input type="text" class="form-control"
                                                                            name="place_time[]" id="place_time_1"
                                                                            value="{{ $apartment_proximity['place_time'] }}"
                                                                            placeholder="Time Proximity" >
                                                                    </div>

                                                                    <div class="col-md-7" style="margin-top:10px;">
                                                                        <input type="text" class="form-control"
                                                                            name="place_address[]" id="place_address_1"
                                                                            value="{{ $apartment_proximity['place_address'] }}"
                                                                            placeholder="Address" >
                                                                    </div>

                                                                </div>

                                                            </div>
                                                        </td>


                                                    </tr>
                                                @endforeach
                                            @else
                                                {{-- if no apartment proximity --}}
                                                <tr>
                                                    <td>
                                                        <div class="row mb-2">
                                                            <div class="row">
                                                                <div class="col-md-4" style="margin-top:10px;">
                                                                    <select name="place_category[]" id="place_category_1"
                                                                        class="form-select">
                                                                        <option value="null"> -- Select Category --
                                                                        </option>
                                                                        <option value="restaurant"> Restaurant
                                                                        </option>
                                                                        <option value="shopping_mall"> Shopping Mall
                                                                        </option>
                                                                        <option value="police_station"> Police Station
                                                                        </option>
                                                                        <option value="school"> School </option>
                                                                        <option value="hospital"> Hospital </option>
                                                                        <option value="sports_ground"> Sports Ground
                                                                        </option>
                                                                        <option value="christian_worship_place">
                                                                            Christian Worship Place </option>
                                                                        <option value="moslem_worship_place"> Moslem
                                                                            Worship Place</option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-md-5" style="margin-top:10px;">
                                                                    <input type="text" class="form-control"
                                                                        name="place_name[]" id="place_name_1"
                                                                        placeholder="Place Name" >
                                                                </div>

                                                                <div class="col-md-2" style="margin-top:10px;">
                                                                    <input type="text" class="form-control"
                                                                        name="place_distance[]" id="place_distance_1"
                                                                        placeholder="Distance" >
                                                                </div>


                                                                <div class="col-md-4" style="margin-top:10px;">
                                                                    <input type="text" class="form-control"
                                                                        name="place_time[]" id="place_time_1"
                                                                        placeholder="Time Proximity" >
                                                                </div>

                                                                <div class="col-md-7" style="margin-top:10px;">
                                                                    <input type="text" class="form-control"
                                                                        name="place_address[]" id="place_address_1"
                                                                        placeholder="Address" >
                                                                </div>

                                                            </div>

                                                        </div>
                                                    </td>


                                                </tr>
                                            @endif

                                        </tbody>
                                    </table>

                                    <button type="button" id="add_apartment_proximities_1"
                                        class="btn btn-success add_apartment_proximities_button  label label-inverse"
                                        onclick="add_apartment_proximity_row('apartment_proximities_details_table','apartment_proximities_data')">Add
                                        Proximity -></button>

                                </div>
                            </div>


                            {{-- amenities --}}
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <div class="card-header  bg-primary" style=" color:#ffffff;">
                                        Select Amenities for this apartment

                                    </div>
                                    <hr>
                                    <div class="row">

                                        @foreach ($amenities as $amenity)
                                            <div class="col-md-4">
                                                <label>
                                                    <input type="checkbox" name="amenities[]"
                                                        value="{{ $amenity->id }}" {{-- {{ $amenity->isChecked ? 'checked' : '' }} --}}
                                                        {{ in_array($amenity->id, $apartment->amenities->pluck('id')->toArray()) ? 'checked' : '' }}>
                                                    {{ $amenity->name }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>


                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">3D Video
                                        Link
                                        (Youtube)
                                    </label>
                                    <input type="text" class="form-control" id="validationCustom01"
                                        name="property_video_url" placeholder="Enter video link from youtube"
                                        value="{{ $apartment->property_video_url }}">
                                    <div>
                                        @error('property_video_url')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">Google Map
                                        Iframe Link (src)</label>
                                    <input type="text" class="form-control" id="validationCustom01"
                                        name="google_map_iframe_url" value="{{ $apartment->google_map_iframe_url }}"
                                        placeholder="Enter Google map iframe Link (src)">
                                    <div>
                                        @error('google_map_iframe_url')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            {{-- start  multiple column --}}
                            <div class="col-md-12">
                                <div class="row">
                                    {{-- col-1 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Price / Month (USD)
                                            </label>
                                            <input type="number" class="form-control" id="validationCustom01"
                                                name="price" placeholder="Enter apartment price"
                                                value="{{ $apartment->price }}">
                                            <div>
                                                @error('price')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    {{-- col-2 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Price Range ( USD
                                                )</label>

                                            <select name="price_range" class="form-select">
                                                {{-- <option value="null">-- Select -- </option> --}}
                                                <option value="1000_2000"
                                                    {{ $apartment->price_range == '1000_2000' ? 'selected' : '' }}>
                                                    1000 - 2000 USD
                                                </option>
                                                <option value="2000_3000"
                                                    {{ $apartment->price_range == '2000_3000' ? 'selected' : '' }}>
                                                    2000 - 3000 USD
                                                </option>
                                                <option value="3000_4000"
                                                    {{ $apartment->price_range == '3000_4000' ? 'selected' : '' }}>
                                                    3000 - 4000 USD
                                                </option>
                                                <option value="4000_5000"
                                                    {{ $apartment->price_range == '4000_5000' ? 'selected' : '' }}>
                                                    4000 - 5000 USD
                                                </option>
                                                <option value="5000_6000"
                                                    {{ $apartment->price_range == '5000_6000' ? 'selected' : '' }}>
                                                    5000 - 6000 USD
                                                </option>
                                                <option value="6000_7000"
                                                    {{ $apartment->price_range == '6000_7000' ? 'selected' : '' }}>
                                                    6000 - 7000 USD
                                                </option>
                                                <option value="7000_8000"
                                                    {{ $apartment->price_range == '7000_8000' ? 'selected' : '' }}>
                                                    7000 - 8000 USD
                                                </option>
                                                <option value="8000_9000"
                                                    {{ $apartment->price_range == '8000_9000' ? 'selected' : '' }}>
                                                    8000 - 9000 USD
                                                </option>
                                                <option value="9000_10000"
                                                    {{ $apartment->price_range == '9000_10000' ? 'selected' : '' }}>
                                                    9000 - 10000 USD
                                                </option>


                                            </select>

                                            <div>
                                                @error('price_range')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- end multiple column --}}



                            {{-- start  multiple column --}}
                            <hr>
                            <div class="col-md-12">
                                <div class="row">
                                    {{-- col-1 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Property
                                                Status</label>
                                            <div class="form-check form-check-inline">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="property_status" type="radio"
                                                        id="property_status" {{-- {{ old('active') == '1' ? 'checked' : '' }} --}}
                                                        {{ $apartment->property_status == '1' ? 'checked' : '' }}
                                                        value="1">
                                                    <label class="form-check-label" for="property_status">Active</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="property_status" type="radio"
                                                        id="property_status" {{-- {{ old('unavailable') == '0' ? 'checked' : '' }} --}}
                                                        {{ $apartment->property_status == '0' ? 'checked' : '' }}
                                                        value="0">
                                                    <label class="form-check-label" for="property_status">In
                                                        Active</label>
                                                </div>
                                                {{-- validation --}}
                                                @error('property_status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror

                                            </div>
                                        </div>
                                    </div>
                                    {{-- col-2 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Booking
                                                Status</label>
                                            <div class="form-check form-check-inline">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="property_booked_status"
                                                        type="radio" id="property_booked_status" {{-- {{ old('available') == '1' ? 'checked' : '' }} --}}
                                                        {{ $apartment->property_booked_status == '1' ? 'checked' : '' }}
                                                        value="1">
                                                    <label class="form-check-label"
                                                        for="property_booked_status">Available</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="property_booked_status"
                                                        type="radio" id="property_booked_status" {{-- {{ old('booked') == '0' ? 'checked' : '' }} --}}
                                                        {{ $apartment->property_booked_status == '0' ? 'checked' : '' }}
                                                        value="0">
                                                    <label class="form-check-label"
                                                        for="property_booked_status">Booked</label>
                                                </div>
                                                {{-- validation --}}
                                                @error('property_booked_status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- end multiple column --}}


                            </div>
                            <hr>
                            {{-- end multiple column --}}


                            {{-- start  multiple column --}}
                            <div class="col-md-12">
                                <div class="row">
                                    {{-- col-1 --}}
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Balcony </label>
                                            <div class="form-check form-check-inline">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="balcony" type="radio"
                                                        id="balcony" {{-- {{ old('available') == '1' ? 'checked' : '' }} --}}
                                                        {{ $apartment->balcony == '1' ? 'checked' : '' }} value="1">
                                                    <label class="form-check-label" for="balcony">Available</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="balcony" type="radio"
                                                        id="balcony" {{-- {{ old('unavailable') == '0' ? 'checked' : '' }} --}}
                                                        {{ $apartment->balcony == '0' ? 'checked' : '' }} value="0">
                                                    <label class="form-check-label" for="balcony">Unavailable</label>
                                                </div>
                                                {{-- validation --}}
                                                @error('balcony')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror

                                            </div>
                                        </div>
                                    </div>
                                    {{-- col-2 --}}
                                    <div class="col-md-12">

                                        {{-- exiting featured photo --}}
                                        <a href="javascript::void(0)">
                                            <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                src="{{ asset($apartment->featured_photo) }}" alt="preview"
                                                style=" width:100% !important; object-fit:cover;">
                                        </a>

                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Featured Photo</label>
                                            <input type="file" class="form-control" name="featured_photo"
                                                id="⁠⁠featured_photo" placeholder="">
                                            <div>
                                                @error('⁠⁠featured_photo')
                                                    <small class="text-danger">
                                                        {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- end multiple column --}}


                            </div>
                            <hr>
                            {{-- end multiple column --}}


                            {{-- photo library upload --}}

                            <div class="card" style="margin-top:20px; padding-top:10px;">
                                {{-- @foreach (explode(',', $apartment->photo_library) as $image)
                                        <div>
                                            <img src="{{ asset($image) }}" width="100px" alt="Apartment Image">
                                            <form action="{{ route('apartment.delete_apartment_image', ['id' => $apartment->id]) }}" method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <input type="hidden" name="image" value="{{ $image }}">
                                                <button type="submit">Delete Image</button>
                                            </form>
                                        </div>
                                    @endforeach --}}

                                {{-- @foreach (explode(',', $apartment->photo_library) as $image)
                                    <div>
                                        <img src="{{ asset($image) }}" width="100px" alt="Apartment Image">
                                        <button class="delete-image-btn" data-image="{{ $image }}">Delete
                                            Image</button>
                                    </div>
                                @endforeach --}}

                                <div class="card-header bg-primary" style=" color:#ffffff;">
                                    Apartment photos collection
                                </div>
                                {{-- existing photo libarary --}}

                                {{-- pick multiple images from array --}}
                                <div class="row">
                                    @if (!empty($apartment->photo_library))
                                        <input type="hidden" name="apartment_id" value="{{ $apartment->id }}">
                                        <table>
                                            <tbody>
                                                @foreach (is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library) as $image)
                                                    <tr>
                                                        {{-- START COL --}}
                                                        <div class=" col-md-6 col-sm-6 col-xs-12">

                                                            <a href="{!! asset($image) !!}"> <img
                                                                    style=" height: 200px; 
                                                                background-color:#ffffff; 
                                                                object-fit:cover;
                                                                width:100% !important;
                                                                border:#ffffff 2px solid;
                                                                background-repeat: no-repeat;
                                                                object-position: center center;
                                                                background-size:cover;
                                                                padding:7px; 
                                                                margin:0px;"
                                                                    src="{{ asset($image) }}" alt="">

                                                            </a>
                                                            {{-- <a
                                                                href="{{ route('apartment.delete_apartment_image', $image) }}">Delete</a> --}}
                                                            <button class="btn btn-primary delete-image-btn" 
                                                                data-image="{{ $image }}">Delete
                                                                Image</button>
                                                        </div>

                                                        {{-- END COL --}}
                                                    </tr>
                                            </tbody>
                                    @endforeach
                                    </table>
                                @else
                                    <center><span>No Photos Available <span></center>
                                    @endif
                                </div>
                                {{-- end pick multiple images  from array --}}





                                {{-- end of existing photo library --}}
                                <div class="card-header bg-primary" style=" color:#ffffff; margin-top:15px;">
                                    Add more photos to the apartment collection

                                </div>

                                <div class="card-body">
                                    @error('photo_library')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                    <input type="file" multiple class="form-control" name="photo_library[]"
                                        id="upload_multiple">


                                </div>
                            </div>

                            {{-- end of photo library upload --}}

                            {{-- description --}}

                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">Description</label>

                                    <textarea class="form-control" name="description" id="exampleFormControlTextarea5"
                                        placeholder="Describe the apartment" rows="3">{{ $apartment->description }}</textarea>
                                    <div>
                                        @error('description')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                            </div>
                            <button class="btn btn-primary" type="submit">Update
                                Apartment</button>
                    </form>
                </div>
                <div class="col-md-2"></div>
            </div>

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection

@section('extra_scripts')
    {{-- multiple photo upload - environmental activities script --}}
    <script type="text/javascript">
        $(".imgAdd").click(function() {
            $(this).closest(".row").find('.imgAdd').before(
                '<div class="col-md-6 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" name="photo_library[]" class="uploadFile img" value="Upload Photo" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-timess del"><span style="color:#ffffff; ">Remove</span></i></div>'
            );
        });
        $(document).on("click", "i.del", function() {
            // 	to remove card
            $(this).parent().remove();
            // to clear image
            // $(this).parent().find('.imagePreview').css("background-image","url('')");
        });
        $(function() {
            $(document).on("change", ".uploadFile", function() {
                var uploadFile = $(this);
                var files = !!this.files ? this.files : [];
                if (!files.length || !window.FileReader)
                    return; // no file selected, or no FileReader support

                if (/^image/.test(files[0].type)) { // only image file
                    var reader = new FileReader(); // instance of the FileReader
                    reader.readAsDataURL(files[0]); // read the local file

                    reader.onloadend = function() { // set image data as background of div
                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                            "url(" + this.result + ")");
                    }
                }

            });
        });
    </script>


    {{-- end of  multiple photo upload - environmental activities script --}}

    {{-- add proximity --}}
    <script>
        function add_apartment_proximity_row(table_id, body_id) {
            var id = document.getElementById(table_id).rows.length + 1;
            if (body_id == 'apartment_proximities_data') {
                $('#apartment_proximities_data').append(`
                <tr>
                    <td>
                            <div class="row mb-2">
                                <div class="row">
                                    <div class="col-md-4" style="margin-top:10px;">
                                        <select name="place_category[]" id="place_category_${id}"
                                            class="form-select">
                                            <option value="null"> -- Select Category --
                                            </option>
                                            <option value="restaurant"> Restaurant
                                            </option>
                                            <option value="shopping_mall"> Shopping Mall
                                            </option>
                                            <option value="police_station"> Police Station
                                            </option>
                                            <option value="school"> School </option>
                                            <option value="hospital"> Hospital </option>
                                            <option value="sports_ground"> Sports Ground
                                            </option>
                                            <option value="christian_worship_place">
                                                Christian Worship Place </option>
                                            <option value="moslem_worship_place"> Moslem
                                                Worship Place</option>
                                        </select>
                                    </div>
                                    <div class="col-md-5" style="margin-top:10px;">
                                        <input type="text" class="form-control"
                                        name="place_name[]" id="place_name_${id}"
                                            placeholder="Place Name" >
                                    </div>

                                    <div class="col-md-2" style="margin-top:10px;">
                                        <input type="text" class="form-control"
                                        name="place_distance[]" id="place_distance_${id}"
                                            placeholder="Distance" >
                                    </div>
                                    

                                    <div class="col-md-4" style="margin-top:10px;">
                                        <input type="text" class="form-control"
                                        name="place_time[]" id="place_time_1"
                                            placeholder="Time Proximity" >
                                    </div>

                                    <div class="col-md-7" style="margin-top:10px;">
                                        <input type="text" class="form-control"
                                        name="place_address[]" id="place_address_${id}"
                                            placeholder="Address" >
                                    </div>
                                    
                                    
                                    <a> <button onclick="deleteProximityRow(this)" style="margin-top:10px;"
                                        class="btn btn-danger shadow btn-xs sharp"> <span
                                            class="fa fa-trash"> Remove proximity</button> </a>

                                </div>
                                
                            </div>

                            
                        </td>    
                                                                          
                   </tr>
                                                    
                   
                `);
            }

        }

        /* delete apartment proximity row */
        function deleteProximityRow(ele) {
            ele.parentNode.parentNode.remove();
        }
    </script>




    {{-- delete apartment image with ajax --}}
    <script>
        // in header section  in master of file //<meta name="csrf-token" content="{{ csrf_token() }}">
        $(document).ready(function() {
            $('.delete-image-btn').click(function(e) {
                e.preventDefault();

                // Get image URL from data attribute
                var image = $(this).data('image');

                // Confirm deletion
                // if (!confirm('Are you sure you want to delete this image?')) {
                //     return;
                // }


                Swal.fire({
                    title: 'Are you sure?',
                    text: 'Are you sure you want to delete this image?',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Code to execute if the user confirms
                        // Send AJAX request
                        // Send AJAX request
                        $.ajax({
                            url: '{{ route('apartment.delete_apartment_image', ['id' => $apartment->id]) }}',
                            method: 'DELETE',
                            data: {
                                _token: '{{ csrf_token() }}',
                                image: image
                            },
                            success: function(response) {
                                // success response
                                console.log(response);
                                // Optionally, remove the deleted image from the DOM
                                $(e.target).closest('div').remove();
                            },
                            error: function(xhr, status, error) {
                                // Handle error response (if needed)
                                console.error(xhr.responseText);
                            }
                        });
                    }
                });



            });
        });
    </script>
@endsection
