@extends('backend.layouts_backend.master')

@section('title')
    All Tour Bookings
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Tour Bookings <span
                                class="text-muted fw-normal ms-2">({{ $count_bookings }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        {{-- <div>
                            @can('booking-create')
                                <a href="/admin/bookings/create" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    Add booking</a>
                            @endcan
                        </div> --}}

                        {{-- <div>
                            @can('booking-restore')
                                <a href="{{ route('bookings.trashed') }}" class="btn bg-danger text-light"><i class="bx bx-plus me-1"></i>
                                    Trashed bookings</a>
                            @endcan
                        </div> --}}


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH bookings -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert restore item --}}
            @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            {{-- <th scope="col">#ID</th> --}}
                            <th scope="col"> #Id</th>
                            <th scope="col">First Name</th>
                            <th scope="col">Last Name</th>
                            <th scope="col">Tour </th>
                            <th scope="col">Arrival Date</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($bookings as $booking)
                            <tr>

                                {{-- <td>{{ $booking->id }}</td> --}}
                                <td>{{ $booking->id }}</td>

                                <td>
                                    @if (!empty($booking->first_name))
                                        {{ $booking->first_name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>


                                <td>
                                    @if (!empty($booking->last_name))
                                        {{ $booking->last_name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>


                                <td>
                                    @if (!empty($booking->tour->name))
                                        {{ $booking->tour->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($booking->arrival_date))
                                        {{ $booking->arrival_date }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>

                              
                              


                                <td colspan="6">
                                    <div class="row">

                                    
                                            <div class="col-md-4">
                                                <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                    data-bs-target="#viewbookingDetails{{ $booking->id }}"
                                                    data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                            </div>
                                        

                                        {{-- edit --}}
                                        {{-- @can('booking-edit') --}}
                                            {{-- <div class="col-md-4">
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editbooking{{ $booking->id }}"
                                                    data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button>

                                            </div> --}}
                                        {{-- @endcan --}}

                                        <!-- delete  -->

                                        {{-- @can('booking-delete') --}}
                                            <div class="col-md-4">
                                                <form action="{{ route('all_tour_bookings.destroy', $booking->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        {{-- @endcan --}}


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewbookingDetails{{ $booking->id }}" tabindex="-1"
                                aria-labelledby="viewbookingDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewbookingDetailsLabel"> Tour Booking
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            <p>Tour Category : 
                                                @if(!empty($booking->tour->name))
                                                {{ $booking->tour->name }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>
                                            <hr>

                                            <p> Arrival Date : 
                                                @if(!empty($booking->arrival_date))
                                                {{ $booking->arrival_date }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>
                                            <hr>


                                            <p> First Name :
                                                @if(!empty($booking->first_name))
                                                {{ $booking->first_name }}
                                                @else
                                                <span>N/A</span>
                                                @endif

                                            </p>
                                            <hr>
                                            <p> Last Name : 
                                                @if(!empty($booking->last_name))
                                                {{ $booking->last_name }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>
                                            <hr>
                                            <p> Email : 
                                                @if(!empty($booking->email))
                                                {{ $booking->email }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>
                                            <hr>

                                            <p> Nationality : 
                                                @if(!empty($booking->nationality))
                                                {{ $booking->nationality }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>
                                            <hr>

                                            <p> Current Address : 
                                                @if(!empty($booking->current_address))
                                                {{ $booking->current_address }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>
                                            <hr>

                                            <p> Phone Number : 
                                                @if(!empty($booking->phone_number))
                                                {{ $booking->phone_number }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>
                                            <hr>

                                            <p> Message : 
                                                @if(!empty($booking->message))
                                                {{ $booking->message }}
                                                @else
                                                <span>N/A</span>
                                                @endif
                                             </p>

                                          


                                         

                                            
                                           


                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            {{-- @can('booking-edit') --}}
                                                {{-- <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editbooking{{ $booking->id }}"
                                                    data-bs-whatever="@getbootstrap">Edit booking
                                                </button> --}}
                                            {{-- @endcan --}}

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->



                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No tour bookings available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->


    </div>
    <!-- container-fluid -->
    </div>
@endsection
