@extends('backend.layouts_backend.master')

@section('title')
    All Verification reports data
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">All Verification Reports data <span
                                class="text-muted fw-normal ms-2">({{ $count_verification_reports }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        {{-- @can('verification_report-create')
                        <div>
                            <a href="/verification_reports/create" class="btn bg-primary text-light"><i
                                    class="bx bx-plus me-1"></i> Add Verification report </a>
                        </div>
                        @endcan --}}


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH verification_reports -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            <th scope="col">#ID</th>
                            <th scope="col">Verified Date</th>
                            <th scope="col">Victim name</th>

                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($verification_reports as $verification_report)
                            <tr>

                                <td>{{ $verification_report->id }}</td>
                                <td>
                                    @if (!empty($verification_report->created_at))
                                        {{ $verification_report->created_at->format('M d, Y H:m') }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No Date</span>
                                        </button>
                                    @endif
                                </td>

                                <td>
                                    @if (!empty($verification_report->tenant_r->fullname))
                                        {{ $verification_report->tenant_r->fullname }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No Tenant</span>
                                        </button>
                                    @endif
                                </td>




                                <td colspan="6">
                                    <div class="row">

                                        @can('verification_report-list')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#viewverification_reportDetails{{ $verification_report->id }}"
                                                data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                        </div>
                                        @endcan

                                        @can('report-download')
                                        <div class="col-md-4">
                                            <a href="/verification_reports_print/{{ $verification_report->id }}" target="_blank"><button
                                                    type="button" class="btn btn-secondary">
                                                    <i class="bx bx-download label-icon "></i>
                                                </button>
                                            </a>
                                        </div>
                                        @endcan



                                        {{-- @can('verification_report-edit')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editverification_report{{ $verification_report->id }}"
                                                data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button>

                                        </div>
                                        @endcan --}}

                                        <!-- delete food menu -->
                                        {{-- @can('verification_report-delete')
                                        <div class="col-md-4">
                                            <form
                                                action="{{ route('verification_reports.update', $verification_report->id) }}"
                                                method="post">
                                                @csrf
                                                @method('DELETE')
                                                <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                            class="fa fa-trash"> </button> </a>

                                            </form>
                                        </div>
                                        @endcan --}}


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewverification_reportDetails{{ $verification_report->id }}"
                                tabindex="-1" aria-labelledby="viewverification_reportDetailsLabel" style="display: none;"
                                aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewverification_reportDetailsLabel">
                                                Verification report details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">


                                            <b>
                                                <p style="font-size: 20px;"> Verifid on:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->created_at))
                                                    {{ $verification_report->created_at }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No date</button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Victim name (Tenant):</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->tenant_r->fullname))
                                                    {{ $verification_report->tenant_r->fullname }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No Tenant</span>
                                                    </button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Work he/she/they do?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->work_they_do))
                                                    {{ $verification_report->work_they_do }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No work</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Location of the incidence?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->location_of_incidence))
                                                    {{ $verification_report->location_of_incidence }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No location</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> What got the victim into the challenges
                                                    raised?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->reason_for_victim_challenge))
                                                    {{ $verification_report->reason_for_victim_challenge }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No reason</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;">Who is the perpetrator? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->perpetrator_name))
                                                    {{ $verification_report->perpetrator_name }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No proprietor</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> What threats were experienced? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->threats_experienced))
                                                    {{ $verification_report->threats_experienced }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No threats</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Are the threats as a result of their human
                                                    rights work, sexuaissues or other issues? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->reason_for_threats))
                                                    {{ $verification_report->reason_for_threats }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No reason</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Which organization is the victim affiliated
                                                    to? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->organization_affiliated_to))
                                                    {{ $verification_report->organization_affiliated_to }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No organization</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Is the organization functional? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->is_organization_functional))
                                                    {{ $verification_report->is_organization_functional }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No organization</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Was the threat reported to police?
                                                    :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->police_report_status))
                                                    {{ $verification_report->police_report_status }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No police status</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> If yes share the reference number:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->police_report_reference_number))
                                                    {{ $verification_report->police_report_reference_number }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No report</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> if not why wasn’t it reported:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->reason_for_not_reporting_to_police))
                                                    {{ $verification_report->reason_for_not_reporting_to_police }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No reason</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Needs of the victim and what support
                                                    he/she/they are seeking for?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->support_needed_by_victim))
                                                    {{ $verification_report->support_needed_by_victim }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No support</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Has the victim sought assistance from any
                                                    other organization! :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->outside_assistance_sought))
                                                    {{ $verification_report->outside_assistance_sought }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No assistance</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Does the victim have a security plan? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->security_plan))
                                                    {{ $verification_report->security_plan }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No security plan</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Details of the threat.:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->details_of_threat))
                                                    {{ $verification_report->details_of_threat }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No threat</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> When did it happen? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->date_of_threat))
                                                    {{ $verification_report->date_of_threat }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No date</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Where did it happen? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->place_of_threat))
                                                    {{ $verification_report->place_of_threat }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No place</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Recommendation:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->recommendation))
                                                    {{ $verification_report->recommendation }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No recommendation</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Does the victim have a sustainability plan?
                                                    :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->sustainability_plan))
                                                    {{ $verification_report->sustainability_plan }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No sustainable
                                                            plan</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Was any property taken?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->property_taken_status))
                                                    {{ $verification_report->property_taken_status }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No property status</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> Mention referees to be contacted for
                                                    verification.:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->referees_to_contact))
                                                    {{ $verification_report->referees_to_contact }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No
                                                            referees_to_contact</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> In case of relocation, where would they
                                                    prefer?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->prefered_area_of_relocation))
                                                    {{ $verification_report->prefered_area_of_relocation }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No area chosen</button>
                                                @endif
                                            </p>

                                            <hr><b>
                                                <p style="font-size: 20px;"> What were the total costs incurred during the
                                                    verification process? :</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($verification_report->total_verification_costs))
                                                    {{ $verification_report->total_verification_costs }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No
                                                            total_verification_costs</button>
                                                @endif
                                            </p>







                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('verification_report-edit')
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editverification_report{{ $verification_report->id }}"
                                                data-bs-whatever="@getbootstrap">Edit verification report
                                            </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE VERIFICATION REPORT --}}
                            <div class="modal fade" id="editverification_report{{ $verification_report->id }}"
                                tabindex="-1" aria-labelledby="editverification_reportLabel" style="display: none;"
                                aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewverification_reportDetailsLabel">Edit
                                                Verification Report </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE post CATEGORIES -->

                                            <form
                                                action="{{ route('verification_reports.update', $verification_report->id) }}"
                                                method="post" enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')


                                                {{-- START OF VERIFICATION REPORT FORM --}}

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Verified
                                                                by</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="paid_by"
                                                                value="{{ $verified_by_user }}"
                                                                style="pointer-events: none">
                                                            <div>
                                                                @error('paid_by')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Name of the
                                                                victim?
                                                                (Tenant)
                                                            </label>

                                                            <select name="tenant_id" class="form-select">
                                                                @foreach ($tenants as $tenant)
                                                                    <option value="{{ $tenant->id }} " @selected($tenant->id == $verification_report->tenant_id)>
                                                                        {{ $tenant->fullname }}</option>
                                                                @endforeach
                                                            </select>
                                                            <div>
                                                                @error('tenant_id')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Work
                                                                he/she/they do?</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="work_they_do"
                                                                placeholder="Enter work category"
                                                                value="{{ $verification_report->work_they_do }}">
                                                            <div>
                                                                @error('work_they_do')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Location of
                                                                the incidence?
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="location_of_incidence"
                                                                placeholder="Enter location ofincidence"
                                                                value="{{ $verification_report->location_of_incidence }}">
                                                            <div>
                                                                @error('location_of_incidence')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="validationCustom01">What got the
                                                            victim into the
                                                            challenges raised?
                                                        </label>

                                                        <textarea class="form-control" name="reason_for_victim_challenge" id="exampleFormControlTextarea5"
                                                            placeholder="Describe What got the victim into the challenges raised?
                                            "
                                                            rows="3">{{  $verification_report->reason_for_victim_challenge }}</textarea>
                                                        <div>
                                                            @error('reason_for_victim_challenge')
                                                                <small class="text-danger"> {{ $message }}</small>
                                                            @enderror
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Who is the
                                                                perpetrator?
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="perpetrator_name"
                                                                placeholder="Who is the perpetrator?"
                                                                value="{{ $verification_report->perpetrator_name }}">
                                                            <div>
                                                                @error('perpetrator_name')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">What
                                                                threats were
                                                                experienced?

                                                            </label>

                                                            <textarea class="form-control" name="threats_experienced" id="exampleFormControlTextarea5"
                                                                placeholder="Describe What threats were experienced?
                                                "
                                                                rows="3">{{ $verification_report->threats_experienced }}</textarea>
                                                            <div>
                                                                @error('threats_experienced')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Are the threats as a result of their human rights work,
                                                                sexuaissues or other
                                                                issues?


                                                            </label>

                                                            <textarea class="form-control" name="reason_for_threats" id="exampleFormControlTextarea5"
                                                                placeholder="Are the threats as a result of their human rights work, sexuaissues or other issues?
                                            "
                                                                rows="3">{{ $verification_report->threats_experienced }}</textarea>
                                                            <div>
                                                                @error('reason_for_threats')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Which organization is the victim affiliated to?
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="organization_affiliated_to"
                                                                placeholder="Which organization is the victim affiliated to?"
                                                                value="{{ $verification_report->organization_affiliated_to }}">
                                                            <div>
                                                                @error('organization_affiliated_to')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">

                                                                Is the organization functional?

                                                            </label>
                                                            <select name="is_organization_functional" class="form-select">
                                                                <option value="yes" @selected($verification_report->is_organization_functional == 'yes')>Yes</option>
                                                                <option value="no" @selected($verification_report->is_organization_functional == 'no')>No</option>
                                                            </select>
                                                            <div>
                                                                @error('is_organization_functional')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                {{-- was case reported to police [yes/no]  --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">

                                                                Was the threat reported to police?

                                                            </label>
                                                            <select name="police_report_status" class="form-select">
                                                                <option value="yes" @selected($verification_report->police_report_status == 'yes')>Yes</option>
                                                                <option value="no"  @selected($verification_report->police_report_status == 'no')>No</option>
                                                            </select>
                                                            <div>
                                                                @error('police_report_status')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                {{-- chose if case was reported --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                If yes share the reference number
                                                            </label>

                                                            <textarea class="form-control" name="police_report_reference_number" id="exampleFormControlTextarea5"
                                                                placeholder="If yes share the reference number" rows="3">
                                                             {{ $verification_report->police_report_reference_number }}</textarea>
                                                            <div>
                                                                @error('police_report_reference_number')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                {{-- chose if case was not reported --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                if not why wasn’t it reported.
                                                            </label>

                                                            <textarea class="form-control" name="reason_for_not_reporting_to_police" id="exampleFormControlTextarea5"
                                                                placeholder="if not why wasn’t it reported. " rows="3">
                                                                {{ $verification_report->reason_for_not_reporting_to_police }}
                                                            </textarea>
                                                            <div>
                                                                @error('reason_for_not_reporting_to_police')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                {{-- need of the victim --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Needs of the victim and what support he/she/they are seeking
                                                                for?
                                                            </label>
                                                            <select name="support_needed_by_victim" class="form-select">
                                                                <option value="relocation" @selected($verification_report->support_needed_by_victim == 'relocation' )>Relocation</option>
                                                                <option value="house_hold" @selected($verification_report->support_needed_by_victim == 'house_hold' )>House Hold</option>
                                                                <option value="food"       @selected($verification_report->support_needed_by_victim == 'food' ) >Food</option>
                                                                <option value="transport"  @selected($verification_report->support_needed_by_victim == 'transport' )>Transport</option>
                                                                <option value="office_requirements" @selected($verification_report->support_needed_by_victim == 'office_requirements' )>Office requirements ie
                                                                    PC</option>

                                                            </select>
                                                            <div>
                                                                @error('support_needed_by_victim')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- outside assistance --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Has the victim sought assistance from any other
                                                                organization!
                                                            </label>
                                                            <select name="outside_assistance_sought" class="form-select">
                                                                <option value="yes"     >Yes</option>
                                                                <option value="no"  @selected($verification_report->outside_assistance_sought == 'no') >No</option>
                                                            </select>
                                                            <div>
                                                                @error('outside_assistance_sought')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- security plan --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Does the victim have a security plan?
                                                            </label>
                                                            <select name="security_plan" class="form-select">
                                                                <option value="yes" @selected($verification_report->security_plan == 'yes')>Yes</option>
                                                                <option value="no" @selected($verification_report->security_plan == 'no')>No</option>
                                                            </select>
                                                            <div>
                                                                @error('security_plan')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- details of threat --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Details of the threat
                                                            </label>
                                                            <textarea class="form-control" name="details_of_threat" id="exampleFormControlTextarea5"
                                                                placeholder="Details of the threat" rows="3">
                                                                {{ $verification_report->details_of_threat }}
                                                            </textarea>
                                                            <div>
                                                                @error('details_of_threat')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">When did
                                                                the threat
                                                            </label>
                                                            <input type="date" class="form-control"
                                                                id="validationCustom01" name="date_of_threat"
                                                                placeholder="Date of threat"
                                                                value="{{ $verification_report->date_of_threat }}">
                                                            <div>
                                                                @error('date_of_threat')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Where did
                                                                the threat happen?

                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="place_of_threat"
                                                                placeholder="Where did the threat happen?"
                                                                value="{{ $verification_report->place_of_threat }}">
                                                            <div>
                                                                @error('place_of_threat')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Recomendation
                                                            </label>

                                                            <textarea class="form-control" name="recommendation" id="exampleFormControlTextarea5" placeholder="recommendation"
                                                                rows="3">{{ $verification_report->recommendation }}</textarea>
                                                            <div>
                                                                @error('recommendation')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Does the victim have a sustainability plan?
                                                            </label>
                                                            <select name="sustainability_plan" class="form-select">
                                                                <option value="yes" @selected($verification_report->sustainability_plan == 'yes')>Yes</option>
                                                                <option value="no" @selected($verification_report->sustainability_plan == 'no')>No</option>
                                                            </select>
                                                            <div>
                                                                @error('sustainability_plan')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Was any property taken?
                                                            </label>
                                                            <select name="property_taken_status" class="form-select">
                                                                <option value="yes" @selected($verification_report->property_taken_status == 'yes')>Yes</option>
                                                                <option value="no"  @selected($verification_report->property_taken_status == 'no')>No</option>
                                                            </select>
                                                            <div>
                                                                @error('property_taken_status')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- referees --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Mention referees to be contacted for verification
                                                            </label>

                                                            <textarea class="form-control" name="referees_to_contact" id="exampleFormControlTextarea5"
                                                                placeholder="referees_to_contact" rows="3">
                                                                {{ $verification_report->referees_to_contact }}
                                                            </textarea>
                                                            <div>
                                                                @error('referees_to_contact')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                {{-- relocation --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                In case of relocation, where would they prefer?
                                                            </label>

                                                            <textarea class="form-control" name="prefered_area_of_relocation" id="exampleFormControlTextarea5"
                                                                placeholder=" In case of relocation, where would they prefer?" rows="3">
                                                                {{ $verification_report->prefered_area_of_relocation }}
                                                            </textarea>
                                                            <div>
                                                                @error('prefered_area_of_relocation')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                {{-- costs involved --}}
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                What were the total costs incurred during the verification
                                                                process? (item, unit cost , frequency, amount)

                                                            </label>

                                                            <textarea class="form-control" name="total_verification_costs" id="exampleFormControlTextarea5"
                                                                placeholder="What were the total costs incurred during the verification process?" rows="3">
                                                                {{ $verification_report->total_verification_costs }}
                                                            </textarea>
                                                            <div>
                                                                @error('total_verification_costs')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                {{-- END VERIFICATION REPORT FORM --}}

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <button class="btn btn-primary" type="submit">Update
                                                        verification report</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE post verification_report --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No verification_reports available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
