@extends('backend.layouts_backend.master')

@section('title')
    Trashed Tours
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Trashed Tours <span
                                class="text-muted fw-normal ms-2">({{ $count_trashed_tours }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('tour-list')
                                <a href="/admin/tours" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    All Tours</a>
                            @endcan
                        </div>




                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH tours -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert restore item --}}
            @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            {{-- <th scope="col">#ID</th> --}}
                            <th scope="col"> ID</th>
                            <th scope="col">Tour Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Units Available</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @php
                            $counter = 1;
                        @endphp
                        @forelse ($trashed_tours as $key => $tour)
                            <tr>

                               
                                <td>{{ $counter + $key }}</td>

                                <td>
                                    @if (!empty($tour->name))
                                        {{ $tour->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($tour->tour_category->name))
                                        {{ $tour->tour_category->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($tour->slots_available))
                                        {{ $tour->slots_available }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>

                                <td>
                                    @if (!empty($tour->user->name))
                                        {{ $tour->user->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>




                                <td colspan="6">
                                    <div class="row">

                                        <!-- delete  -->
                                        {{-- @can('tour-restore') --}}
                                            <div class="col-md-4">
                                                <form action="{{ route('tours.restore', $tour->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('POST')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-arrow-left"> </button> </a>
                                                </form>
                                            </div>
                                        {{-- @endcan --}}


                                    </div>
                                </td>
                            </tr>

                        

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No tours available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
