{{-- @extends('layouts.app') --}}
@extends('backend.layouts_backend.master')

@section('title')
    Edit User
@endsection
@section('content')


    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Add User</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/users/create">Add User</a> > <a
                                        href="/users">View Users</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->


            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

                <div class="row">

            <div class="col-md-3"></div>
            <div class="col-md-6">

                {!! Form::model($user, ['method' => 'PATCH', 'route' => ['users.update', $user->id]]) !!}
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Name:</strong>
                            {!! Form::text('name', null, ['placeholder' => 'Name', 'class' => 'form-control']) !!}
                        </div>
                        <br>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Email:</strong>
                            {!! Form::text('email', null, ['placeholder' => 'Email', 'class' => 'form-control']) !!}
                        </div><br>
                    </div>


                        {{-- user category --}}
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="form-group">
                                <strong>User Category:</strong>
                                <select name="tour_category_id" class="form-select" id="show_customer_fields">
                                    <option value="admin">Administrator </option>
                                    <option value="customer" >Customer </option>
                                    
                                </select>


                                <br>
                            </div>
                        </div>

                        {{-- additional customer fields --}}
                        <div class="col-xs-12 col-sm-12 col-md-12" id="customer_fields" style="display: none;">
                            <div class="form-group">
                                <label class="form-label" for="validationCustom01">Religion</label>
                                <select name="religion" class="form-select" id="show_customer_fields">
                                    <option value="christian">Christian </option>
                                    <option value="moslem" >Moslem </option>
                                    
                                </select><br>
                            </div>
                        </div><br>

                        {{-- end of additional customer fields --}}


                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Password:</strong>
                            {!! Form::password('password', ['placeholder' => 'Password', 'class' => 'form-control']) !!}
                        </div><br>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Confirm Password:</strong>
                            {!! Form::password('confirm-password', ['placeholder' => 'Confirm Password', 'class' => 'form-control']) !!}
                        </div><br>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Role:</strong>
                            {!! Form::select('roles[]', $roles, $userRole, ['class' => 'form-control', 'multiple']) !!}
                        </div><br>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <button type="submit" class="btn btn-primary">Update User</button>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <div class="col-md-3"></div>
                </div>

        </div>
    </div>
@endsection

@section('extra_scripts')
    <script>
    $(document).ready(function() {
        // Listen for change event on the select element
        $('#show_customer_fields').change(function() {
            // Check the selected value
            if ($(this).val() === 'customer') {
                // If Option 2 is selected, display the input field
                $('#customer_fields').show();
            } else {
                // If any other option is selected, hide the input field
                $('#customer_fields').hide();
            }
        });
    });


    </script>
@endsection
