
   
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> Tour Booking Notification</title>
    <style>
        /* Reset some default styles */
        body,
        h1,
        h2,
        p {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f4;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            color: #333333;
            margin-bottom: 20px;
        }

        p {
            color: #555555;
            margin-bottom: 20px;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 5px;
        }
    </style>
</head>

<body>
    <div class="container">
    <h2>Hi,
        @if (!empty($customer_tour_booking_data['first_name']))
            {{ $customer_tour_booking_data['first_name'] }}
        @else
            <span> N/A </span>
        @endif

        @if (!empty($customer_tour_booking_data['last_name']))
            {{ $customer_tour_booking_data['last_name'] }}
        @else
            <span> N/A </span>
        @endif
    </h2>
    <hr> <br>

    <p><b>Your tour booking has been recieved with these details </b></p>

    <p>Tour :
        {{ $customer_tour_booking_data['tour']['name'] }}
    </p>
    <p>First Name :
        @if (!empty($customer_tour_booking_data['first_name']))
            {{ $customer_tour_booking_data['first_name'] }}
        @else
            <span> N/A </span>
        @endif


    </p>
    <p>Last Name :

        @if (!empty($customer_tour_booking_data['last_name']))
            {{ $customer_tour_booking_data['last_name'] }}
        @else
            <span> N/A </span>
        @endif

    </p>

    <p>Email :
        @if (!empty($customer_tour_booking_data['email']))
            {{ $customer_tour_booking_data['email'] }}
        @else
            <span> N/A </span>
        @endif
    </p>


    <p>Nationality :

        @if (!empty($customer_tour_booking_data['nationality']))
            {{ $customer_tour_booking_data['nationality'] }}
        @else
            <span> N/A </span>
        @endif
    </p>

    <p>Phone Number :

        @if (!empty($customer_tour_booking_data['phone_number']))
            {{ $customer_tour_booking_data['phone_number'] }}
        @else
            <span> N/A </span>
        @endif

    </p>
    <p>Arrival Date :

        @if (!empty($customer_tour_booking_data['arrival_date']))
            {{ $customer_tour_booking_data['arrival_date'] }}
        @else
            <span> N/A </span>
        @endif

    </p>

    <p style="max-width: 100%; word-wrap: break-word;"> Message <br>

        @if (!empty($customer_tour_booking_data['message']))
            {{ $customer_tour_booking_data['message'] }}
        @else
            <span> N/A </span>
        @endif
    </p>

    <hr>
    {{-- <a href="#" class="button">Click Me</a> --}}
    <p>Thank you for making the booking.</p>
    <p>The team at relocate will reach out to you soon.</p>
    <p>Best regards</p>

  
</div>
</body>

</html>
