<?php $__env->startSection('title'); ?>
    Apartment Details - Relocate Uganda
<?php $__env->stopSection(); ?>


<?php $__env->startSection('extra_styles'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <section class="main-banner-wrap1 main-banner-wrap5"
        data-bg-image="<?php echo e(asset('assets/frontend_assets/img/slider/slider4.jpg')); ?>">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="main-banner-box1 main-banner-box5">
                        <h1 class="item-title wow fadeInUp" data-wow-delay=".4s">Apartments Details</h1>
                        <p style="margin-top:-20px;" class="item-para wow fadeInUp text-center text-white "
                            data-wow-delay=".4s">We have the properties <span class="banner-p"> you have been looking for
                                !</span>
                    </div>



                </div>
            </div>
        </div>
    </section>





    <!--=====================================-->
    <!--=   Single Listing     Start        =-->
    <!--=====================================-->

    <section class="single-listing-wrap1">
        <div class="container">
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>


            <?php if(session('messagenoapartments')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagenoapartments')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>


            <div class="single-property">
                <div class="content-wrapper">
                    <div class="property-heading">

                        <div class="row">
                            <div class="col-lg-6 col-md-12">
                                <div class="single-list-cate">
                                    <?php if($apartment->units_available > 0): ?>
                                        <div class="item-categoery">
                                            PROPERTY AVAILABLE FOR BOOKING
                                        </div>
                                    <?php elseif($apartment->units_available <= 0): ?>
                                        <button type="submit" class="btn btn-danger" disabled>
                                            APARTMENT UNITS ALL ALREADY BOOKED

                                        </button>
                                        <br>
                                        <span> You cannot book it.</span>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12">

                                <div class="single-list-price" style="font-size: 23px; ">
                                    <?php if(!empty($apartment->price)): ?>
                                        PRICE : USD <?php echo e($apartment->price); ?>

                                    <?php else: ?>
                                        <span> PRICE : N/A </span>
                                    <?php endif; ?>

                                    |
                                    <?php if(!empty($apartment->units_available >= 0)): ?>
                                        UNITS LEFT : <?php echo e($apartment->units_available); ?>

                                    <?php elseif($apartment->units_available == 0): ?>
                                        <span>0</span>
                                    <?php else: ?>
                                        <span> N/A </span>
                                    <?php endif; ?>

                                </div>


                            </div>
                        </div>

                        <div class="row align-items-center">
                            <div class="col-lg-8 col-md-12">
                                <div class="single-verified-area">

                                    <div class="item-title">
                                        <h3>
                                            <?php if(!empty($apartment->name)): ?>
                                                <?php echo e($apartment->name); ?>

                                            <?php else: ?>
                                                <span>N/A </span>
                                            <?php endif; ?>
                                        </h3>
                                    </div>
                                </div>
                                <div class="single-item-address">
                                    <ul>
                                        <li>
                                            <i class="fas fa-map-marker-alt"></i>
                                            <?php if(!empty($apartment->address)): ?>
                                                Address : <?php echo e($apartment->address); ?>

                                            <?php else: ?>
                                                <span>Address : N/A </span>
                                            <?php endif; ?>
                                        </li>

                                        <li>
                                            <i class="fas fa-map-marker-alt"></i>
                                            <?php if(!empty($apartment->city)): ?>
                                                City : <?php echo e($apartment->city); ?>

                                            <?php else: ?>
                                                <span>City : N/A </span>
                                            <?php endif; ?>
                                        </li>

                                        <li>
                                            <i class="fas fa-calendar"></i>
                                            <?php if(!empty($apartment->created_at)): ?>
                                                Added on : <?php echo e($apartment->created_at); ?>

                                            <?php else: ?>
                                                <span>Added on : N/A </span>
                                            <?php endif; ?>
                                        </li>

                                        <li>
                                            <i class="fas fa-clock"></i>
                                            <?php if(!empty($apartment->apartment_category->category_name)): ?>
                                                Category : <?php echo e($apartment->apartment_category->category_name); ?>

                                            <?php else: ?>
                                                <span>Category : N/A</span>
                                            <?php endif; ?>
                                        </li>


                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="row">
                        
                        <div class="col-lg-8">

                            
                            
                            <?php if(!empty($apartment->property_video_url)): ?>
                                <div class="overview-area video-box1">
                                    <h3 class="widget-subtitle">Video tour</h3>
                                    <hr>

                                    <div class="ratio ratio-16x9">
                                        <iframe width="130" height="175" src=" <?php echo e($apartment->property_video_url); ?>"
                                            allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen"
                                            msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen"
                                            webkitallowfullscreen="webkitallowfullscreen">
                                        </iframe>

                                    </div>

                                </div>
                            <?php else: ?>
                                <center><span>No Property Video Added </span></center>
                            <?php endif; ?>
                            <hr>
                            

                            <div class="single-listing-box1">
                                <div class="overview-area listing-area">
                                    <h3 class="item-title">About This Apartment</h3>
                                    <p>
                                        <?php if(!empty($apartment->description)): ?>
                                            <?php echo e($apartment->description); ?>

                                        <?php else: ?>
                                            <span>N/A </span>
                                        <?php endif; ?>
                                    </p>

                                </div> <br>



                                
                                

                                

                                
                                <div class="overview-area">
                                    <h3 class="item-title">Overview of the apartment</h3>
                                    <div class="gallery-icon-box">
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Unique ID</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->unique_id)): ?>
                                                        <?php echo e($apartment->unique_id); ?>

                                                    <?php else: ?>
                                                        <span>N/A </span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Category :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->apartment_category->category_name)): ?>
                                                        <?php echo e($apartment->apartment_category->category_name); ?>

                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Beds :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->beds)): ?>
                                                        <?php echo e($apartment->beds); ?>

                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Size :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->size)): ?>
                                                        <?php echo e($apartment->size); ?> Sqft
                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="gallery-icon-box">
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Rooms :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->rooms)): ?>
                                                        <?php echo e($apartment->rooms); ?>

                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Bathrooms :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->bathrooms)): ?>
                                                        <?php echo e($apartment->bathrooms); ?>

                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Balcony :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->balcony)): ?>
                                                        <?php if($apartment->balcony == '1'): ?>
                                                            Yes
                                                        <?php endif; ?>

                                                        <?php if($apartment->balcony == '0'): ?>
                                                            No
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <span> N/A </span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Booking :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($apartment->property_booked_status)): ?>
                                                        <?php if($apartment->property_booked_status == '1'): ?>
                                                            Available
                                                        <?php endif; ?>

                                                        <?php if($apartment->property_booked_status == '0'): ?>
                                                            Booked
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <span> N/A </span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>



                                
                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Amenities</h3>
                                    <div class="row">
                                        <?php $__empty_1 = true; $__currentLoopData = $apartment->amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="col-lg-4">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        <?php echo e($amenity->name); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                            <span style="color:red;">No Amenities Available </span>
                                        <?php endif; ?>

                                    </div>
                                </div>
                                <br>


                                

                                
                                <div class="overview-area floor-plan-box">
                                    <h3 class="item-title">Proximities to nearby areas</h3>
                                    <?php
                                        // pick proximities in each category
                                        $apartment_proximities_data = !empty($apartment->apartment_proximities)
                                            ? json_decode($apartment->apartment_proximities, true)
                                            : [];
                                        // pick data
                                        $restaurants_nearyby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'restaurant',
                                        );
                                        $shopping_malls_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'shopping_mall',
                                        );
                                        $police_station_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'police_station',
                                        );
                                        $schools_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'school',
                                        );
                                        $hospitals_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'hospital',
                                        );
                                        $sports_grounds_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'sports_ground',
                                        );
                                        $christian_worship_places_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'christian_worship_place',
                                        );
                                        $moslem_worship_places_nearby = collect($apartment_proximities_data)->where(
                                            'place_category',
                                            'moslem_worship_place',
                                        );

                                    ?>


                                    
                                    <?php if(count($restaurants_nearyby) > 0): ?>
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#headingtwo" aria-expanded="true" role="button">
                                                        <span>Restaurants Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="headingtwo" class="collapse" data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    <?php $__currentLoopData = $restaurants_nearyby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $restaurant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li>
                                                                            <i class="fas fa-check-circle"></i>
                                                                            <b> Name </b> : <?php echo e($restaurant['place_name']); ?> &nbsp;
                                                                            | &nbsp;<b>Distance</b> : |
                                                                            <?php echo e($restaurant['place_distance']); ?>&nbsp;
                                                                            <b> Time</b> &nbsp;
                                                                            : <?php echo e($restaurant['place_time']); ?>

                                                                            | &nbsp; <b>Address</b> : <?php echo e($restaurant['place_address']); ?>

                                                                        </li> <hr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    <?php else: ?>
                                        
                                    <?php endif; ?>
                                    


                                    
                                    <?php if(count($shopping_malls_nearby) > 0): ?>
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_restaurant" aria-expanded="true"
                                                        role="button">
                                                        <span>Shopping Malls Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_restaurant" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    <div class="card-body">

                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    <?php $__currentLoopData = $shopping_malls_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shopping_mall): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name</b> : <?php echo e($shopping_mall['place_name']); ?>

                                                                            &nbsp;| Distance :&nbsp; | &nbsp;
                                                                            <?php echo e($shopping_mall['place_distance']); ?>

                                                                            <b>Time</b> &nbsp;
                                                                            : &nbsp;<?php echo e($shopping_mall['place_time']); ?>

                                                                            | &nbsp; <b>Address</b> :&nbsp;
                                                                            <?php echo e($shopping_mall['place_address']); ?>

                                                                        </li><hr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    <?php else: ?>
                                        
                                    <?php endif; ?>
                                    

                                    
                                    <?php if(count($police_station_nearby) > 0): ?>
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_police_stations" aria-expanded="true"
                                                        role="button">
                                                        <span>Police Stations Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_police_stations" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    <?php $__currentLoopData = $police_station_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $police_station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name</b> : <?php echo e($police_station['place_name']); ?>

                                                                            | &nbsp; <b>Distance</b> : |&nbsp;
                                                                            <?php echo e($police_station['place_distance']); ?> &nbsp;
                                                                            <b>Time</b> &nbsp;
                                                                            : <?php echo e($police_station['place_time']); ?>&nbsp;
                                                                            | &nbsp; <b>Address</b> :&nbsp;
                                                                            <?php echo e($police_station['place_address']); ?>

                                                                        </li><hr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    <?php else: ?>
                                        
                                    <?php endif; ?>
                                    


                                    
                                    <?php if(count($schools_nearby) > 0): ?>
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_schools" aria-expanded="true"
                                                        role="button">
                                                        <span>Schools Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_schools" class="collapse" data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    <?php $__currentLoopData = $schools_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $schools): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name :</b>  <?php echo e($schools['place_name']); ?> &nbsp;
                                                                            | <b>Distance :</b> | <?php echo e($schools['place_distance']); ?>&nbsp;
                                                                            <b>Time</b>
                                                                            : <?php echo e($schools['place_time']); ?>

                                                                            | <b>Address :</b> <?php echo e($schools['place_address']); ?>&nbsp;
                                                                        </li><hr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    <?php else: ?>
                                        
                                    <?php endif; ?>
                                    


                                    
                                    <?php if(count($hospitals_nearby) > 0): ?>
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_hospital" aria-expanded="true"
                                                        role="button">
                                                        <span>Hospitals Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_hospital" class="collapse" data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    <?php $__currentLoopData = $hospitals_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $hospital): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Name : </b> <?php echo e($hospital['place_name']); ?> &nbsp;
                                                                            | <b>Distance : </b> |&nbsp;
                                                                            <?php echo e($hospital['place_distance']); ?>

                                                                            <b>Time </b>
                                                                            : &nbsp;<?php echo e($hospital['place_time']); ?>

                                                                            | <b>Address : </b> &nbsp; <?php echo e($hospital['place_address']); ?>

                                                                        </li><hr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    <?php else: ?>
                                        
                                    <?php endif; ?>
                                    

                                    
                                    <?php if(count($sports_grounds_nearby) > 0): ?>
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#heading_sports_ground" aria-expanded="true"
                                                        role="button">
                                                        <span>Sports Grounds Nearby </span>

                                                    </div>
                                                </div>


                                                <div id="heading_sports_ground" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    <div class="card-body">


                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    <?php $__currentLoopData = $sports_grounds_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sports_ground): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b> &nbsp; Name : </b> <?php echo e($sports_ground['place_name']); ?>

                                                                            | <b> &nbsp;Distance : </b> |
                                                                            <?php echo e($sports_ground['place_distance']); ?>

                                                                            <b> &nbsp;Time </b>
                                                                            : <?php echo e($sports_ground['place_time']); ?>

                                                                            | <b> &nbsp;Address : </b>
                                                                            <?php echo e($sports_ground['place_address']); ?>

                                                                        </li><hr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>


                                                </div>
                                            </div>



                                        </div>
                                    <?php else: ?>
                                        
                                    <?php endif; ?>
                                    



                                    
                                    <?php if(auth()->user()->religion === 'christian'): ?>
                                        <?php if(count($christian_worship_places_nearby) > 0): ?>
                                            <div id="accordion" class="accordion">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                            data-bs-target="#heading_christian_worship_place"
                                                            aria-expanded="true" role="button">
                                                            <span>Christian Worship Places Nearby </span>

                                                        </div>
                                                    </div>


                                                    <div id="heading_christian_worship_place" class="collapse"
                                                        data-bs-parent="#accordion">
                                                        <div class="card-body">


                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <ul class="ameniting-list">
                                                                        <?php $__currentLoopData = $christian_worship_places_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $christian_worship_place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li><i class="fas fa-check-circle"></i>
                                                                                <b>Name : </b>
                                                                                <?php echo e($christian_worship_place['place_name']); ?>

                                                                                | &nbsp; <b>Distance : </b> |
                                                                                <?php echo e($christian_worship_place['place_distance']); ?>

                                                                                &nbsp; <b>Time</b>
                                                                                :
                                                                                <?php echo e($christian_worship_place['place_time']); ?>

                                                                                | &nbsp; <b>Address :</b>
                                                                                <?php echo e($christian_worship_place['place_address']); ?>

                                                                            </li><hr>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                </div>


                                                            </div>


                                                        </div>


                                                    </div>
                                                </div>



                                            </div>
                                        <?php else: ?>
                                            
                                        <?php endif; ?>
                                        
                                    <?php endif; ?>


                                    
                                    <?php if(auth()->user()->religion === 'moslem'): ?>
                                        <?php if(count($moslem_worship_places_nearby) > 0): ?>
                                            <div id="accordion" class="accordion">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                            data-bs-target="#heading_mostlem_worship_place"
                                                            aria-expanded="true" role="button">
                                                            <span>Moslem Worship Places Nearby </span>

                                                        </div>
                                                    </div>


                                                    <div id="heading_mostlem_worship_place" class="collapse"
                                                        data-bs-parent="#accordion">
                                                        <div class="card-body">


                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <ul class="ameniting-list">
                                                                        <?php $__currentLoopData = $moslem_worship_places_nearby; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $moslem_worship_place): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li><i class="fas fa-check-circle"></i>
                                                                                <b>Name : &nbsp; </b>
                                                                                <?php echo e($moslem_worship_place['place_name']); ?>

                                                                                | &nbsp; <b>Distance :</b> |
                                                                                <?php echo e($moslem_worship_place['place_distance']); ?>

                                                                                &nbsp; <b>Time </b>
                                                                                : <?php echo e($moslem_worship_place['place_time']); ?>

                                                                                | &nbsp; <b> Address : </b>
                                                                                <?php echo e($moslem_worship_place['place_address']); ?>

                                                                            </li><hr>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                </div>


                                                            </div>


                                                        </div>


                                                    </div>
                                                </div>



                                            </div>
                                        <?php else: ?>
                                            
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    
                                </div>
                                


                            </div>
                        </div>
                        

                        
                        <div class="col-lg-4 widget-break-lg sidebar-widget">

                            

                            <div class="widget widget-contact-box">
                                <h3 class="widget-subtitle">Book this apartment</h3>


                                <form action="<?php echo e(route('bookings.store')); ?>" method="POST"
                                    enctype="multipart/form-data" class="contact-box">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="first_name"
                                                placeholder="Your First Name" />

                                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="last_name"
                                                placeholder="Last Name" />
                                            <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="email"
                                                placeholder="E-mail" />
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="nationality"
                                                placeholder="Enter Your Nationality" />
                                            <?php $__errorArgs = ['nationality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="current_address"
                                                placeholder="Enter Current Address" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="phone_number"
                                                placeholder="Enter Phone Number" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="date" class="form-control" name="arrival_date"
                                                placeholder="Enter arrival date" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="hidden" class="form-control" name="apartment_id"
                                                value=" <?php echo e($apartment->id); ?>" placeholder="Enter apartment id" />
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <textarea name="message" id="message" class="form-text" placeholder="Message" cols="30" rows="4"></textarea>
                                    </div>


                                    

                                    <?php if($apartment->units_available > 0): ?>
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <button type="submit" class="item-btn">
                                                    BOOK NOW <i class="fas fa-envelope"></i>
                                                </button>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <center>
                                                    <button type="submit" class="btn btn-danger" disabled>
                                                        ALL APARTMENT UNITS BOOKED

                                                    </button>
                                                    <br>
                                                    <span> You cannot book it.</span>
                                                </center>
                                            </div>
                                        </div>
                                    <?php endif; ?>


                            </div>
                            <div class="form-response"></div>
                            </form>

                            



                            
                            
                            

                            <hr>


                            
                            <?php if(!empty($apartment->google_map_iframe_url)): ?>
                                <div class="overview-area map-box">
                                    <h3 class="widget-subtitle">Google map </h3>
                                    <div class="item-map">
                                        <iframe src="<?php echo e($apartment->google_map_iframe_url); ?>" width="100%"
                                            height="349" style="border: 0" allowfullscreen="" loading="lazy"></iframe>
                                    </div>
                                </div>
                            <?php else: ?>
                                <center><span>No Property Map Added </span></center>
                            <?php endif; ?>

                            <hr>

                            


                        </div>



                    </div>
                    
                </div>
            </div>
        </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend/layouts_frontend/master_frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/frontend/pages_frontend/apartments/show.blade.php ENDPATH**/ ?>