<?php $__env->startSection('title'); ?>
    Trashed Apartment Categories
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Apartment Categories <span
                                class="text-muted fw-normal ms-2">(<?php echo e($count_trashed_apartment_categories); ?>)</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-category-list')): ?>
                                <a href="/admin/apartment_categories" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    All Apartment Category</a>

                            <?php endif; ?>
                        </div>

                       


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH amenities -->
            
            <!-- FETCH FEEDBACKS -->
            
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagedelete')): ?>
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    <?php echo e(session('messagedelete')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                
            <?php endif; ?>

            
            <?php if(session('messageupdate')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messageupdate')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

                
                <?php if(session('messagerestore')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagerestore')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            <th scope="col">#ID</th>
                            <th scope="col">Category Name</th>
                            <th scope="col">Category Description</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__empty_1 = true; $__currentLoopData = $trashed_apartment_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apartment_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>

                                <td><?php echo e($apartment_category->id); ?></td>
                                <td>
                                    <a href="#" class="text-body">
                                        <?php if(!empty($apartment_category->category_name)): ?>
                                        <?php echo e($apartment_category->category_name); ?>


                                        <?php else: ?>
                                        <span>N/A</span>
                                        <?php endif; ?>
                                        
                                    </a>
                                </td>
                                <td>
                                    <?php if(!empty($apartment_category->category_description)): ?>
                                        <?php echo e($apartment_category->category_description); ?>


                                        <?php else: ?>
                                        <span>N/A</span>
                                        <?php endif; ?>
                                </td>

                                <td>
                                    <?php if(!empty($apartment_category->category_description)): ?>
                                        <?php echo e($apartment_category->user->name); ?>


                                        <?php else: ?>
                                        <span>N/A</span>
                                        <?php endif; ?>
                                </td>


                                <td colspan="6">
                                    <div class="row">


                                        <!-- delete  -->

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-category-restore')): ?>
                                            <div class="col-md-4">
                                                <form action="<?php echo e(route('apartment_categories.restore', $apartment_category->id)); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('POST'); ?>
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-arrow-left"> </button> </a>

                                                </form>
                                            </div>
                                        <?php endif; ?>


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewapartment_categoryDetails<?php echo e($apartment_category->id); ?>" tabindex="-1"
                                aria-labelledby="viewapartment_categoryDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartment_categoryDetailsLabel"> Category
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">


                                            <p> Name : <?php echo e($apartment_category->category_name); ?></p>
                                            <hr>

                                            <p> Description : <?php echo e($apartment_category->category_description); ?></p>
                                            <hr>



                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-category-edit')): ?>
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editapartment_category<?php echo e($apartment_category->id); ?>"
                                                data-bs-whatever="@getbootstrap">Edit Category
                                            </button>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            
                            <div class="modal fade" id="editapartment_category<?php echo e($apartment_category->id); ?>" tabindex="-1"
                                aria-labelledby="editapartment_categoryLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartment_categoryDetailsLabel">Edit Apartment Category
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE  CATEGORIES -->

                                            <form action="<?php echo e(route('apartment_categories.update', $apartment_category->id)); ?>" method="post"
                                                enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <div class="mb-3">
                                                    <label for="recipient-name" class="col-form-label">Name:</label>
                                                    <input type="text" class="form-control" name="category_name"
                                                        value="<?php echo e($apartment_category->category_name); ?>" id="recipient-name">
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="validationCustom01">Description</label>
            
                                                        <textarea class="form-control" name="category_description" id="exampleFormControlTextarea5"
                                                            placeholder="Describe the ammenity" rows="3"><?php echo e($apartment_category->category_description); ?></textarea>
                                                        <div>
                                                            <?php $__errorArgs = ['category_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    </div>
            
                                                </div>


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        Category</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No category available!</span>
                            </center>
                        <?php endif; ?>

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/apartment_categories/trashed_apartment_categories.blade.php ENDPATH**/ ?>