<?php $__env->startSection('title'); ?>
    Add user
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Add User</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/users/create">Add User</a> > <a
                                        href="/users">View Users</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->






            

            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-6">
                    <?php echo Form::open(['route' => 'users.store', 'method' => 'POST']); ?>

                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="form-group">
                                <strong>Name:</strong>
                                <?php echo Form::text('name', null, ['placeholder' => 'Name', 'class' => 'form-control']); ?>

                                <?php if($errors->has('name')): ?>
                                    <span class="text-danger text-left"><?php echo e($errors->first('name')); ?></span>
                                <?php endif; ?>
                                <br>

                            </div>

                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="form-group">
                                <strong>Email:</strong>
                                <?php echo Form::text('email', null, ['placeholder' => 'Email', 'class' => 'form-control']); ?>

                                <?php if($errors->has('email')): ?>
                                    <span class="text-danger text-left"><?php echo e($errors->first('email')); ?></span>
                                <?php endif; ?>
                                <br>
                            </div>
                        </div>

                      

                        
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="form-group">
                                <strong>User Category:</strong>
                                <select name="tour_category_id" class="form-select" id="show_customer_fields">
                                    <option value="admin">Administrator </option>
                                    <option value="customer" >Customer </option>
                                    
                                </select>


                                <br>
                            </div>
                        </div>

                        
                        <div class="col-xs-12 col-sm-12 col-md-12" id="customer_fields" style="display: none;">
                            <div class="form-group">
                                <label class="form-label" for="validationCustom01">Religion</label>
                                <select name="religion" class="form-select" id="show_customer_fields">
                                    <option value="christian">Christian </option>
                                    <option value="moslem" >Moslem </option>
                                    
                                </select><br>
                            </div>
                        </div><br>

                        

                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="form-group">
                                <strong>Password:</strong>
                                <?php echo Form::password('password', ['placeholder' => 'Password', 'class' => 'form-control']); ?>

                                <?php if($errors->has('password')): ?>
                                    <span class="text-danger text-left"><?php echo e($errors->first('password')); ?></span>
                                <?php endif; ?>
                                <br>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="form-group">
                                <strong>Confirm Password:</strong>
                                <?php echo Form::password('confirm-password', ['placeholder' => 'Confirm Password', 'class' => 'form-control']); ?>


                                <br>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="form-group">
                                <strong>Role:</strong>
                                <?php echo Form::select('roles[]', $roles, [], ['class' => 'form-control', 'multiple']); ?>

                                <?php if($errors->has('roles')): ?>
                                    <span class="text-danger text-left"><?php echo e($errors->first('roles')); ?></span>
                                <?php endif; ?>
                                <br>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <button type="submit" class="btn btn-primary">Add User</button>
                        </div>
                    </div><br><br>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-3"></div>
            </div>


            


        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_scripts'); ?>
    <script>
    $(document).ready(function() {
        // Listen for change event on the select element
        $('#show_customer_fields').change(function() {
            // Check the selected value
            if ($(this).val() === 'customer') {
                // If Option 2 is selected, display the input field
                $('#customer_fields').show();
            } else {
                // If any other option is selected, hide the input field
                $('#customer_fields').hide();
            }
        });
    });


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/users/create.blade.php ENDPATH**/ ?>