<?php $__env->startSection('title'); ?>
    Trashed Apartments
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Trashed Apartments <span
                                class="text-muted fw-normal ms-2">(<?php echo e($count_trashed_apartments); ?>)</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-list')): ?>
                                <a href="/admin/apartments" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    All Apartments</a>
                            <?php endif; ?>
                        </div>




                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH apartments -->
            
            <!-- FETCH FEEDBACKS -->
            
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagedelete')): ?>
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    <?php echo e(session('messagedelete')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                
            <?php endif; ?>

            
            <?php if(session('messageupdate')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messageupdate')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagerestore')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagerestore')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            
                            <th scope="col"> Unique ID</th>
                            <th scope="col">Apartment Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Price</th>
                            <th scope="col">Price Range</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__empty_1 = true; $__currentLoopData = $trashed_apartments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apartment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>

                                
                                <td><?php echo e($apartment->unique_id); ?></td>

                                <td>
                                    <?php if(!empty($apartment->name)): ?>
                                        <?php echo e($apartment->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($apartment->apartment_category->category_name)): ?>
                                        <?php echo e($apartment->apartment_category->category_name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($apartment->price)): ?>
                                        <?php echo e($apartment->price); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>

                                <td>


                                    <?php if(!empty($apartment->price_range)): ?>
                                        <?php if($apartment->price_range == '1000_2000'): ?>
                                            <?php echo e('1000 - 2000 '); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == '2000_3000'): ?>
                                            <?php echo e('2000 - 3000'); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == '3000_4000'): ?>
                                            <?php echo e('3000 - 4000'); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == '4000_5000'): ?>
                                            <?php echo e('4000 - 5000'); ?>

                                        <?php endif; ?>

                                        <?php if($apartment->price_range == 'null'): ?>
                                            <?php echo e('N/A'); ?>

                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span> N/A </span>
                                    <?php endif; ?>

                                </td>
                                <td>
                                    <?php if(!empty($apartment->user->name)): ?>
                                        <?php echo e($apartment->user->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        <!-- delete  -->
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-restore')): ?>
                                            <div class="col-md-4">
                                                <form action="<?php echo e(route('apartments.restore', $apartment->id)); ?>"
                                                    method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('POST'); ?>
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-arrow-left"> </button> </a>
                                                </form>
                                            </div>
                                        <?php endif; ?>


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewapartmentDetails<?php echo e($apartment->id); ?>" tabindex="-1"
                                aria-labelledby="viewapartmentDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel"> Apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            
                                            <p>Featured Photo </p>
                                            <hr>

                                            <a href="<?php echo asset($apartment->featured_photo); ?>">
                                                <img onerror="if (this.src != '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>') this.src = '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>';"
                                                    src="<?php echo e(asset($apartment->featured_photo)); ?>" alt="preview"
                                                    style=" width:100% !important; object-fit:cover;">
                                            </a>
                                            <hr>

                                            <p> Property Name : <?php echo e($apartment->name); ?></p>
                                            <hr>
                                            <p> Amenities </p>
                                            <hr>
                                            <div class="row">
                                                <?php $__empty_2 = true; $__currentLoopData = $apartment->amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                    <div class="col-lg-6">
                                                        <div class="card bg-primary border-primary text-white-50">
                                                            <div class="card-body">
                                                                <h5 class="mb-3 text-white text-center">
                                                                    <?php echo e($amenity->name); ?></h5>
                                                                
                                                            </div>
                                                        </div>
                                                    </div>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>

                                                    <span style="color:red;">No Amenities Available </span>
                                                <?php endif; ?>

                                            </div>

                                            <hr>
                                            <p>Property 3D Video </p>
                                            <div class="card-body">
                                                <!-- 16:9 aspect ratio -->
                                                <div class="ratio ratio-16x9">
                                                    
                                                    <iframe width="130" height="175"
                                                        src=" <?php echo e($apartment->property_video_url); ?>"
                                                        allowfullscreen="allowfullscreen"
                                                        mozallowfullscreen="mozallowfullscreen"
                                                        msallowfullscreen="msallowfullscreen"
                                                        oallowfullscreen="oallowfullscreen"
                                                        webkitallowfullscreen="webkitallowfullscreen">
                                                    </iframe>
                                                </div>
                                            </div>


                                            <hr>
                                            
                                            <div class="card" style="margin-top:20px;">
                                                <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                                    <center>Apartment Photos Collection</center>
                                                </div>
                                                <div class="card-body">

                                                    <div class="row">

                                                        
                                                        <?php if(!empty($apartment->photo_library)): ?>
                                                            <?php $__currentLoopData = is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                
                                                                <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                    <a href="<?php echo asset($image); ?>">
                                                                        <img style="
                                                                            height: 200px; 
                                                                            background-color:#ffffff; 
                                                                            object-fit:cover;
                                                                            max-width:100% !important;
                                                                            border:#ffffff 2px solid;
                                                                            background-repeat: no-repeat;
                                                                            object-position: center center;
                                                                            background-size:cover;
                                                                            padding:7px; 
                                                                            margin:0px;"
                                                                            src="<?php echo e(asset($image)); ?>" alt="">
                                                                    </a>


                                                                </div>
                                                                
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <center><span>No Photos Available <span></center>
                                                        <?php endif; ?>
                                                        


                                                    </div>


                                                </div>
                                            </div>

                                            



                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-edit')): ?>
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editapartment<?php echo e($apartment->id); ?>"
                                                    data-bs-whatever="@getbootstrap">Edit apartment
                                                </button>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            
                            <div class="modal fade" id="editapartment<?php echo e($apartment->id); ?>" tabindex="-1"
                                aria-labelledby="editapartmentLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel">Edit apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE  CATEGORIES -->

                                            <form action="<?php echo e(route('apartments.update', $apartment->id)); ?>"
                                                method="post" enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <div class="mb-3">
                                                    <label for="recipient-name" class="col-form-label">Name:</label>
                                                    <input type="text" class="form-control" name="name"
                                                        value="<?php echo e($apartment->name); ?>" id="recipient-name">
                                                </div>


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        apartment</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No apartments available!</span>
                            </center>
                        <?php endif; ?>

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/apartments/trashed_apartments.blade.php ENDPATH**/ ?>