<?php $__env->startSection('title'); ?>
    All Permissions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Permissions</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/admin/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/admin/permissions/create">Add Permission</a>  > 
                               <a href="/admin/permissions">View Permissions</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Page content starts here -->

            <div class="justify-content-center">
  
            
            <?php if(session('messagesave')): ?>
            
            <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
               <i class="mdi mdi-check-all label-icon"></i>
               <?php echo e(session('messagesave')); ?>

               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
           <?php endif; ?>

            
             <?php if(session('messagedelete')): ?>
            <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
               <i class="mdi mdi-block-helper label-icon"></i>
               <?php echo e(session('messagedelete')); ?>

               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
             
            <?php endif; ?>

            
             <?php if(session('messageupdate')): ?>
            <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
               <i class="mdi mdi-check-all label-icon"></i>
               <?php echo e(session('messageupdate')); ?>

               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
           <?php endif; ?>

                <div class="card">
                    
                    <div class="card-body">
                        <table class="table table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Description</th>
                                    <th width="280px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($permission->id); ?></td>
                                        <td><?php echo e($permission->name); ?></td>
                                        <td><?php echo e($permission->description); ?></td>
                                        <td>
                                            <a class="btn btn-success"
                                                href="<?php echo e(route('permissions.show', $permission->id)); ?>">Show</a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-edit')): ?>
                                                <a class="btn btn-primary"
                                                    href="<?php echo e(route('permissions.edit', $permission->id)); ?>">Edit</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-delete')): ?>
                                                <?php echo Form::open([
                                                    'method' => 'DELETE',
                                                    'route' => ['permissions.destroy', $permission->id],
                                                    'style' => 'display:inline',
                                                ]); ?>

                                                <?php echo Form::submit('Delete', ['class' => 'btn btn-danger']); ?>

                                                <?php echo Form::close(); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        
                        

                    </div>
                </div>
            </div>






        </div>
        <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/permissions/index.blade.php ENDPATH**/ ?>